/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.IntRange;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.AppOpsManager;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.Immutable;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

@Immutable
public class SyncNotedAppOp
implements Parcelable {
    private final int mOpMode;
    private final int mOpCode;
    @Nullable
    private final String mAttributionTag;
    @Nullable
    private final String mPackageName;
    @NonNull
    public static final Parcelable.Creator<SyncNotedAppOp> CREATOR = new Parcelable.Creator<SyncNotedAppOp>(){

        public SyncNotedAppOp[] newArray(int size) {
            return new SyncNotedAppOp[size];
        }

        @Override
        public SyncNotedAppOp createFromParcel(@NonNull Parcel in) {
            return new SyncNotedAppOp(in);
        }
    };

    public SyncNotedAppOp(int opMode, int opCode, @Nullable String attributionTag, @Nullable String packageName) {
        this.mOpCode = opCode;
        AnnotationValidations.validate(IntRange.class, null, this.mOpCode, "from", 0L, "to", 162L);
        this.mAttributionTag = attributionTag;
        this.mOpMode = opMode;
        this.mPackageName = packageName;
    }

    public SyncNotedAppOp(int opCode, @Nullable String attributionTag) {
        this(1, opCode, attributionTag, ActivityThread.currentPackageName());
    }

    public SyncNotedAppOp(int opCode, @Nullable String attributionTag, @Nullable String packageName) {
        this(1, opCode, attributionTag, packageName);
    }

    @NonNull
    public String getOp() {
        return AppOpsManager.opToPublicName(this.mOpCode);
    }

    public int getOpMode() {
        return this.mOpMode;
    }

    private String opCodeToString() {
        return this.getOp();
    }

    @Nullable
    public String getAttributionTag() {
        return this.mAttributionTag;
    }

    @Nullable
    public String getPackageName() {
        return this.mPackageName;
    }

    public String toString() {
        return "SyncNotedAppOp { opMode = " + this.mOpMode + ", opCode = " + this.opCodeToString() + ", attributionTag = " + this.mAttributionTag + ", packageName = " + this.mPackageName + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncNotedAppOp that = (SyncNotedAppOp)o;
        return this.mOpMode == that.mOpMode && this.mOpCode == that.mOpCode && Objects.equals(this.mAttributionTag, that.mAttributionTag) && Objects.equals(this.mPackageName, that.mPackageName);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mOpMode;
        _hash = 31 * _hash + this.mOpCode;
        _hash = 31 * _hash + Objects.hashCode(this.mAttributionTag);
        _hash = 31 * _hash + Objects.hashCode(this.mPackageName);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mAttributionTag != null) {
            flg = (byte)(flg | 4);
        }
        if (this.mPackageName != null) {
            flg = (byte)(flg | 8);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mOpMode);
        dest.writeInt(this.mOpCode);
        if (this.mAttributionTag != null) {
            dest.writeString(this.mAttributionTag);
        }
        if (this.mPackageName != null) {
            dest.writeString(this.mPackageName);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    SyncNotedAppOp(@NonNull Parcel in) {
        byte flg = in.readByte();
        int opMode = in.readInt();
        int opCode = in.readInt();
        String attributionTag = (flg & 4) == 0 ? null : in.readString();
        String packageName = (flg & 8) == 0 ? null : in.readString();
        this.mOpMode = opMode;
        this.mOpCode = opCode;
        AnnotationValidations.validate(IntRange.class, null, this.mOpCode, "from", 0L, "to", 162L);
        this.mAttributionTag = attributionTag;
        this.mPackageName = packageName;
    }

    @Deprecated
    private void __metadata() {
    }
}

