/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.ActivityTaskManager;
import android.app.IProcessObserver;
import android.content.Context;
import android.os.Binder;
import android.util.Log;
import java.util.List;
import java.util.concurrent.Executor;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
@SuppressLint(value={"ListenerInterface"})
public abstract class HomeVisibilityListener {
    private static final String TAG = HomeVisibilityListener.class.getSimpleName();
    private static final boolean DBG = Log.isLoggable(TAG, 3);
    private ActivityTaskManager mActivityTaskManager;
    private Executor mExecutor;
    private int mMaxScanTasksForHomeVisibility;
    IProcessObserver.Stub mObserver = new IProcessObserver.Stub(){

        @Override
        public void onProcessStarted(int pid, int processUid, int packageUid, String packageName, String processName) {
        }

        @Override
        public void onForegroundActivitiesChanged(int pid, int uid, boolean fg) {
            this.refreshHomeVisibility();
        }

        @Override
        public void onForegroundServicesChanged(int pid, int uid, int fgServiceTypes) {
        }

        @Override
        public void onProcessDied(int pid, int uid) {
            this.refreshHomeVisibility();
        }

        private void refreshHomeVisibility() {
            boolean isHomeActivityVisible = HomeVisibilityListener.this.isHomeActivityVisible();
            if (HomeVisibilityListener.this.mIsHomeActivityVisible != isHomeActivityVisible) {
                HomeVisibilityListener.this.mIsHomeActivityVisible = isHomeActivityVisible;
                Binder.withCleanCallingIdentity(() -> HomeVisibilityListener.this.mExecutor.execute(() -> HomeVisibilityListener.this.onHomeVisibilityChanged(HomeVisibilityListener.this.mIsHomeActivityVisible)));
            }
        }
    };
    boolean mIsHomeActivityVisible;

    void init(Context context, Executor executor) {
        this.mActivityTaskManager = ActivityTaskManager.getInstance();
        this.mExecutor = executor;
        this.mMaxScanTasksForHomeVisibility = context.getResources().getInteger(17694923);
        this.mIsHomeActivityVisible = this.isHomeActivityVisible();
    }

    public abstract void onHomeVisibilityChanged(boolean var1);

    private boolean isHomeActivityVisible() {
        List<ActivityManager.RunningTaskInfo> tasksTopToBottom = this.mActivityTaskManager.getTasks(this.mMaxScanTasksForHomeVisibility, true, false, 0);
        if (tasksTopToBottom == null || tasksTopToBottom.isEmpty()) {
            return false;
        }
        int taskSize = tasksTopToBottom.size();
        for (int i = 0; i < taskSize; ++i) {
            ActivityManager.RunningTaskInfo task = tasksTopToBottom.get(i);
            if (DBG) {
                Log.d(TAG, "Task#" + i + ": activity=" + task.topActivity + ", visible=" + task.isVisible() + ", flg=" + Integer.toHexString(task.baseIntent.getFlags()) + ", type=" + task.getActivityType());
            }
            if (!task.isVisible() || task.getActivityType() != 2) continue;
            return true;
        }
        return false;
    }
}

