/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CameraCompatTaskInfo
implements Parcelable {
    public static final int CAMERA_COMPAT_FREEFORM_UNSPECIFIED = 0;
    public static final int CAMERA_COMPAT_FREEFORM_NONE = 1;
    public static final int CAMERA_COMPAT_FREEFORM_PORTRAIT_DEVICE_IN_LANDSCAPE = 2;
    public static final int CAMERA_COMPAT_FREEFORM_LANDSCAPE_DEVICE_IN_LANDSCAPE = 3;
    public static final int CAMERA_COMPAT_FREEFORM_PORTRAIT_DEVICE_IN_PORTRAIT = 4;
    public static final int CAMERA_COMPAT_FREEFORM_LANDSCAPE_DEVICE_IN_PORTRAIT = 5;
    public int freeformCameraCompatMode;
    public static final Parcelable.Creator<CameraCompatTaskInfo> CREATOR = new Parcelable.Creator<CameraCompatTaskInfo>(){

        @Override
        public CameraCompatTaskInfo createFromParcel(Parcel in) {
            return new CameraCompatTaskInfo(in);
        }

        public CameraCompatTaskInfo[] newArray(int size) {
            return new CameraCompatTaskInfo[size];
        }
    };

    private CameraCompatTaskInfo() {
    }

    @NonNull
    static CameraCompatTaskInfo create() {
        return new CameraCompatTaskInfo();
    }

    private CameraCompatTaskInfo(Parcel source) {
        this.readFromParcel(source);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    void readFromParcel(Parcel source) {
        this.freeformCameraCompatMode = source.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.freeformCameraCompatMode);
    }

    public boolean equalsForTaskOrganizer(@Nullable CameraCompatTaskInfo that) {
        if (that == null) {
            return false;
        }
        return this.freeformCameraCompatMode == that.freeformCameraCompatMode;
    }

    public boolean equalsForCompatUi(@Nullable CameraCompatTaskInfo that) {
        if (that == null) {
            return false;
        }
        return this.freeformCameraCompatMode == that.freeformCameraCompatMode;
    }

    public String toString() {
        return "CameraCompatTaskInfo { freeformCameraCompatMode=" + CameraCompatTaskInfo.freeformCameraCompatModeToString(this.freeformCameraCompatMode) + "}";
    }

    public static int getDisplayRotationFromCameraCompatMode(int cameraCompatMode) {
        int n;
        switch (cameraCompatMode) {
            case 2: 
            case 4: {
                n = 0;
                break;
            }
            case 3: 
            case 5: {
                n = 1;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    @NonNull
    public static String freeformCameraCompatModeToString(int freeformCameraCompatMode) {
        String string2;
        switch (freeformCameraCompatMode) {
            case 0: {
                string2 = "undefined";
                break;
            }
            case 1: {
                string2 = "inactive";
                break;
            }
            case 2: {
                string2 = "app-portrait-device-landscape";
                break;
            }
            case 3: {
                string2 = "app-landscape-device-landscape";
                break;
            }
            case 4: {
                string2 = "app-portrait-device-portrait";
                break;
            }
            case 5: {
                string2 = "app-landscape-device-portrait";
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected camera compat mode: " + freeformCameraCompatMode));
            }
        }
        return string2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FreeformCameraCompatMode {
    }
}

