/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.notification.ZenDeviceEffects;
import android.service.notification.ZenPolicy;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Objects;

public class AutomaticZenRule
implements Parcelable {
    private static final int ENABLED = 1;
    private static final int DISABLED = 0;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_OTHER = 0;
    public static final int TYPE_SCHEDULE_TIME = 1;
    public static final int TYPE_SCHEDULE_CALENDAR = 2;
    public static final int TYPE_BEDTIME = 3;
    public static final int TYPE_DRIVING = 4;
    public static final int TYPE_IMMERSIVE = 5;
    public static final int TYPE_THEATER = 6;
    public static final int TYPE_MANAGED = 7;
    public static final int FIELD_NAME = 1;
    public static final int FIELD_INTERRUPTION_FILTER = 2;
    public static final int FIELD_ICON = 4;
    private boolean enabled;
    private String name;
    private int interruptionFilter;
    private Uri conditionId;
    private ComponentName owner;
    private ComponentName configurationActivity;
    private long creationTime;
    private ZenPolicy mZenPolicy;
    private ZenDeviceEffects mDeviceEffects;
    private String mPkg;
    private int mType = -1;
    private int mIconResId;
    private String mTriggerDescription;
    private boolean mAllowManualInvocation;
    public static final int MAX_STRING_LENGTH = 500;
    public static final int MAX_DESC_LENGTH = 150;
    @NonNull
    public static final Parcelable.Creator<AutomaticZenRule> CREATOR = new Parcelable.Creator<AutomaticZenRule>(){

        @Override
        public AutomaticZenRule createFromParcel(Parcel source) {
            return new AutomaticZenRule(source);
        }

        public AutomaticZenRule[] newArray(int size) {
            return new AutomaticZenRule[size];
        }
    };

    @Deprecated
    public AutomaticZenRule(String name, ComponentName owner, Uri conditionId, int interruptionFilter, boolean enabled) {
        this(name, owner, null, conditionId, null, interruptionFilter, enabled);
    }

    public AutomaticZenRule(@NonNull String name, @Nullable ComponentName owner, @Nullable ComponentName configurationActivity, @NonNull Uri conditionId, @Nullable ZenPolicy policy, int interruptionFilter, boolean enabled) {
        this.name = AutomaticZenRule.getTrimmedString(name);
        this.owner = AutomaticZenRule.getTrimmedComponentName(owner);
        this.configurationActivity = AutomaticZenRule.getTrimmedComponentName(configurationActivity);
        this.conditionId = AutomaticZenRule.getTrimmedUri(conditionId);
        this.interruptionFilter = interruptionFilter;
        this.enabled = enabled;
        this.mZenPolicy = policy;
    }

    @Deprecated
    public AutomaticZenRule(String name, ComponentName owner, ComponentName configurationActivity, Uri conditionId, ZenPolicy policy, int interruptionFilter, boolean enabled, long creationTime) {
        this(name, owner, configurationActivity, conditionId, policy, interruptionFilter, enabled);
        this.creationTime = creationTime;
    }

    public AutomaticZenRule(Parcel source) {
        boolean bl = this.enabled = source.readInt() == 1;
        if (source.readInt() == 1) {
            this.name = AutomaticZenRule.getTrimmedString(source.readString8());
        }
        this.interruptionFilter = source.readInt();
        this.conditionId = AutomaticZenRule.getTrimmedUri(source.readParcelable(null, Uri.class));
        this.owner = AutomaticZenRule.getTrimmedComponentName(source.readParcelable(null, ComponentName.class));
        this.configurationActivity = AutomaticZenRule.getTrimmedComponentName(source.readParcelable(null, ComponentName.class));
        this.creationTime = source.readLong();
        this.mZenPolicy = source.readParcelable(null, ZenPolicy.class);
        this.mPkg = source.readString8();
        this.mDeviceEffects = source.readParcelable(null, ZenDeviceEffects.class);
        this.mAllowManualInvocation = source.readBoolean();
        this.mIconResId = source.readInt();
        this.mTriggerDescription = AutomaticZenRule.getTrimmedString(source.readString8(), 150);
        this.mType = source.readInt();
    }

    public ComponentName getOwner() {
        return this.owner;
    }

    @Nullable
    public ComponentName getConfigurationActivity() {
        return this.configurationActivity;
    }

    public Uri getConditionId() {
        return this.conditionId;
    }

    public int getInterruptionFilter() {
        return this.interruptionFilter;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public ZenPolicy getZenPolicy() {
        return this.mZenPolicy == null ? null : this.mZenPolicy.copy();
    }

    @Nullable
    public ZenDeviceEffects getDeviceEffects() {
        return this.mDeviceEffects;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setConditionId(Uri conditionId) {
        this.conditionId = AutomaticZenRule.getTrimmedUri(conditionId);
    }

    public void setInterruptionFilter(int interruptionFilter) {
        this.interruptionFilter = interruptionFilter;
    }

    public void setName(String name) {
        this.name = AutomaticZenRule.getTrimmedString(name);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setZenPolicy(@Nullable ZenPolicy zenPolicy) {
        this.mZenPolicy = zenPolicy == null ? null : zenPolicy.copy();
    }

    public void setDeviceEffects(@Nullable ZenDeviceEffects deviceEffects) {
        this.mDeviceEffects = deviceEffects;
    }

    public void setOwner(@Nullable ComponentName owner) {
        this.owner = owner;
    }

    public void setConfigurationActivity(@Nullable ComponentName componentName) {
        this.configurationActivity = AutomaticZenRule.getTrimmedComponentName(componentName);
    }

    public void setPackageName(String pkgName) {
        this.mPkg = pkgName;
    }

    public String getPackageName() {
        return this.mPkg;
    }

    public int getType() {
        return this.mType;
    }

    public void setType(int type) {
        this.mType = AutomaticZenRule.checkValidType(type);
    }

    @Nullable
    public String getTriggerDescription() {
        return this.mTriggerDescription;
    }

    public void setTriggerDescription(@Nullable String triggerDescription) {
        this.mTriggerDescription = triggerDescription;
    }

    public int getIconResId() {
        return this.mIconResId;
    }

    public void setIconResId(int iconResId) {
        this.mIconResId = iconResId;
    }

    public boolean isManualInvocationAllowed() {
        return this.mAllowManualInvocation;
    }

    public void setManualInvocationAllowed(boolean allowManualInvocation) {
        this.mAllowManualInvocation = allowManualInvocation;
    }

    public void validate() {
        AutomaticZenRule.checkValidType(this.mType);
        if (this.mDeviceEffects != null) {
            this.mDeviceEffects.validate();
        }
    }

    private static int checkValidType(int type) {
        Preconditions.checkArgument(type >= -1 && type <= 7, "Rule type must be one of TYPE_UNKNOWN, TYPE_OTHER, TYPE_SCHEDULE_TIME, TYPE_SCHEDULE_CALENDAR, TYPE_BEDTIME, TYPE_DRIVING, TYPE_IMMERSIVE, TYPE_THEATER, or TYPE_MANAGED");
        return type;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.enabled ? 1 : 0);
        if (this.name != null) {
            dest.writeInt(1);
            dest.writeString8(this.name);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.interruptionFilter);
        dest.writeParcelable(this.conditionId, 0);
        dest.writeParcelable(this.owner, 0);
        dest.writeParcelable(this.configurationActivity, 0);
        dest.writeLong(this.creationTime);
        dest.writeParcelable(this.mZenPolicy, 0);
        dest.writeString8(this.mPkg);
        dest.writeParcelable(this.mDeviceEffects, 0);
        dest.writeBoolean(this.mAllowManualInvocation);
        dest.writeInt(this.mIconResId);
        dest.writeString8(this.mTriggerDescription);
        dest.writeInt(this.mType);
    }

    public String toString() {
        return AutomaticZenRule.class.getSimpleName() + '[' + "enabled=" + this.enabled + ",name=" + this.name + ",type=" + this.mType + ",interruptionFilter=" + this.interruptionFilter + ",pkg=" + this.mPkg + ",conditionId=" + this.conditionId + ",owner=" + this.owner + ",configActivity=" + this.configurationActivity + ",creationTime=" + this.creationTime + ",mZenPolicy=" + this.mZenPolicy + ",deviceEffects=" + this.mDeviceEffects + ",allowManualInvocation=" + this.mAllowManualInvocation + ",iconResId=" + this.mIconResId + ",triggerDescription=" + this.mTriggerDescription + ']';
    }

    public static String fieldsToString(int bitmask) {
        ArrayList<String> modified = new ArrayList<String>();
        if ((bitmask & 1) != 0) {
            modified.add("FIELD_NAME");
        }
        if ((bitmask & 2) != 0) {
            modified.add("FIELD_INTERRUPTION_FILTER");
        }
        if ((bitmask & 4) != 0) {
            modified.add("FIELD_ICON");
        }
        return "{" + String.join((CharSequence)",", modified) + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof AutomaticZenRule)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        AutomaticZenRule other = (AutomaticZenRule)o;
        return other.enabled == this.enabled && Objects.equals(other.name, this.name) && other.interruptionFilter == this.interruptionFilter && Objects.equals(other.conditionId, this.conditionId) && Objects.equals(other.owner, this.owner) && Objects.equals(other.mZenPolicy, this.mZenPolicy) && Objects.equals(other.configurationActivity, this.configurationActivity) && Objects.equals(other.mPkg, this.mPkg) && other.creationTime == this.creationTime && Objects.equals(other.mDeviceEffects, this.mDeviceEffects) && other.mAllowManualInvocation == this.mAllowManualInvocation && other.mIconResId == this.mIconResId && Objects.equals(other.mTriggerDescription, this.mTriggerDescription) && other.mType == this.mType;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.name, this.interruptionFilter, this.conditionId, this.owner, this.configurationActivity, this.mZenPolicy, this.mDeviceEffects, this.creationTime, this.mPkg, this.mAllowManualInvocation, this.mIconResId, this.mTriggerDescription, this.mType);
    }

    private static ComponentName getTrimmedComponentName(ComponentName cn) {
        if (cn == null) {
            return null;
        }
        return new ComponentName(AutomaticZenRule.getTrimmedString(cn.getPackageName()), AutomaticZenRule.getTrimmedString(cn.getClassName()));
    }

    private static String getTrimmedString(String input) {
        return AutomaticZenRule.getTrimmedString(input, 500);
    }

    private static String getTrimmedString(String input, int length) {
        if (input != null && input.length() > length) {
            return input.substring(0, length);
        }
        return input;
    }

    private static Uri getTrimmedUri(Uri input) {
        if (input != null && input.toString().length() > 500) {
            return Uri.parse(AutomaticZenRule.getTrimmedString(input.toString()));
        }
        return input;
    }

    public static class AzrWithId
    implements Parcelable {
        public final String mId;
        public final AutomaticZenRule mRule;
        public static final Parcelable.Creator<AzrWithId> CREATOR = new Parcelable.Creator<AzrWithId>(){

            @Override
            public AzrWithId createFromParcel(Parcel in) {
                return new AzrWithId(in.readString8(), in.readParcelable(AutomaticZenRule.class.getClassLoader(), AutomaticZenRule.class));
            }

            public AzrWithId[] newArray(int size) {
                return new AzrWithId[size];
            }
        };

        public AzrWithId(String id2, AutomaticZenRule rule) {
            this.mId = id2;
            this.mRule = rule;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeString8(this.mId);
            dest.writeParcelable(this.mRule, flags);
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    public static class Builder {
        private String mName;
        private ComponentName mOwner;
        private Uri mConditionId;
        private int mInterruptionFilter = 2;
        private boolean mEnabled = true;
        private ComponentName mConfigurationActivity = null;
        private ZenPolicy mPolicy = null;
        private ZenDeviceEffects mDeviceEffects = null;
        private int mType = -1;
        private String mDescription;
        private int mIconResId;
        private boolean mAllowManualInvocation;
        private long mCreationTime;
        private String mPkg;

        public Builder(@NonNull AutomaticZenRule rule) {
            this.mName = rule.getName();
            this.mOwner = rule.getOwner();
            this.mConditionId = rule.getConditionId();
            this.mInterruptionFilter = rule.getInterruptionFilter();
            this.mEnabled = rule.isEnabled();
            this.mConfigurationActivity = rule.getConfigurationActivity();
            this.mPolicy = rule.getZenPolicy();
            this.mDeviceEffects = rule.getDeviceEffects();
            this.mType = rule.getType();
            this.mDescription = rule.getTriggerDescription();
            this.mIconResId = rule.getIconResId();
            this.mAllowManualInvocation = rule.isManualInvocationAllowed();
            this.mCreationTime = rule.getCreationTime();
            this.mPkg = rule.getPackageName();
        }

        public Builder(@NonNull String name, @NonNull Uri conditionId) {
            this.mName = Objects.requireNonNull(name);
            this.mConditionId = Objects.requireNonNull(conditionId);
        }

        @NonNull
        public Builder setName(@NonNull String name) {
            this.mName = name;
            return this;
        }

        @NonNull
        public Builder setOwner(@Nullable ComponentName owner) {
            this.mOwner = owner;
            return this;
        }

        @NonNull
        public Builder setConditionId(@NonNull Uri conditionId) {
            this.mConditionId = conditionId;
            return this;
        }

        @NonNull
        public Builder setInterruptionFilter(int interruptionFilter) {
            this.mInterruptionFilter = interruptionFilter;
            return this;
        }

        @NonNull
        public Builder setEnabled(boolean enabled) {
            this.mEnabled = enabled;
            return this;
        }

        @NonNull
        public Builder setConfigurationActivity(@Nullable ComponentName configurationActivity) {
            this.mConfigurationActivity = configurationActivity;
            return this;
        }

        @NonNull
        public Builder setZenPolicy(@Nullable ZenPolicy policy) {
            this.mPolicy = policy;
            return this;
        }

        @NonNull
        public Builder setDeviceEffects(@Nullable ZenDeviceEffects deviceEffects) {
            this.mDeviceEffects = deviceEffects;
            return this;
        }

        @NonNull
        public Builder setType(int type) {
            this.mType = AutomaticZenRule.checkValidType(type);
            return this;
        }

        @NonNull
        public Builder setTriggerDescription(@Nullable String description) {
            this.mDescription = description;
            return this;
        }

        @NonNull
        public Builder setIconResId(int iconResId) {
            this.mIconResId = iconResId;
            return this;
        }

        @NonNull
        public Builder setManualInvocationAllowed(boolean allowManualInvocation) {
            this.mAllowManualInvocation = allowManualInvocation;
            return this;
        }

        @NonNull
        public Builder setCreationTime(long creationTime) {
            this.mCreationTime = creationTime;
            return this;
        }

        @NonNull
        public Builder setPackage(@NonNull String pkg) {
            this.mPkg = pkg;
            return this;
        }

        @NonNull
        public AutomaticZenRule build() {
            AutomaticZenRule rule = new AutomaticZenRule(this.mName, this.mOwner, this.mConfigurationActivity, this.mConditionId, this.mPolicy, this.mInterruptionFilter, this.mEnabled);
            rule.mDeviceEffects = this.mDeviceEffects;
            rule.creationTime = this.mCreationTime;
            rule.mType = this.mType;
            rule.mTriggerDescription = this.mDescription;
            rule.mIconResId = this.mIconResId;
            rule.mAllowManualInvocation = this.mAllowManualInvocation;
            rule.setPackageName(this.mPkg);
            return rule;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ModifiableField {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

