/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.annotation.Nullable;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.ArrayMap;
import android.view.Choreographer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class AnimationHandler {
    private static final String TAG = "AnimationHandler";
    private static final boolean LOCAL_LOGV = false;
    public final ArrayMap<AnimationFrameCallback, Long> mDelayedCallbackStartTime = new ArrayMap();
    public final ArrayList<AnimationFrameCallback> mAnimationCallbacks = new ArrayList();
    public final ArrayList<AnimationFrameCallback> mCommitCallbacks = new ArrayList();
    private AnimationFrameCallbackProvider mProvider;
    private static boolean sAnimatorPausingEnabled = AnimationHandler.isPauseBgAnimationsEnabledInSystemProperties();
    private static boolean sOverrideAnimatorPausingSystemProperty = false;
    private final ArrayList<Animator> mPausedAnimators = new ArrayList();
    private final ArrayList<WeakReference<Object>> mAnimatorRequestors = new ArrayList();
    private ArrayList<Runnable> mPendingEndAnimationListeners;
    private long mLastAnimationFrameVsyncId;
    private long mEndAnimationFrameVsyncId;
    private final Choreographer.FrameCallback mFrameCallback = new Choreographer.FrameCallback(){

        @Override
        public void doFrame(long frameTimeNanos) {
            AnimationHandler.this.doAnimationFrame(AnimationHandler.this.getProvider().getFrameTime());
            if (AnimationHandler.this.mAnimationCallbacks.size() > 0) {
                AnimationHandler.this.getProvider().postFrameCallback(this);
            }
        }
    };
    public static ThreadLocal<AnimationHandler> sAnimatorHandler = new ThreadLocal();
    private static AnimationHandler sTestHandler = null;
    private boolean mListDirty = false;
    private Choreographer.FrameCallback mPauser = frameTimeNanos -> {
        if (this.mAnimatorRequestors.size() > 0) {
            return;
        }
        for (int i = 0; i < this.mAnimationCallbacks.size(); ++i) {
            Animator animator2;
            AnimationFrameCallback callback = this.mAnimationCallbacks.get(i);
            if (!(callback instanceof Animator) || (animator2 = (Animator)((Object)callback)).getTotalDuration() != -1L || animator2.isPaused()) continue;
            this.mPausedAnimators.add(animator2);
            animator2.pause();
        }
    };

    public static AnimationHandler getInstance() {
        if (sTestHandler != null) {
            return sTestHandler;
        }
        AnimationHandler animatorHandler = sAnimatorHandler.get();
        if (animatorHandler == null) {
            animatorHandler = new AnimationHandler();
            sAnimatorHandler.set(animatorHandler);
        }
        return animatorHandler;
    }

    @Nullable
    public static AnimationHandler setTestHandler(@Nullable AnimationHandler handler) {
        AnimationHandler oldHandler = sTestHandler;
        sTestHandler = handler;
        return oldHandler;
    }

    private static boolean isPauseBgAnimationsEnabledInSystemProperties() {
        if (sOverrideAnimatorPausingSystemProperty) {
            return sAnimatorPausingEnabled;
        }
        return SystemProperties.getBoolean("framework.pause_bg_animations.enabled", true);
    }

    public static void setAnimatorPausingEnabled(boolean enable) {
        sAnimatorPausingEnabled = enable;
    }

    public static void setOverrideAnimatorPausingSystemProperty(boolean enable) {
        sOverrideAnimatorPausingSystemProperty = enable;
    }

    public static void removeRequestor(Object requestor) {
        AnimationHandler.getInstance().requestAnimatorsEnabledImpl(false, requestor);
    }

    public static void requestAnimatorsEnabled(boolean enable, Object requestor) {
        AnimationHandler.getInstance().requestAnimatorsEnabledImpl(enable, requestor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestAnimatorsEnabledImpl(boolean enable, Object requestor) {
        boolean wasEmpty = this.mAnimatorRequestors.isEmpty();
        AnimationHandler.setAnimatorPausingEnabled(AnimationHandler.isPauseBgAnimationsEnabledInSystemProperties());
        ArrayList<WeakReference<Object>> arrayList = this.mAnimatorRequestors;
        synchronized (arrayList) {
            if (enable) {
                WeakReference<Object> weakRef = null;
                for (int i = this.mAnimatorRequestors.size() - 1; i >= 0; --i) {
                    WeakReference<Object> ref = this.mAnimatorRequestors.get(i);
                    Object referent = ref.get();
                    if (referent == requestor) {
                        weakRef = ref;
                        continue;
                    }
                    if (referent != null) continue;
                    this.mAnimatorRequestors.remove(i);
                }
                if (weakRef == null) {
                    weakRef = new WeakReference<Object>(requestor);
                    this.mAnimatorRequestors.add(weakRef);
                }
            } else {
                for (int i = this.mAnimatorRequestors.size() - 1; i >= 0; --i) {
                    WeakReference<Object> ref = this.mAnimatorRequestors.get(i);
                    Object referent = ref.get();
                    if (referent != requestor && referent != null) continue;
                    this.mAnimatorRequestors.remove(i);
                }
            }
        }
        if (!sAnimatorPausingEnabled) {
            this.resumeAnimators();
            return;
        }
        boolean isEmpty = this.mAnimatorRequestors.isEmpty();
        if (wasEmpty != isEmpty) {
            if (!isEmpty) {
                this.resumeAnimators();
            } else {
                Choreographer.getInstance().postFrameCallbackDelayed(this.mPauser, Animator.getBackgroundPauseDelay());
            }
        }
    }

    private void resumeAnimators() {
        Choreographer.getInstance().removeFrameCallback(this.mPauser);
        for (int i = this.mPausedAnimators.size() - 1; i >= 0; --i) {
            this.mPausedAnimators.get(i).resume();
        }
        this.mPausedAnimators.clear();
    }

    public void setProvider(AnimationFrameCallbackProvider provider) {
        this.mProvider = provider == null ? new MyFrameCallbackProvider(this) : provider;
    }

    private AnimationFrameCallbackProvider getProvider() {
        if (this.mProvider == null) {
            this.mProvider = new MyFrameCallbackProvider(this);
        }
        return this.mProvider;
    }

    public void addAnimationFrameCallback(AnimationFrameCallback callback, long delay) {
        if (this.mAnimationCallbacks.size() == 0) {
            this.getProvider().postFrameCallback(this.mFrameCallback);
        }
        if (!this.mAnimationCallbacks.contains(callback)) {
            this.mAnimationCallbacks.add(callback);
        }
        if (delay > 0L) {
            this.mDelayedCallbackStartTime.put(callback, SystemClock.uptimeMillis() + delay);
        }
    }

    public void addOneShotCommitCallback(AnimationFrameCallback callback) {
        if (!this.mCommitCallbacks.contains(callback)) {
            this.mCommitCallbacks.add(callback);
        }
    }

    public void removeCallback(AnimationFrameCallback callback) {
        this.mCommitCallbacks.remove(callback);
        this.mDelayedCallbackStartTime.remove(callback);
        int id2 = this.mAnimationCallbacks.indexOf(callback);
        if (id2 >= 0) {
            this.mAnimationCallbacks.set(id2, null);
            this.mListDirty = true;
        }
    }

    public long getLastAnimationFrameVsyncId(long currentVsyncId) {
        return currentVsyncId == this.mEndAnimationFrameVsyncId && this.mLastAnimationFrameVsyncId != 0L ? this.mLastAnimationFrameVsyncId : currentVsyncId;
    }

    public void postEndAnimationCallback(Runnable notifyEndAnimation) {
        if (this.mPendingEndAnimationListeners == null) {
            this.mPendingEndAnimationListeners = new ArrayList();
        }
        this.mPendingEndAnimationListeners.add(notifyEndAnimation);
        if (this.mPendingEndAnimationListeners.size() > 1) {
            return;
        }
        Choreographer choreographer = Choreographer.getInstance();
        this.mLastAnimationFrameVsyncId = choreographer.getVsyncId();
        this.getProvider().postFrameCallback(frame -> {
            this.mEndAnimationFrameVsyncId = choreographer.getVsyncId();
            while (this.mPendingEndAnimationListeners.size() > 0) {
                this.mPendingEndAnimationListeners.remove(0).run();
            }
            this.mEndAnimationFrameVsyncId = 0L;
            this.mLastAnimationFrameVsyncId = 0L;
        });
    }

    void removePendingEndAnimationCallback(Runnable notifyEndAnimation) {
        if (this.mPendingEndAnimationListeners != null) {
            this.mPendingEndAnimationListeners.remove(notifyEndAnimation);
        }
    }

    public void doAnimationFrame(long frameTime) {
        long currentTime = SystemClock.uptimeMillis();
        int size = this.mAnimationCallbacks.size();
        for (int i = 0; i < size; ++i) {
            final AnimationFrameCallback callback = this.mAnimationCallbacks.get(i);
            if (callback == null || !this.isCallbackDue(callback, currentTime)) continue;
            callback.doAnimationFrame(frameTime);
            if (!this.mCommitCallbacks.contains(callback)) continue;
            this.getProvider().postCommitCallback(new Runnable(){

                @Override
                public void run() {
                    AnimationHandler.this.commitAnimationFrame(callback, AnimationHandler.this.getProvider().getFrameTime());
                }
            });
        }
        this.cleanUpList();
    }

    private void commitAnimationFrame(AnimationFrameCallback callback, long frameTime) {
        if (!this.mDelayedCallbackStartTime.containsKey(callback) && this.mCommitCallbacks.contains(callback)) {
            callback.commitAnimationFrame(frameTime);
            this.mCommitCallbacks.remove(callback);
        }
    }

    private boolean isCallbackDue(AnimationFrameCallback callback, long currentTime) {
        Long startTime = this.mDelayedCallbackStartTime.get(callback);
        if (startTime == null) {
            return true;
        }
        if (startTime < currentTime) {
            this.mDelayedCallbackStartTime.remove(callback);
            return true;
        }
        return false;
    }

    public static int getAnimationCount() {
        AnimationHandler handler = sTestHandler;
        if (handler == null) {
            handler = sAnimatorHandler.get();
        }
        if (handler == null) {
            return 0;
        }
        return handler.getCallbackSize();
    }

    public static void setFrameDelay(long delay) {
        AnimationHandler.getInstance().getProvider().setFrameDelay(delay);
    }

    public static long getFrameDelay() {
        return AnimationHandler.getInstance().getProvider().getFrameDelay();
    }

    void autoCancelBasedOn(ObjectAnimator objectAnimator) {
        for (int i = this.mAnimationCallbacks.size() - 1; i >= 0; --i) {
            AnimationFrameCallback cb = this.mAnimationCallbacks.get(i);
            if (cb == null || !objectAnimator.shouldAutoCancel(cb)) continue;
            ((Animator)((Object)this.mAnimationCallbacks.get(i))).cancel();
        }
    }

    private void cleanUpList() {
        if (this.mListDirty) {
            for (int i = this.mAnimationCallbacks.size() - 1; i >= 0; --i) {
                if (this.mAnimationCallbacks.get(i) != null) continue;
                this.mAnimationCallbacks.remove(i);
            }
            this.mListDirty = false;
        }
    }

    private int getCallbackSize() {
        int count = 0;
        int size = this.mAnimationCallbacks.size();
        for (int i = size - 1; i >= 0; --i) {
            if (this.mAnimationCallbacks.get(i) == null) continue;
            ++count;
        }
        return count;
    }

    private class MyFrameCallbackProvider
    implements AnimationFrameCallbackProvider {
        final Choreographer mChoreographer = Choreographer.getInstance();

        private MyFrameCallbackProvider(AnimationHandler animationHandler) {
        }

        @Override
        public void postFrameCallback(Choreographer.FrameCallback callback) {
            this.mChoreographer.postFrameCallback(callback);
        }

        @Override
        public void postCommitCallback(Runnable runnable) {
            this.mChoreographer.postCallback(4, runnable, null);
        }

        @Override
        public long getFrameTime() {
            return this.mChoreographer.getFrameTime();
        }

        @Override
        public long getFrameDelay() {
            return Choreographer.getFrameDelay();
        }

        @Override
        public void setFrameDelay(long delay) {
            Choreographer.setFrameDelay(delay);
        }
    }

    public static interface AnimationFrameCallbackProvider {
        public void postFrameCallback(Choreographer.FrameCallback var1);

        public void postCommitCallback(Runnable var1);

        public long getFrameTime();

        public long getFrameDelay();

        public void setFrameDelay(long var1);
    }

    public static interface AnimationFrameCallback {
        public boolean doAnimationFrame(long var1);

        public void commitAnimationFrame(long var1);
    }
}

