/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.ondevicepersonalization;

import android.adservices.ondevicepersonalization.CalleeMetadata;
import android.adservices.ondevicepersonalization.CallerMetadata;
import android.adservices.ondevicepersonalization.MeasurementWebTriggerEventParams;
import android.adservices.ondevicepersonalization.MeasurementWebTriggerEventParamsParcel;
import android.adservices.ondevicepersonalization.aidl.IOnDevicePersonalizationManagingService;
import android.adservices.ondevicepersonalization.aidl.IRegisterMeasurementEventCallback;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.OutcomeReceiver;
import android.os.SystemClock;
import com.android.federatedcompute.internal.util.AbstractServiceBinder;
import com.android.internal.annotations.VisibleForTesting;
import com.android.ondevicepersonalization.internal.util.LoggerFactory;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class OnDevicePersonalizationSystemEventManager {
    public static final String ON_DEVICE_PERSONALIZATION_SYSTEM_EVENT_SERVICE = "on_device_personalization_system_event_service";
    private static final String INTENT_FILTER_ACTION = "android.OnDevicePersonalizationService";
    private static final String ODP_MANAGING_SERVICE_PACKAGE_SUFFIX = "com.android.ondevicepersonalization.services";
    private static final String ALT_ODP_MANAGING_SERVICE_PACKAGE_SUFFIX = "com.google.android.ondevicepersonalization.services";
    private static final String TAG = OnDevicePersonalizationSystemEventManager.class.getSimpleName();
    private static final LoggerFactory.Logger sLogger = LoggerFactory.getLogger();
    private final AbstractServiceBinder<IOnDevicePersonalizationManagingService> mServiceBinder;
    private final Context mContext;

    public OnDevicePersonalizationSystemEventManager(Context context) {
        this(context, AbstractServiceBinder.getServiceBinderByIntent(context, INTENT_FILTER_ACTION, List.of(ODP_MANAGING_SERVICE_PACKAGE_SUFFIX, ALT_ODP_MANAGING_SERVICE_PACKAGE_SUFFIX), 0, IOnDevicePersonalizationManagingService.Stub::asInterface));
    }

    @VisibleForTesting
    public OnDevicePersonalizationSystemEventManager(Context context, AbstractServiceBinder<IOnDevicePersonalizationManagingService> serviceBinder) {
        this.mContext = context;
        this.mServiceBinder = serviceBinder;
    }

    @RequiresPermission(value="android.permission.ondevicepersonalization.NOTIFY_MEASUREMENT_EVENT")
    public void notifyMeasurementEvent(@NonNull MeasurementWebTriggerEventParams measurementWebTriggerEvent, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, Exception> receiver) {
        Objects.requireNonNull(measurementWebTriggerEvent);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        final long startTimeMillis = SystemClock.elapsedRealtime();
        final IOnDevicePersonalizationManagingService service = this.mServiceBinder.getService(executor);
        try {
            Bundle bundle = new Bundle();
            bundle.putParcelable("android.adservices.ondevicepersonalization.measurement_web_trigger_params", new MeasurementWebTriggerEventParamsParcel(measurementWebTriggerEvent));
            service.registerMeasurementEvent(1, bundle, new CallerMetadata.Builder().setStartTimeMillis(startTimeMillis).build(), new IRegisterMeasurementEventCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(CalleeMetadata calleeMetadata) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> receiver.onResult(null));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                        OnDevicePersonalizationSystemEventManager.this.logApiCallStats(service, "", 22, SystemClock.elapsedRealtime() - startTimeMillis, calleeMetadata.getServiceEntryTimeMillis() - startTimeMillis, SystemClock.elapsedRealtime() - calleeMetadata.getCallbackInvokeTimeMillis(), 0);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onError(int errorCode, CalleeMetadata calleeMetadata) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> receiver.onError(new IllegalStateException("Error: " + errorCode)));
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                        OnDevicePersonalizationSystemEventManager.this.logApiCallStats(service, "", 22, SystemClock.elapsedRealtime() - startTimeMillis, calleeMetadata.getServiceEntryTimeMillis() - startTimeMillis, SystemClock.elapsedRealtime() - calleeMetadata.getCallbackInvokeTimeMillis(), errorCode);
                    }
                }
            });
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.logApiCallStats(service, "", 22, SystemClock.elapsedRealtime() - startTimeMillis, 0L, 0L, 100);
            throw e;
        }
        catch (Exception e) {
            this.logApiCallStats(service, "", 22, SystemClock.elapsedRealtime() - startTimeMillis, 0L, 0L, 100);
            receiver.onError(e);
        }
    }

    private void logApiCallStats(IOnDevicePersonalizationManagingService service, String sdkPackageName, int apiName, long latencyMillis, long rpcCallLatencyMillis, long rpcReturnLatencyMillis, int responseCode) {
        try {
            if (service != null) {
                service.logApiCallStats(sdkPackageName, apiName, latencyMillis, rpcCallLatencyMillis, rpcReturnLatencyMillis, responseCode);
            }
        }
        catch (Exception e) {
            sLogger.e(e, TAG + ": Error logging API call stats");
        }
    }
}

