/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.adservices.common.AdServicesResponse;
import android.annotation.NonNull;
import android.os.LimitExceededException;
import com.android.adservices.shared.common.exception.ProviderServiceInternalException;
import com.android.adservices.shared.common.exception.ProviderServiceTaskCancelledException;
import com.android.adservices.shared.common.exception.ServiceUnavailableException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.TimeoutException;

public class AdServicesStatusUtils {
    public static final int STATUS_UNSET = -1;
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_INTERNAL_ERROR = 1;
    public static final int STATUS_INVALID_ARGUMENT = 2;
    public static final int STATUS_UNKNOWN_ERROR = 3;
    public static final int STATUS_IO_ERROR = 4;
    public static final int STATUS_RATE_LIMIT_REACHED = 5;
    public static final int STATUS_KILLSWITCH_ENABLED = 6;
    public static final int STATUS_USER_CONSENT_REVOKED = 7;
    public static final int STATUS_ADSERVICES_DISABLED = 8;
    public static final int STATUS_PERMISSION_NOT_REQUESTED = 9;
    public static final int STATUS_CALLER_NOT_ALLOWED = 10;
    public static final int STATUS_BACKGROUND_CALLER = 11;
    public static final int STATUS_UNAUTHORIZED = 12;
    public static final int STATUS_TIMEOUT = 13;
    public static final int STATUS_JS_SANDBOX_UNAVAILABLE = 14;
    public static final int STATUS_INVALID_OBJECT = 15;
    public static final int STATUS_CALLER_NOT_ALLOWED_TO_CROSS_USER_BOUNDARIES = 16;
    public static final int STATUS_SERVER_RATE_LIMIT_REACHED = 17;
    public static final int STATUS_USER_CONSENT_NOTIFICATION_NOT_DISPLAYED_YET = 18;
    public static final int STATUS_ENCRYPTION_FAILURE = 19;
    public static final int STATUS_CALLER_NOT_ALLOWED_PACKAGE_NOT_IN_ALLOWLIST = 20;
    public static final int STATUS_CALLER_NOT_ALLOWED_PACKAGE_BLOCKLISTED = 21;
    public static final int STATUS_CALLER_NOT_ALLOWED_ENROLLMENT_MATCH_NOT_FOUND = 22;
    public static final int STATUS_CALLER_NOT_ALLOWED_ENROLLMENT_INVALID_ID = 23;
    public static final int STATUS_CALLER_NOT_ALLOWED_ENROLLMENT_BLOCKLISTED = 24;
    public static final int STATUS_CALLER_NOT_ALLOWED_MANIFEST_ADSERVICES_CONFIG_NO_PERMISSION = 25;
    public static final int STATUS_ADSERVICES_ACTIVITY_DISABLED = 26;
    public static final int STATUS_CALLBACK_SHUTDOWN = 27;
    public static final int STATUS_PROVIDER_SERVICE_INTERNAL_ERROR = 28;
    public static final int STATUS_UPDATE_ALREADY_PENDING_ERROR = 29;
    public static final int STATUS_CONSENT_REVOKED_ALL_APIS = 30;
    public static final int STATUS_DEV_SESSION_IS_STILL_TRANSITIONING = 31;
    public static final int STATUS_DEV_SESSION_CALLER_IS_NON_DEBUGGABLE = 32;
    public static final int STATUS_DEV_SESSION_FAILURE = 33;
    public static final int STATUS_CALLER_NOT_ALLOWED_DENY_LIST = 34;
    public static final int STATUS_CALLER_NOT_ALLOWED_UID_MISMATCH = 35;
    public static final int STATUS_PROVIDER_SERVICE_TASK_CANCELLED_ERROR = 36;
    public static final String RATE_LIMIT_REACHED_ERROR_MESSAGE = "API rate limit exceeded.";
    public static final String SERVER_RATE_LIMIT_REACHED_ERROR_MESSAGE = "Server rate limit exceeded.";
    public static final String SECURITY_EXCEPTION_PERMISSION_NOT_REQUESTED_ERROR_MESSAGE = "Caller is not authorized to call this API. Permission was not requested.";
    public static final String SECURITY_EXCEPTION_CALLER_NOT_ALLOWED_ERROR_MESSAGE = "Caller is not authorized to call this API. Caller is not allowed.";
    public static final String ILLEGAL_STATE_BACKGROUND_CALLER_ERROR_MESSAGE = "Background thread is not allowed to call this service.";
    public static final String ILLEGAL_STATE_ACTIVITY_DISABLED_ERROR_MESSAGE = "AdServices activity is disabled.";
    public static final String SECURITY_EXCEPTION_CALLER_NOT_ALLOWED_TO_CROSS_USER_BOUNDARIES = "Caller is not authorized to access information from another user";
    public static final String SECURITY_EXCEPTION_CALLER_NOT_ALLOWED_ON_BEHALF_ERROR_MESSAGE = "Caller is not allowed to perform this operation on behalf of the given package.";
    public static final String TIMED_OUT_ERROR_MESSAGE = "API timed out.";
    public static final String INVALID_OBJECT_ERROR_MESSAGE = "The service received an invalid object from the server.";
    public static final String ENCRYPTION_FAILURE_MESSAGE = "Failed to encrypt responses.";
    public static final String SERVICE_UNAVAILABLE_ERROR_MESSAGE = "Service is not available.";
    private static final String DEV_SESSION_ERROR_TRANSITIONING_HELP = "If this error persists, run `cmd adservices_manager adservices-api dev-session end` to reset the dev session.";
    public static final String DEV_SESSION_IS_TRANSITIONING_MESSAGE = "Caller is not allowed during the transition to or from dev mode. If this error persists, run `cmd adservices_manager adservices-api dev-session end` to reset the dev session.";
    public static final String DEV_SESSION_CALLER_IS_NON_DEBUGGABLE_MESSAGE = "Caller during a dev session must have android:debuggable=\"true\" in their manifest! If this error persists, run `cmd adservices_manager adservices-api dev-session end` to reset the dev session.";
    public static final String DEV_SESSION_FAILURE_MESSAGE = "Failed to read dev session state. If this error persists, run `cmd adservices_manager adservices-api dev-session end` to reset the dev session.";
    public static final String UPDATE_ALREADY_PENDING_ERROR_MESSAGE = "Failed to schedule update. A request is already pending.";
    public static final String CALLER_NOT_ALLOWED_DENY_LIST_ERROR_MESSAGE = "Caller is not authorized to call this API as caller is in deny list.";

    public static boolean isSuccess(int statusCode) {
        return statusCode == 0;
    }

    @NonNull
    public static Exception asException(int statusCode) {
        switch (statusCode) {
            case 19: {
                return new IllegalArgumentException(ENCRYPTION_FAILURE_MESSAGE);
            }
            case 2: {
                return new IllegalArgumentException();
            }
            case 4: {
                return new IOException();
            }
            case 6: 
            case 7: 
            case 14: 
            case 18: 
            case 30: {
                return new ServiceUnavailableException(SERVICE_UNAVAILABLE_ERROR_MESSAGE);
            }
            case 9: {
                return new SecurityException(SECURITY_EXCEPTION_PERMISSION_NOT_REQUESTED_ERROR_MESSAGE);
            }
            case 10: {
                return new SecurityException(SECURITY_EXCEPTION_CALLER_NOT_ALLOWED_ERROR_MESSAGE);
            }
            case 20: {
                return new SecurityException(SECURITY_EXCEPTION_CALLER_NOT_ALLOWED_ERROR_MESSAGE);
            }
            case 21: {
                return new SecurityException(SECURITY_EXCEPTION_CALLER_NOT_ALLOWED_ERROR_MESSAGE);
            }
            case 22: {
                return new SecurityException(SECURITY_EXCEPTION_CALLER_NOT_ALLOWED_ERROR_MESSAGE);
            }
            case 23: {
                return new SecurityException(SECURITY_EXCEPTION_CALLER_NOT_ALLOWED_ERROR_MESSAGE);
            }
            case 24: {
                return new SecurityException(SECURITY_EXCEPTION_CALLER_NOT_ALLOWED_ERROR_MESSAGE);
            }
            case 25: {
                return new SecurityException(SECURITY_EXCEPTION_CALLER_NOT_ALLOWED_ERROR_MESSAGE);
            }
            case 11: {
                return new IllegalStateException(ILLEGAL_STATE_BACKGROUND_CALLER_ERROR_MESSAGE);
            }
            case 26: {
                return new IllegalStateException(ILLEGAL_STATE_ACTIVITY_DISABLED_ERROR_MESSAGE);
            }
            case 29: {
                return new IllegalStateException(UPDATE_ALREADY_PENDING_ERROR_MESSAGE);
            }
            case 12: {
                return new SecurityException(SECURITY_EXCEPTION_CALLER_NOT_ALLOWED_ON_BEHALF_ERROR_MESSAGE);
            }
            case 13: {
                return new TimeoutException(TIMED_OUT_ERROR_MESSAGE);
            }
            case 5: {
                return new LimitExceededException(RATE_LIMIT_REACHED_ERROR_MESSAGE);
            }
            case 15: {
                return new InvalidObjectException(INVALID_OBJECT_ERROR_MESSAGE);
            }
            case 17: {
                return new LimitExceededException(SERVER_RATE_LIMIT_REACHED_ERROR_MESSAGE);
            }
            case 28: {
                return new ProviderServiceInternalException();
            }
            case 36: {
                return new ProviderServiceTaskCancelledException();
            }
            case 31: {
                return new IllegalStateException(DEV_SESSION_IS_TRANSITIONING_MESSAGE);
            }
            case 32: {
                return new SecurityException(DEV_SESSION_CALLER_IS_NON_DEBUGGABLE_MESSAGE);
            }
            case 33: {
                return new IllegalStateException(DEV_SESSION_FAILURE_MESSAGE);
            }
            case 34: {
                return new SecurityException(CALLER_NOT_ALLOWED_DENY_LIST_ERROR_MESSAGE);
            }
        }
        return new IllegalStateException();
    }

    @NonNull
    public static Exception asException(@NonNull AdServicesResponse adServicesResponse) {
        return AdServicesStatusUtils.asException(adServicesResponse.getStatusCode());
    }

    private AdServicesStatusUtils() {
        throw new UnsupportedOperationException();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StatusCode {
    }
}

