/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.appsetid;

import android.adservices.common.AdServicesResponse;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class GetAppSetIdResult
extends AdServicesResponse {
    @NonNull
    private final String mAppSetId;
    public static final int SCOPE_APP = 1;
    public static final int SCOPE_DEVELOPER = 2;
    private final int mAppSetIdScope;
    @NonNull
    public static final Parcelable.Creator<GetAppSetIdResult> CREATOR = new Parcelable.Creator<GetAppSetIdResult>(){

        @Override
        public GetAppSetIdResult createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new GetAppSetIdResult(in);
        }

        public GetAppSetIdResult[] newArray(int size) {
            return new GetAppSetIdResult[size];
        }
    };

    private GetAppSetIdResult(int resultCode, @Nullable String errorMessage, @NonNull String appSetId, int appSetIdScope) {
        super(resultCode, errorMessage);
        this.mAppSetId = appSetId;
        this.mAppSetIdScope = appSetIdScope;
    }

    private GetAppSetIdResult(@NonNull Parcel in) {
        super(in);
        Objects.requireNonNull(in);
        this.mAppSetId = in.readString();
        this.mAppSetIdScope = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mStatusCode);
        out.writeString(this.mErrorMessage);
        out.writeString(this.mAppSetId);
        out.writeInt(this.mAppSetIdScope);
    }

    @Override
    @Nullable
    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    @NonNull
    public String getAppSetId() {
        return this.mAppSetId;
    }

    public int getAppSetIdScope() {
        return this.mAppSetIdScope;
    }

    public String toString() {
        return "GetAppSetIdResult{mResultCode=" + this.mStatusCode + ", mErrorMessage='" + this.mErrorMessage + '\'' + ", mAppSetId=" + this.mAppSetId + ", mAppSetIdScope=" + this.mAppSetIdScope + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAppSetIdResult)) {
            return false;
        }
        GetAppSetIdResult that = (GetAppSetIdResult)o;
        return this.mStatusCode == that.mStatusCode && Objects.equals(this.mErrorMessage, that.mErrorMessage) && Objects.equals(this.mAppSetId, that.mAppSetId) && this.mAppSetIdScope == that.mAppSetIdScope;
    }

    public int hashCode() {
        return Objects.hash(this.mStatusCode, this.mErrorMessage, this.mAppSetId, this.mAppSetIdScope);
    }

    public static class Builder {
        private int mStatusCode;
        @Nullable
        private String mErrorMessage;
        @NonNull
        private String mAppSetId;
        private int mAppSetIdScope;

        @NonNull
        public Builder setStatusCode(int statusCode) {
            this.mStatusCode = statusCode;
            return this;
        }

        @NonNull
        public Builder setErrorMessage(@Nullable String errorMessage) {
            this.mErrorMessage = errorMessage;
            return this;
        }

        @NonNull
        public Builder setAppSetId(@NonNull String appSetId) {
            this.mAppSetId = appSetId;
            return this;
        }

        @NonNull
        public Builder setAppSetIdScope(int scope) {
            this.mAppSetIdScope = scope;
            return this;
        }

        @NonNull
        public GetAppSetIdResult build() {
            if (this.mAppSetId == null) {
                throw new IllegalArgumentException("appSetId is null");
            }
            return new GetAppSetIdResult(this.mStatusCode, this.mErrorMessage, this.mAppSetId, this.mAppSetIdScope);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AppSetIdScope {
    }
}

