/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.annotation.NonNull;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PersistAdSelectionResultResponse
implements Parcelable {
    private final long mAdSelectionId;
    private final Uri mAdRenderUri;
    private final AdTechIdentifier mWinningSeller;
    private final List<Uri> mComponentAdUris;
    public static final Parcelable.Creator<PersistAdSelectionResultResponse> CREATOR = new Parcelable.Creator<PersistAdSelectionResultResponse>(){

        @Override
        public PersistAdSelectionResultResponse createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new PersistAdSelectionResultResponse(in);
        }

        public PersistAdSelectionResultResponse[] newArray(int size) {
            return new PersistAdSelectionResultResponse[size];
        }
    };

    private PersistAdSelectionResultResponse(long adSelectionId, Uri adRenderUri, AdTechIdentifier winningSeller, List<Uri> componentAdUris) {
        Objects.requireNonNull(adRenderUri);
        this.mAdSelectionId = adSelectionId;
        this.mAdRenderUri = adRenderUri;
        this.mWinningSeller = winningSeller;
        this.mComponentAdUris = componentAdUris;
    }

    private PersistAdSelectionResultResponse(Parcel in) {
        Objects.requireNonNull(in);
        this.mAdSelectionId = in.readLong();
        this.mAdRenderUri = Uri.CREATOR.createFromParcel(in);
        this.mWinningSeller = AdTechIdentifier.CREATOR.createFromParcel(in);
        this.mComponentAdUris = new ArrayList<Uri>();
        in.readTypedList(this.mComponentAdUris, Uri.CREATOR);
    }

    public boolean equals(Object o) {
        if (o instanceof PersistAdSelectionResultResponse) {
            PersistAdSelectionResultResponse response = (PersistAdSelectionResultResponse)o;
            return this.mAdSelectionId == response.mAdSelectionId && Objects.equals(this.mAdRenderUri, response.mAdRenderUri) && Objects.equals(this.mWinningSeller, response.mWinningSeller) && Objects.equals(this.mComponentAdUris, response.mComponentAdUris);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mAdSelectionId, this.mAdRenderUri, this.mWinningSeller, this.mComponentAdUris);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    public Uri getAdRenderUri() {
        return this.mAdRenderUri;
    }

    public AdTechIdentifier getWinningSeller() {
        return this.mWinningSeller;
    }

    public List<Uri> getComponentAdUris() {
        return this.mComponentAdUris;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        Objects.requireNonNull(this.mAdRenderUri, "Ad render uri cannot be null");
        Objects.requireNonNull(this.mWinningSeller, "Winning seller cannot be null");
        dest.writeLong(this.mAdSelectionId);
        this.mAdRenderUri.writeToParcel(dest, flags);
        this.mWinningSeller.writeToParcel(dest, flags);
        dest.writeTypedList(this.mComponentAdUris);
    }

    public static class Builder {
        private long mAdSelectionId;
        private Uri mAdRenderUri;
        private AdTechIdentifier mWinningSeller;
        private List<Uri> mComponentAdUris = List.of();

        public Builder() {
            this.mWinningSeller = AdTechIdentifier.UNSET_AD_TECH_IDENTIFIER;
        }

        public Builder setAdSelectionId(long adSelectionId) {
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        public Builder setAdRenderUri(Uri adRenderUri) {
            Objects.requireNonNull(adRenderUri);
            this.mAdRenderUri = adRenderUri;
            return this;
        }

        public Builder setWinningSeller(AdTechIdentifier winningSeller) {
            this.mWinningSeller = winningSeller;
            return this;
        }

        public Builder setComponentAdUris(List<Uri> componentAdUris) {
            Objects.requireNonNull(componentAdUris);
            this.mComponentAdUris = componentAdUris;
            return this;
        }

        @NonNull
        public PersistAdSelectionResultResponse build() {
            Objects.requireNonNull(this.mAdRenderUri, "Ad render uri cannot be null");
            Objects.requireNonNull(this.mWinningSeller, "Winning seller cannot be null");
            Preconditions.checkArgument(this.mAdSelectionId != 0L, "Non-zero ad selection ID must be set");
            return new PersistAdSelectionResultResponse(this.mAdSelectionId, this.mAdRenderUri, this.mWinningSeller, this.mComponentAdUris);
        }
    }
}

