/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.annotation.Nullable;
import android.content.res.AssetFileDescriptor;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import com.android.internal.util.Preconditions;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.Arrays;
import java.util.Objects;

public class GetAdSelectionDataResponse
implements Parcelable {
    private final long mAdSelectionId;
    @Nullable
    private final byte[] mAdSelectionData;
    @Nullable
    private final AssetFileDescriptor mAssetFileDescriptor;
    public static final Parcelable.Creator<GetAdSelectionDataResponse> CREATOR = new Parcelable.Creator<GetAdSelectionDataResponse>(){

        @Override
        public GetAdSelectionDataResponse createFromParcel(Parcel in) {
            Objects.requireNonNull(in);
            return new GetAdSelectionDataResponse(in);
        }

        public GetAdSelectionDataResponse[] newArray(int size) {
            return new GetAdSelectionDataResponse[size];
        }
    };

    private GetAdSelectionDataResponse(long adSelectionId, byte[] adSelectionData, AssetFileDescriptor assetFileDescriptor) {
        this.mAdSelectionId = adSelectionId;
        this.mAdSelectionData = adSelectionData;
        this.mAssetFileDescriptor = assetFileDescriptor;
    }

    private GetAdSelectionDataResponse(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mAdSelectionId = in.readLong();
        this.mAdSelectionData = in.createByteArray();
        this.mAssetFileDescriptor = AdServicesParcelableUtil.readNullableFromParcel(in, AssetFileDescriptor.CREATOR::createFromParcel);
    }

    public boolean equals(Object o) {
        if (o instanceof GetAdSelectionDataResponse) {
            GetAdSelectionDataResponse response = (GetAdSelectionDataResponse)o;
            return this.mAdSelectionId == response.mAdSelectionId && Arrays.equals(this.mAdSelectionData, response.mAdSelectionData) && Objects.equals(this.mAssetFileDescriptor, response.mAssetFileDescriptor);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mAdSelectionId, Arrays.hashCode(this.mAdSelectionData), this.mAssetFileDescriptor);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    @Nullable
    public byte[] getAdSelectionData() {
        if (Objects.isNull(this.mAdSelectionData)) {
            return null;
        }
        return Arrays.copyOf(this.mAdSelectionData, this.mAdSelectionData.length);
    }

    @Nullable
    public AssetFileDescriptor getAssetFileDescriptor() {
        return this.mAssetFileDescriptor;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeLong(this.mAdSelectionId);
        dest.writeByteArray(this.mAdSelectionData);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mAssetFileDescriptor, (targetParcel, sourceSignals) -> sourceSignals.writeToParcel(targetParcel, flags));
    }

    public static class Builder {
        private long mAdSelectionId;
        @Nullable
        private byte[] mAdSelectionData;
        @Nullable
        private AssetFileDescriptor mAssetFileDescriptor;

        @NonNull
        public Builder setAdSelectionId(long adSelectionId) {
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        @NonNull
        public Builder setAdSelectionData(@Nullable byte[] adSelectionData) {
            this.mAdSelectionData = (byte[])(!Objects.isNull(adSelectionData) ? Arrays.copyOf(adSelectionData, adSelectionData.length) : null);
            return this;
        }

        @NonNull
        public Builder setAssetFileDescriptor(@Nullable AssetFileDescriptor assetFileDescriptor) {
            this.mAssetFileDescriptor = assetFileDescriptor;
            return this;
        }

        @NonNull
        public GetAdSelectionDataResponse build() {
            Preconditions.checkArgument(this.mAdSelectionId != 0L, "Non-zero ad selection ID must be set");
            return new GetAdSelectionDataResponse(this.mAdSelectionId, this.mAdSelectionData, this.mAssetFileDescriptor);
        }
    }
}

