/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.IBrailleDisplayConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBrailleDisplayController
extends IInterface {
    public static final String DESCRIPTOR = "android.accessibilityservice.IBrailleDisplayController";

    public void onConnected(IBrailleDisplayConnection var1, byte[] var2) throws RemoteException;

    public void onConnectionFailed(int var1) throws RemoteException;

    public void onInput(byte[] var1) throws RemoteException;

    public void onDisconnected() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBrailleDisplayController {
        static final int TRANSACTION_onConnected = 1;
        static final int TRANSACTION_onConnectionFailed = 2;
        static final int TRANSACTION_onInput = 3;
        static final int TRANSACTION_onDisconnected = 4;

        public Stub() {
            this.attachInterface(this, IBrailleDisplayController.DESCRIPTOR);
        }

        public static IBrailleDisplayController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBrailleDisplayController.DESCRIPTOR);
            if (iin != null && iin instanceof IBrailleDisplayController) {
                return (IBrailleDisplayController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onConnected";
                }
                case 2: {
                    return "onConnectionFailed";
                }
                case 3: {
                    return "onInput";
                }
                case 4: {
                    return "onDisconnected";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBrailleDisplayController.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IBrailleDisplayConnection _arg0 = IBrailleDisplayConnection.Stub.asInterface(data.readStrongBinder());
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onConnected(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onConnectionFailed(_arg0);
                    break;
                }
                case 3: {
                    byte[] _arg0 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onInput(_arg0);
                    break;
                }
                case 4: {
                    this.onDisconnected();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IBrailleDisplayController {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBrailleDisplayController.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnected(IBrailleDisplayConnection connection, byte[] hidDescriptor) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBrailleDisplayController.DESCRIPTOR);
                    _data.writeStrongInterface(connection);
                    _data.writeByteArray(hidDescriptor);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectionFailed(int error) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBrailleDisplayController.DESCRIPTOR);
                    _data.writeInt(error);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInput(byte[] input) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBrailleDisplayController.DESCRIPTOR);
                    _data.writeByteArray(input);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onDisconnected() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBrailleDisplayController.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBrailleDisplayController {
        @Override
        public void onConnected(IBrailleDisplayConnection connection, byte[] hidDescriptor) throws RemoteException {
        }

        @Override
        public void onConnectionFailed(int error) throws RemoteException {
        }

        @Override
        public void onInput(byte[] input) throws RemoteException {
        }

        @Override
        public void onDisconnected() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

