/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.util.io.FileUtilRt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.incremental.storage.PathTypeAwareRelativizer;
import org.jetbrains.jps.incremental.storage.RelativePathType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/jps/incremental/storage/TestPathTypeAwareRelativizer;", "Lorg/jetbrains/jps/incremental/storage/PathTypeAwareRelativizer;", "<init>", "()V", "toRelative", "", "path", "type", "Lorg/jetbrains/jps/incremental/storage/RelativePathType;", "Ljava/nio/file/Path;", "toAbsolute", "toAbsoluteFile", "intellij.platform.jps.build"})
@TestOnly
@ApiStatus.Internal
public final class TestPathTypeAwareRelativizer
implements PathTypeAwareRelativizer {
    @NotNull
    public static final TestPathTypeAwareRelativizer INSTANCE = new TestPathTypeAwareRelativizer();

    private TestPathTypeAwareRelativizer() {
    }

    @Override
    @NotNull
    public String toRelative(@NotNull String path, @NotNull RelativePathType type) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String string = FileUtilRt.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        return string;
    }

    @Override
    @NotNull
    public String toRelative(@NotNull Path path, @NotNull RelativePathType type) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return PathsKt.getInvariantSeparatorsPathString((Path)path);
    }

    @Override
    @NotNull
    public String toAbsolute(@NotNull String path, @NotNull RelativePathType type) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String string = FileUtilRt.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        return string;
    }

    @Override
    @NotNull
    public Path toAbsoluteFile(@NotNull String path, @NotNull RelativePathType type) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Path path2 = Path.of(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        return path2;
    }
}

