/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.h2.mvstore.MVMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.storage.LongStorageValueType;
import org.jetbrains.jps.incremental.storage.PathTypeAwareRelativizer;
import org.jetbrains.jps.incremental.storage.RelativePathType;
import org.jetbrains.jps.incremental.storage.StampsStorage;
import org.jetbrains.jps.incremental.storage.StorageManager;
import org.jetbrains.jps.incremental.storage.dataTypes.LongPairKeyDataType;
import org.jetbrains.jps.incremental.storage.dataTypes.LongPairKeyDataTypeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B%\b\u0002\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u001e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016J/\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/jps/incremental/storage/ExperimentalTimeStampStorage;", "Lorg/jetbrains/jps/incremental/storage/StampsStorage;", "", "map", "Lorg/h2/mvstore/MVMap;", "", "relativizer", "Lorg/jetbrains/jps/incremental/storage/PathTypeAwareRelativizer;", "<init>", "(Lorg/h2/mvstore/MVMap;Lorg/jetbrains/jps/incremental/storage/PathTypeAwareRelativizer;)V", "createKey", "file", "Ljava/nio/file/Path;", "updateStamp", "", "buildTarget", "Lorg/jetbrains/jps/builders/BuildTarget;", "currentFileTimestamp", "removeStamp", "target", "getCurrentStampIfUpToDate", "attrs", "Ljava/nio/file/attribute/BasicFileAttributes;", "(Ljava/nio/file/Path;Lorg/jetbrains/jps/builders/BuildTarget;Ljava/nio/file/attribute/BasicFileAttributes;)Ljava/lang/Long;", "Companion", "intellij.platform.jps.build"})
@ApiStatus.Internal
public final class ExperimentalTimeStampStorage
implements StampsStorage<Long> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MVMap<long[], Long> map;
    @NotNull
    private final PathTypeAwareRelativizer relativizer;

    private ExperimentalTimeStampStorage(MVMap<long[], Long> map, PathTypeAwareRelativizer relativizer) {
        this.map = map;
        this.relativizer = relativizer;
    }

    private final long[] createKey(Path file) {
        return LongPairKeyDataTypeKt.stringTo128BitHash(this.relativizer.toRelative(file, RelativePathType.SOURCE));
    }

    @Override
    public void updateStamp(@NotNull Path file, @Nullable BuildTarget<?> buildTarget, long currentFileTimestamp) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.map.put((Object)this.createKey(file), (Object)currentFileTimestamp);
    }

    @Override
    public void removeStamp(@NotNull Path file, @Nullable BuildTarget<?> target) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.map.remove((Object)this.createKey(file));
    }

    @Override
    @Nullable
    public Long getCurrentStampIfUpToDate(@NotNull Path file, @Nullable BuildTarget<?> target, @Nullable BasicFileAttributes attrs) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Long l2 = (Long)this.map.get((Object)this.createKey(file));
        if (l2 != null) {
            Long l3 = l2;
            long it = ((Number)l3).longValue();
            boolean bl = false;
            l = it == (attrs == null || !attrs.isRegularFile() ? FSOperations.lastModified(file) : attrs.lastModifiedTime().toMillis()) ? l3 : null;
        } else {
            l = null;
        }
        return l;
    }

    public /* synthetic */ ExperimentalTimeStampStorage(MVMap map, PathTypeAwareRelativizer relativizer, DefaultConstructorMarker $constructor_marker) {
        this((MVMap<long[], Long>)map, relativizer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/jps/incremental/storage/ExperimentalTimeStampStorage$Companion;", "", "<init>", "()V", "createSourceToStampMap", "Lorg/jetbrains/jps/incremental/storage/ExperimentalTimeStampStorage;", "storageManager", "Lorg/jetbrains/jps/incremental/storage/StorageManager;", "relativizer", "Lorg/jetbrains/jps/incremental/storage/PathTypeAwareRelativizer;", "targetId", "", "targetTypeId", "intellij.platform.jps.build"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final ExperimentalTimeStampStorage createSourceToStampMap(@NotNull StorageManager storageManager, @NotNull PathTypeAwareRelativizer relativizer, @NotNull String targetId, @NotNull String targetTypeId) {
            Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
            Intrinsics.checkNotNullParameter((Object)relativizer, (String)"relativizer");
            Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
            Intrinsics.checkNotNullParameter((Object)targetTypeId, (String)"targetTypeId");
            String mapName = storageManager.getMapName(targetId, targetTypeId, "file-hash-and-mtime-v1");
            return new ExperimentalTimeStampStorage(storageManager.openMap(mapName, LongPairKeyDataType.INSTANCE, LongStorageValueType.INSTANCE), relativizer, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

