/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import java.io.IOException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.Delta;
import org.jetbrains.jps.dependency.DependencyGraph;
import org.jetbrains.jps.dependency.DifferentiateParameters;
import org.jetbrains.jps.dependency.DifferentiateResult;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.impl.LoggingGraph;
import org.jetbrains.jps.incremental.Utils;

public final class LoggingDependencyGraph
extends LoggingGraph
implements DependencyGraph {
    private long myTotalDifferentiateTime;
    private long myTotalIntegrateTime;

    public LoggingDependencyGraph(DependencyGraph delegate, Consumer<String> logger) {
        super(delegate, logger);
    }

    public synchronized long getTotalDifferentiateTime() {
        return this.myTotalDifferentiateTime;
    }

    public synchronized long getTotalIntegrateTime() {
        return this.myTotalIntegrateTime;
    }

    @Override
    public DependencyGraph getDelegate() {
        return (DependencyGraph)super.getDelegate();
    }

    @Override
    public Delta createDelta(Iterable<NodeSource> sourcesToProcess, Iterable<NodeSource> deletedSources, boolean isSourceOnly) throws IOException {
        return this.getDelegate().createDelta(sourcesToProcess, deletedSources, isSourceOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DifferentiateResult differentiate(Delta delta, DifferentiateParameters params) {
        DifferentiateResult differentiateResult;
        long start = System.currentTimeMillis();
        try {
            differentiateResult = this.getDelegate().differentiate(delta, params);
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - start;
            LoggingDependencyGraph loggingDependencyGraph = this;
            synchronized (loggingDependencyGraph) {
                this.myTotalDifferentiateTime += duration;
            }
            this.debug("DependencyGraph ", params.getSessionName(), " differentiate done in ", Utils.formatDuration(duration));
            throw throwable;
        }
        long duration = System.currentTimeMillis() - start;
        LoggingDependencyGraph loggingDependencyGraph = this;
        synchronized (loggingDependencyGraph) {
            this.myTotalDifferentiateTime += duration;
        }
        this.debug("DependencyGraph ", params.getSessionName(), " differentiate done in ", Utils.formatDuration(duration));
        return differentiateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void integrate(@NotNull DifferentiateResult diffResult) {
        if (diffResult == null) {
            LoggingDependencyGraph.$$$reportNull$$$0(0);
        }
        long start = System.currentTimeMillis();
        try {
            this.getDelegate().integrate(diffResult);
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - start;
            LoggingDependencyGraph loggingDependencyGraph = this;
            synchronized (loggingDependencyGraph) {
                this.myTotalIntegrateTime += duration;
            }
            this.debug("DependencyGraph ", diffResult.getSessionName(), " integrate done in ", Utils.formatDuration(duration));
            throw throwable;
        }
        long duration = System.currentTimeMillis() - start;
        LoggingDependencyGraph loggingDependencyGraph = this;
        synchronized (loggingDependencyGraph) {
            this.myTotalIntegrateTime += duration;
        }
        this.debug("DependencyGraph ", diffResult.getSessionName(), " integrate done in ", Utils.formatDuration(duration));
    }

    @Override
    public void close() throws IOException {
        try {
            this.getDelegate().close();
        }
        catch (Throwable throwable) {
            this.debug("DependencyGraph total differentiate linear time ", Utils.formatDuration(this.myTotalDifferentiateTime));
            this.debug("DependencyGraph total integrate     linear time ", Utils.formatDuration(this.myTotalIntegrateTime));
            throw throwable;
        }
        this.debug("DependencyGraph total differentiate linear time ", Utils.formatDuration(this.myTotalDifferentiateTime));
        this.debug("DependencyGraph total integrate     linear time ", Utils.formatDuration(this.myTotalIntegrateTime));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffResult", "org/jetbrains/jps/dependency/impl/LoggingDependencyGraph", "integrate"));
    }
}

