/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.dependencyView.LoggerWrapper;
import org.jetbrains.jps.builders.java.dependencyView.NamingContext;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;

@ApiStatus.Internal
public final class DependencyContext
implements NamingContext {
    private static final String STRING_TABLE_NAME = "strings.tab";
    private final PersistentStringEnumerator myEnumerator;
    private final Map<TypeRepr.AbstractType, TypeRepr.AbstractType> myTypeMap = new HashMap<TypeRepr.AbstractType, TypeRepr.AbstractType>();
    private final Map<UsageRepr.Usage, UsageRepr.Usage> myUsageMap = new HashMap<UsageRepr.Usage, UsageRepr.Usage>();
    private final PathRelativizerService myRelativizer;
    private final int myEmptyName;

    UsageRepr.Usage getUsage(UsageRepr.Usage u) {
        UsageRepr.Usage r = this.myUsageMap.get(u);
        if (r == null) {
            this.myUsageMap.put(u, u);
            return u;
        }
        return r;
    }

    <T extends TypeRepr.AbstractType> T getType(T t) {
        TypeRepr.AbstractType r = this.myTypeMap.get(t);
        if (r != null) {
            return (T)r;
        }
        this.myTypeMap.put(t, t);
        return t;
    }

    void clearMemoryCaches() {
        this.myTypeMap.clear();
        this.myUsageMap.clear();
    }

    static File getTableFile(File rootDir, String name) {
        File file = new File(FileUtilRt.toSystemIndependentName((String)(rootDir.getAbsoluteFile() + File.separator + name)));
        FileUtilRt.createIfNotExists((File)file);
        return file;
    }

    DependencyContext(File rootDir, PathRelativizerService relativizer) throws IOException {
        File file = DependencyContext.getTableFile(rootDir, STRING_TABLE_NAME);
        this.myEnumerator = new PersistentStringEnumerator(file.toPath(), true);
        this.myEmptyName = this.myEnumerator.enumerate("");
        this.myRelativizer = relativizer;
    }

    @Override
    @Nullable
    public String getValue(int s) {
        try {
            String value = this.myEnumerator.valueOf(s);
            return value == null ? null : this.myRelativizer.toFull(value);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public int get(String s) {
        try {
            return Strings.isEmpty((String)s) ? this.myEmptyName : this.myEnumerator.enumerate(this.myRelativizer.toRelative(s));
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public void close() {
        try {
            this.myEnumerator.close();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public void flush() {
        this.myEnumerator.force();
    }

    public LoggerWrapper<Integer> getLogger(final Logger log) {
        return new LoggerWrapper<Integer>(){

            @Override
            public boolean isDebugEnabled() {
                return log.isDebugEnabled();
            }

            @Override
            public void debug(String comment, Integer s) {
                if (this.isDebugEnabled()) {
                    log.debug(comment + DependencyContext.this.getValue(s));
                }
            }

            @Override
            public void debug(String comment, String t) {
                if (this.isDebugEnabled()) {
                    log.debug(comment + t);
                }
            }

            @Override
            public void debug(String comment, boolean t) {
                if (this.isDebugEnabled()) {
                    log.debug(comment + t);
                }
            }
        };
    }
}

