/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.ui.frame.VcsLogMainGraphTable;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J@\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0007J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002R\u0013\u0010#\u001a\u00070$\u00a2\u0006\u0002\b%X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogComponents;", "", "<init>", "()V", "createTable", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/ui/AbstractVcsLogUi;", "filterUi", "Lcom/intellij/vcs/log/ui/filter/VcsLogFilterUiEx;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "createActionsToolbar", "Ljavax/swing/JComponent;", "graphTable", "collectLogKeys", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "uiProperties", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties;", "history", "Lcom/intellij/ui/navigation/History;", "Lcom/intellij/vcs/log/VcsLogFilterUi;", "toolbarComponent", "mainComponent", "getSelectedRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "HELP_ID", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.platform.vcs.log.impl"})
public final class VcsLogComponents {
    @NotNull
    public static final VcsLogComponents INSTANCE = new VcsLogComponents();
    @NotNull
    private static final String HELP_ID = "reference.changesToolWindow.log";

    private VcsLogComponents() {
    }

    @JvmStatic
    @NotNull
    public static final VcsLogGraphTable createTable(@NotNull VcsLogData logData, @NotNull AbstractVcsLogUi logUi, @NotNull VcsLogFilterUiEx filterUi, @NotNull VcsLogColorManager colorManager, @NotNull Disposable parentDisposable) {
        VcsLogMainGraphTable vcsLogMainGraphTable;
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter((Object)logUi, (String)"logUi");
        Intrinsics.checkNotNullParameter((Object)filterUi, (String)"filterUi");
        Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Runnable runnable = () -> VcsLogComponents.createTable$lambda$0(logUi);
        VcsLogUiProperties vcsLogUiProperties = logUi.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogUiProperties, (String)"getProperties(...)");
        GraphTableModel graphTableModel = new GraphTableModel(logData, runnable, vcsLogUiProperties);
        VcsLogMainGraphTable $this$createTable_u24lambda_u243 = vcsLogMainGraphTable = new VcsLogMainGraphTable(logUi.getId(), graphTableModel, logUi.getProperties(), colorManager, () -> VcsLogComponents.createTable$lambda$1(logUi), filterUi, arg_0 -> VcsLogComponents.createTable$lambda$2(logUi, arg_0), parentDisposable);
        boolean bl = false;
        String string = VcsLogUtil.getVcsDisplayName(logData.getProject(), logData.getLogProviders().values());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVcsDisplayName(...)");
        String vcsDisplayName = string;
        Object[] objectArray = new Object[]{vcsDisplayName};
        $this$createTable_u24lambda_u243.getAccessibleContext().setAccessibleName(VcsLogBundle.message("vcs.log.table.accessible.name", objectArray));
        $this$createTable_u24lambda_u243.resetDefaultFocusTraversalKeys();
        VcsLogMainGraphTable it = vcsLogMainGraphTable;
        boolean bl2 = false;
        PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)it)), (String)"Vcs.Log.ContextMenu", (String)"Vcs.Log.ContextMenu");
        return vcsLogMainGraphTable;
    }

    @JvmStatic
    @NotNull
    public static final JComponent createActionsToolbar(@NotNull VcsLogGraphTable graphTable, @NotNull VcsLogFilterUiEx filterUi) {
        JPanel jPanel;
        DefaultActionGroup defaultActionGroup;
        Intrinsics.checkNotNullParameter((Object)graphTable, (String)"graphTable");
        Intrinsics.checkNotNullParameter((Object)filterUi, (String)"filterUi");
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("Vcs.Log.Toolbar.Internal");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
        DefaultActionGroup toolbarGroup = (DefaultActionGroup)anAction;
        DefaultActionGroup $this$createActionsToolbar_u24lambda_u245 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        $this$createActionsToolbar_u24lambda_u245.add((AnAction)filterUi.createActionGroup());
        $this$createActionsToolbar_u24lambda_u245.addSeparator();
        $this$createActionsToolbar_u24lambda_u245.add((AnAction)toolbarGroup);
        DefaultActionGroup mainGroup = defaultActionGroup;
        ActionToolbar $this$createActionsToolbar_u24lambda_u246 = bl = actionManager.createActionToolbar("Vcs.Log.Toolbar", (ActionGroup)mainGroup, true);
        boolean bl2 = false;
        $this$createActionsToolbar_u24lambda_u246.setTargetComponent((JComponent)((Object)graphTable));
        ActionToolbar actionToolbar = bl;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"apply(...)");
        ActionToolbar toolbar2 = actionToolbar;
        ActionToolbar $this$createActionsToolbar_u24lambda_u247 = bl = new Wrapper(filterUi.getTextFilterComponent().getComponent());
        boolean bl3 = false;
        $this$createActionsToolbar_u24lambda_u247.setVerticalSizeReferent(toolbar2.getComponent());
        VcsLogData vcsLogData = graphTable.getLogData();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"getLogData(...)");
        VcsLogData logData = vcsLogData;
        Object[] objectArray = new Object[]{VcsLogUtil.getVcsDisplayName(logData.getProject(), logData.getLogProviders().values())};
        $this$createActionsToolbar_u24lambda_u247.getAccessibleContext().setAccessibleName(VcsLogBundle.message("vcs.log.text.filter.accessible.name", objectArray));
        ActionToolbar textFilter = bl;
        ActionGroup actionGroup = (ActionGroup)CustomActionsSchema.Companion.getInstance().getCorrectedAction("Vcs.Log.Toolbar.RightCorner");
        if (actionGroup == null) {
            throw new IllegalStateException("Action group not found: Vcs.Log.Toolbar.RightCorner");
        }
        ActionGroup rightCornerGroup = actionGroup;
        VcsLogData $this$createActionsToolbar_u24lambda_u248 = logData = actionManager.createActionToolbar("Vcs.Log.Toolbar", rightCornerGroup, true);
        boolean bl4 = false;
        $this$createActionsToolbar_u24lambda_u248.setTargetComponent((JComponent)((Object)graphTable));
        $this$createActionsToolbar_u24lambda_u248.setReservePlaceAutoPopupIcon(false);
        VcsLogData vcsLogData2 = logData;
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData2, (String)"apply(...)");
        VcsLogData rightCornerToolbar = vcsLogData2;
        JPanel $this$createActionsToolbar_u24lambda_u249 = jPanel = new JPanel((LayoutManager)new MigLayout("ins 0, fill", "[left]0[left, fill]push[pref:pref, right]", "center"));
        boolean bl5 = false;
        GuiUtils.installVisibilityReferent((JComponent)$this$createActionsToolbar_u24lambda_u249, (JComponent)toolbar2.getComponent());
        $this$createActionsToolbar_u24lambda_u249.add((Component)textFilter);
        $this$createActionsToolbar_u24lambda_u249.add(toolbar2.getComponent());
        $this$createActionsToolbar_u24lambda_u249.add(rightCornerToolbar.getComponent());
        return jPanel;
    }

    @JvmStatic
    public static final void collectLogKeys(@NotNull DataSink sink, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogGraphTable graphTable, @NotNull History history, @NotNull VcsLogFilterUi filterUi, @NotNull JComponent toolbarComponent, @NotNull JComponent mainComponent) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
        Intrinsics.checkNotNullParameter((Object)graphTable, (String)"graphTable");
        Intrinsics.checkNotNullParameter((Object)history, (String)"history");
        Intrinsics.checkNotNullParameter((Object)filterUi, (String)"filterUi");
        Intrinsics.checkNotNullParameter((Object)toolbarComponent, (String)"toolbarComponent");
        Intrinsics.checkNotNullParameter((Object)mainComponent, (String)"mainComponent");
        DataKey<VcsLogUiProperties> dataKey = VcsLogInternalDataKeys.LOG_UI_PROPERTIES;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"LOG_UI_PROPERTIES");
        sink.set(dataKey, (Object)uiProperties);
        VcsLogData vcsLogData = graphTable.getLogData();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"getLogData(...)");
        VcsLogData logData = vcsLogData;
        VcsLogFilterCollection vcsLogFilterCollection = filterUi.getFilters();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection, (String)"getFilters(...)");
        Collection<VirtualFile> roots = INSTANCE.getSelectedRoots(graphTable, vcsLogFilterCollection);
        DataKey dataKey2 = CommonDataKeys.VIRTUAL_FILE_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"VIRTUAL_FILE_ARRAY");
        sink.set(dataKey2, (Object)VfsUtilCore.toVirtualFileArray(roots));
        VirtualFile onlyRoot = (VirtualFile)ContainerUtil.getOnlyItem(roots);
        if (onlyRoot != null) {
            DataKey<VcsLogDiffHandler> dataKey3 = VcsLogInternalDataKeys.LOG_DIFF_HANDLER;
            Intrinsics.checkNotNullExpressionValue(dataKey3, (String)"LOG_DIFF_HANDLER");
            sink.set(dataKey3, (Object)logData.getLogProvider(onlyRoot).getDiffHandler());
        }
        DataKey<Set<VirtualFile>> dataKey4 = VcsLogInternalDataKeys.VCS_LOG_VISIBLE_ROOTS;
        Intrinsics.checkNotNullExpressionValue(dataKey4, (String)"VCS_LOG_VISIBLE_ROOTS");
        sink.set(dataKey4, VcsLogUtil.getAllVisibleRoots(logData.getRoots(), filterUi.getFilters()));
        DataKey dataKey5 = PlatformCoreDataKeys.HELP_ID;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey5, (String)"HELP_ID");
        sink.set(dataKey5, (Object)HELP_ID);
        DataKey dataKey6 = History.KEY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey6, (String)"KEY");
        sink.set(dataKey6, (Object)history);
        DataKey dataKey7 = QuickActionProvider.KEY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey7, (String)"KEY");
        sink.set(dataKey7, (Object)new QuickActionProvider(toolbarComponent, mainComponent){
            final /* synthetic */ JComponent $toolbarComponent;
            final /* synthetic */ JComponent $mainComponent;
            {
                this.$toolbarComponent = $toolbarComponent;
                this.$mainComponent = $mainComponent;
            }

            public List<AnAction> getActions(boolean originalProvider) {
                AnAction textFilterAction = ActionUtil.wrap((String)"Vcs.Log.FocusTextFilter");
                textFilterAction.getTemplatePresentation().setText(VcsLogBundle.message("vcs.log.text.filter.action.text", new Object[0]));
                List actions2 = new ArrayList<E>();
                actions2.add(textFilterAction);
                List list = SimpleToolWindowPanel.collectActions((JComponent)this.$toolbarComponent);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"collectActions(...)");
                actions2.addAll(list);
                return actions2;
            }

            public JComponent getComponent() {
                return this.$mainComponent;
            }

            public String getName() {
                return null;
            }
        });
    }

    private final Collection<VirtualFile> getSelectedRoots(VcsLogGraphTable graphTable, VcsLogFilterCollection filters) {
        GraphTableModel graphTableModel = graphTable.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)graphTableModel, (String)"getModel(...)");
        GraphTableModel tableModel = graphTableModel;
        Collection<VirtualFile> collection = tableModel.getLogData().getRoots();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRoots(...)");
        Collection<VirtualFile> roots = collection;
        if (roots.size() == 1) {
            return roots;
        }
        int[] selectedRows = graphTable.getSelectedRows();
        Intrinsics.checkNotNull((Object)selectedRows);
        if (selectedRows.length == 0 || selectedRows.length > 1000) {
            Set<VirtualFile> set = VcsLogUtil.getAllVisibleRoots(roots, filters);
            Intrinsics.checkNotNullExpressionValue(set, (String)"getAllVisibleRoots(...)");
            return set;
        }
        Set set = ContainerUtil.map2Set((Collection)Ints.asList((int[])Arrays.copyOf(selectedRows, selectedRows.length)), arg_0 -> VcsLogComponents.getSelectedRoots$lambda$11(arg_0 -> VcsLogComponents.getSelectedRoots$lambda$10(tableModel, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"map2Set(...)");
        return CollectionsKt.filterNotNull((Iterable)set);
    }

    private static final void createTable$lambda$0(AbstractVcsLogUi $logUi) {
        $logUi.requestMore(EmptyRunnable.INSTANCE);
    }

    private static final void createTable$lambda$1(AbstractVcsLogUi $logUi) {
        $logUi.getRefresher().onRefresh();
    }

    private static final void createTable$lambda$2(AbstractVcsLogUi $logUi, String commitHash) {
        Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
        VcsLogNavigationUtil.jumpToHash($logUi, commitHash, false, true);
    }

    private static final VirtualFile getSelectedRoots$lambda$10(GraphTableModel $tableModel, Integer row) {
        Integer n = row;
        Intrinsics.checkNotNull((Object)n);
        return $tableModel.getRootAtRow(n);
    }

    private static final VirtualFile getSelectedRoots$lambda$11(Function1 $tmp0, Object p0) {
        return (VirtualFile)$tmp0.invoke(p0);
    }
}

