/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.intui.standalone;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.foundation.theme.JewelTheme;
import org.jetbrains.jewel.foundation.theme.ThemeDefinition;
import org.jetbrains.jewel.foundation.util.JewelLogger;
import org.jetbrains.jewel.ui.painter.PainterHint;
import org.jetbrains.jewel.ui.painter.PalettePainterHintsProvider;
import org.jetbrains.jewel.ui.painter.hints.ColorBasedPaletteReplacementKt;
import org.jetbrains.jewel.ui.painter.hints.DarkAndStrokeKt;
import org.jetbrains.jewel.ui.painter.hints.HiDpiKt;
import org.jetbrains.jewel.ui.painter.hints.KeyBasedPaletteReplacementKt;
import org.jetbrains.jewel.ui.painter.hints.PathOverrideKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J,\u0010\u001b\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u001b\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001d2\u0006\u0010\u001e\u001a\u00020\u0019H\u0017\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u000e\u0010\u0012\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/jewel/intui/standalone/StandalonePainterHintsProvider;", "Lorg/jetbrains/jewel/ui/painter/PalettePainterHintsProvider;", "theme", "Lorg/jetbrains/jewel/foundation/theme/ThemeDefinition;", "<init>", "(Lorg/jetbrains/jewel/foundation/theme/ThemeDefinition;)V", "logger", "Lorg/jetbrains/jewel/foundation/util/JewelLogger;", "checkBoxByColorPaletteHint", "Lorg/jetbrains/jewel/ui/painter/PainterHint;", "getCheckBoxByColorPaletteHint", "()Lorg/jetbrains/jewel/ui/painter/PainterHint;", "checkBoxByKeyPaletteHint", "getCheckBoxByKeyPaletteHint", "treePaletteHint", "getTreePaletteHint", "uiPaletteHint", "getUiPaletteHint", "overrideHint", "registerColorBasedReplacement", "", "map", "", "Landroidx/compose/ui/graphics/Color;", "key", "", "value", "registerIdBasedReplacement", "hints", "", "path", "(Ljava/lang/String;Landroidx/compose/runtime/Composer;I)Ljava/util/List;", "Companion", "intellij.platform.jewel.intUi.standalone"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nStandalonePainterHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandalonePainterHintsProvider.kt\norg/jetbrains/jewel/intui/standalone/StandalonePainterHintsProvider\n+ 2 JewelLogger.kt\norg/jetbrains/jewel/foundation/util/JewelLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n9#2:171\n1187#3,2:172\n1261#3,4:174\n*S KotlinDebug\n*F\n+ 1 StandalonePainterHintsProvider.kt\norg/jetbrains/jewel/intui/standalone/StandalonePainterHintsProvider\n*L\n24#1:171\n33#1:172,2\n33#1:174,4\n*E\n"})
public final class StandalonePainterHintsProvider
extends PalettePainterHintsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JewelLogger logger;
    @NotNull
    private final PainterHint checkBoxByColorPaletteHint;
    @NotNull
    private final PainterHint checkBoxByKeyPaletteHint;
    @NotNull
    private final PainterHint treePaletteHint;
    @NotNull
    private final PainterHint uiPaletteHint;
    @NotNull
    private final PainterHint overrideHint;
    public static final int $stable;
    @NotNull
    private static final Map<String, String> intellijColorPalette;
    @NotNull
    private static final Set<String> supportedCheckboxKeys;

    /*
     * WARNING - void declaration
     */
    public StandalonePainterHintsProvider(@NotNull ThemeDefinition theme) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(theme.isDark(), intellijColorPalette, theme.getIconData().getColorPalette(), theme.getColorPalette().getRawMap());
        Object $this$myLogger$iv = this;
        boolean $i$f$myLogger = false;
        this.logger = JewelLogger.Companion.getInstance(StandalonePainterHintsProvider.class);
        $this$myLogger$iv = theme.getIconData().getIconOverrides().entrySet();
        StandalonePainterHintsProvider standalonePainterHintsProvider = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_8 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            entry = TuplesKt.to((Object)StringsKt.removePrefix((String)k, (CharSequence)"/"), (Object)StringsKt.removePrefix((String)v, (CharSequence)"/"));
            map.put(entry.getFirst(), entry.getSecond());
        }
        standalonePainterHintsProvider.overrideHint = PathOverrideKt.PathOverride((Map)destination$iv$iv);
        Map ui = new LinkedHashMap();
        Map checkBoxesByColor = new LinkedHashMap();
        Map checkBoxesByKey = new LinkedHashMap();
        Map trees = new LinkedHashMap();
        for (Map.Entry entry : this.getThemeIconPalette().entrySet()) {
            Map map;
            String key = (String)entry.getKey();
            String value2 = (String)entry.getValue();
            if (value2 == null) continue;
            if (StringsKt.startsWith$default((String)key, (String)"Checkbox.", (boolean)false, (int)2, null)) {
                this.registerIdBasedReplacement(checkBoxesByKey, key, value2);
            }
            if (this.selectMap(key, checkBoxesByColor, trees, ui) == null) continue;
            this.registerColorBasedReplacement(map, key, value2);
        }
        this.checkBoxByKeyPaletteHint = KeyBasedPaletteReplacementKt.KeyBasedPaletteReplacement((Map)checkBoxesByKey);
        this.checkBoxByColorPaletteHint = ColorBasedPaletteReplacementKt.ColorBasedPaletteReplacement((Map)checkBoxesByColor);
        this.treePaletteHint = ColorBasedPaletteReplacementKt.ColorBasedPaletteReplacement((Map)trees);
        this.uiPaletteHint = ColorBasedPaletteReplacementKt.ColorBasedPaletteReplacement((Map)ui);
    }

    @NotNull
    protected PainterHint getCheckBoxByColorPaletteHint() {
        return this.checkBoxByColorPaletteHint;
    }

    @NotNull
    protected PainterHint getCheckBoxByKeyPaletteHint() {
        return this.checkBoxByKeyPaletteHint;
    }

    @NotNull
    protected PainterHint getTreePaletteHint() {
        return this.treePaletteHint;
    }

    @NotNull
    protected PainterHint getUiPaletteHint() {
        return this.uiPaletteHint;
    }

    private final void registerColorBasedReplacement(Map<Color, Color> map, String key, String value2) {
        Color color = this.resolveKeyColor-8tov2TA(key, this.getIntellijIconPalette(), this.isDark());
        if (color == null) {
            return;
        }
        long keyAsColor = color.unbox-impl();
        Color color2 = this.resolveColor-ijrfgN4(value2);
        if (color2 == null) {
            return;
        }
        long resolvedColor = color2.unbox-impl();
        Color color3 = Color.box-impl((long)keyAsColor);
        Color color4 = Color.box-impl((long)resolvedColor);
        map.put(color3, color4);
    }

    private final void registerIdBasedReplacement(Map<String, Color> map, String key, String value2) {
        Color parsedValue;
        String adjustedKey;
        String string = adjustedKey = this.isDark() ? StringsKt.removeSuffix((String)key, (CharSequence)".Dark") : key;
        if (!supportedCheckboxKeys.contains(adjustedKey)) {
            this.logger.debug((this.isDark() ? "Dark" : "Light") + " theme: color key " + key + " is not supported, will be ignored");
            return;
        }
        if (!Intrinsics.areEqual((Object)adjustedKey, (Object)key)) {
            this.logger.warn((this.isDark() ? "Dark" : "Light") + " theme: color key " + key + " is deprecated, use " + adjustedKey + " instead");
        }
        if ((parsedValue = this.resolveColor-ijrfgN4(value2)) == null) {
            this.logger.info((this.isDark() ? "Dark" : "Light") + " theme: color key " + key + " has invalid value: '" + value2 + "'");
            return;
        }
        map.put(adjustedKey, parsedValue);
    }

    @Composable
    @NotNull
    public List<PainterHint> hints(@NotNull String path, @Nullable Composer $composer, int $changed) {
        List list;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        $composer.startReplaceGroup(1587168416);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)1587168416, (int)$changed, (int)-1, (String)"org.jetbrains.jewel.intui.standalone.StandalonePainterHintsProvider.hints (StandalonePainterHintsProvider.kt:95)");
        }
        List $this$hints_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$hints_u24lambda_u241.add(this.overrideHint);
        $this$hints_u24lambda_u241.add(this.getPaletteHint(path, true));
        $this$hints_u24lambda_u241.add(HiDpiKt.HiDpi());
        $this$hints_u24lambda_u241.add(DarkAndStrokeKt.Dark((boolean)JewelTheme.Companion.isDark($composer, 6)));
        List list2 = CollectionsKt.build((List)list);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceGroup();
        return list2;
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"Actions.Red", (Object)"#DB5860"), TuplesKt.to((Object)"Actions.Red.Dark", (Object)"#C75450"), TuplesKt.to((Object)"Actions.Yellow", (Object)"#EDA200"), TuplesKt.to((Object)"Actions.Yellow.Dark", (Object)"#F0A732"), TuplesKt.to((Object)"Actions.Green", (Object)"#59A869"), TuplesKt.to((Object)"Actions.Green.Dark", (Object)"#499C54"), TuplesKt.to((Object)"Actions.Blue", (Object)"#389FD6"), TuplesKt.to((Object)"Actions.Blue.Dark", (Object)"#3592C4"), TuplesKt.to((Object)"Actions.Grey", (Object)"#6E6E6E"), TuplesKt.to((Object)"Actions.Grey.Dark", (Object)"#AFB1B3"), TuplesKt.to((Object)"Actions.GreyInline", (Object)"#7F8B91"), TuplesKt.to((Object)"Actions.GreyInline.Dark", (Object)"#7F8B91"), TuplesKt.to((Object)"Objects.Grey", (Object)"#9AA7B0"), TuplesKt.to((Object)"Objects.Blue", (Object)"#40B6E0"), TuplesKt.to((Object)"Objects.Green", (Object)"#62B543"), TuplesKt.to((Object)"Objects.Yellow", (Object)"#F4AF3D"), TuplesKt.to((Object)"Objects.YellowDark", (Object)"#D9A343"), TuplesKt.to((Object)"Objects.Purple", (Object)"#B99BF8"), TuplesKt.to((Object)"Objects.Pink", (Object)"#F98B9E"), TuplesKt.to((Object)"Objects.Red", (Object)"#F26522"), TuplesKt.to((Object)"Objects.RedStatus", (Object)"#E05555"), TuplesKt.to((Object)"Objects.GreenAndroid", (Object)"#3DDC84"), TuplesKt.to((Object)"Objects.BlackText", (Object)"#231F20"), TuplesKt.to((Object)"Checkbox.Background.Default", (Object)"#FFFFFF"), TuplesKt.to((Object)"Checkbox.Background.Default.Dark", (Object)"#43494A"), TuplesKt.to((Object)"Checkbox.Background.Disabled", (Object)"#F2F2F2"), TuplesKt.to((Object)"Checkbox.Background.Disabled.Dark", (Object)"#3C3F41"), TuplesKt.to((Object)"Checkbox.Border.Default", (Object)"#b0b0b0"), TuplesKt.to((Object)"Checkbox.Border.Default.Dark", (Object)"#6B6B6B"), TuplesKt.to((Object)"Checkbox.Border.Disabled", (Object)"#BDBDBD"), TuplesKt.to((Object)"Checkbox.Border.Disabled.Dark", (Object)"#545556"), TuplesKt.to((Object)"Checkbox.Focus.Thin.Default", (Object)"#7B9FC7"), TuplesKt.to((Object)"Checkbox.Focus.Thin.Default.Dark", (Object)"#466D94"), TuplesKt.to((Object)"Checkbox.Focus.Wide", (Object)"#97C3F3"), TuplesKt.to((Object)"Checkbox.Focus.Wide.Dark", (Object)"#3D6185"), TuplesKt.to((Object)"Checkbox.Foreground.Disabled", (Object)"#ABABAB"), TuplesKt.to((Object)"Checkbox.Foreground.Disabled.Dark", (Object)"#606060"), TuplesKt.to((Object)"Checkbox.Background.Selected", (Object)"#4F9EE3"), TuplesKt.to((Object)"Checkbox.Background.Selected.Dark", (Object)"#43494A"), TuplesKt.to((Object)"Checkbox.Border.Selected", (Object)"#4B97D9"), TuplesKt.to((Object)"Checkbox.Border.Selected.Dark", (Object)"#6B6B6B"), TuplesKt.to((Object)"Checkbox.Foreground.Selected", (Object)"#FEFEFE"), TuplesKt.to((Object)"Checkbox.Foreground.Selected.Dark", (Object)"#A7A7A7"), TuplesKt.to((Object)"Checkbox.Focus.Thin.Selected", (Object)"#ACCFF7"), TuplesKt.to((Object)"Checkbox.Focus.Thin.Selected.Dark", (Object)"#466D94"), TuplesKt.to((Object)"Tree.iconColor", (Object)"#808080"), TuplesKt.to((Object)"Tree.iconColor.Dark", (Object)"#AFB1B3")};
        intellijColorPalette = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"Checkbox.Background.Default", "Checkbox.Border.Default", "Checkbox.Foreground.Selected", "Checkbox.Background.Selected", "Checkbox.Border.Selected", "Checkbox.Focus.Wide", "Checkbox.Foreground.Disabled", "Checkbox.Background.Disabled", "Checkbox.Border.Disabled"};
        supportedCheckboxKeys = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/jewel/intui/standalone/StandalonePainterHintsProvider$Companion;", "", "<init>", "()V", "intellijColorPalette", "", "", "supportedCheckboxKeys", "", "intellij.platform.jewel.intUi.standalone"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

