/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.util.stream.Collectors;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Streams;

public final class Strings {
    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String quote(String s) {
        return s != null ? Strings.concat("'", s, "'") : null;
    }

    public static Object quote(Object o) {
        return o instanceof String ? Strings.quote(o.toString()) : o;
    }

    public static String concat(Object ... objects) {
        if (Arrays.isNullOrEmpty(objects)) {
            return null;
        }
        return java.util.Arrays.stream(objects).map(String::valueOf).collect(Collectors.joining());
    }

    public static String formatIfArgs(String message, Object ... args) {
        return Arrays.isNullOrEmpty(args) ? String.format(Strings.escapePercentExceptWhenFollowedBy_n(message), new Object[0]) : String.format(message, args);
    }

    public static String escapePercent(String value2) {
        return value2 == null ? null : value2.replace("%", "%%");
    }

    public static StringsToJoin join(String ... strings) {
        return new StringsToJoin(strings);
    }

    public static StringsToJoin join(Iterable<?> toStringable) {
        String[] strings = (String[])Streams.stream(toStringable).map(String::valueOf).toArray(String[]::new);
        return new StringsToJoin(strings);
    }

    public static StringToAppend append(String toAppend) {
        return new StringToAppend(toAppend);
    }

    private static String escapePercentExceptWhenFollowedBy_n(String message) {
        return Strings.revertEscapingPercent_n(Strings.escapePercent(message));
    }

    private static String revertEscapingPercent_n(String value2) {
        return value2 == null ? null : value2.replace("%%n", "%n");
    }

    private Strings() {
    }

    public static class StringsToJoin {
        private final String[] strings;

        StringsToJoin(String ... strings) {
            this.strings = strings;
        }

        public String with(String delimiter) {
            return this.with(delimiter, null);
        }

        public String with(String delimiter, String escapeString) {
            Preconditions.checkArgument(delimiter != null, "Delimiter should not be null", new Object[0]);
            if (Arrays.isNullOrEmpty(this.strings)) {
                return "";
            }
            String escape = escapeString == null ? "" : escapeString;
            StringBuilder b = new StringBuilder();
            int stringCount = this.strings.length;
            for (int i2 = 0; i2 < stringCount; ++i2) {
                String s = this.strings[i2];
                if (s != null) {
                    b.append(escape);
                    b.append(s);
                    b.append(escape);
                }
                if (i2 >= stringCount - 1) continue;
                b.append(delimiter);
            }
            return b.toString();
        }
    }

    public static class StringToAppend {
        private final String toAppend;

        StringToAppend(String toAppend) {
            this.toAppend = toAppend;
        }

        public String to(String s) {
            if (!s.endsWith(this.toAppend)) {
                return Strings.concat(s, this.toAppend);
            }
            return s;
        }
    }
}

