/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.description.Description;
import org.assertj.core.error.AssertionErrorMessagesAggregator;
import org.assertj.core.error.DescriptionFormatter;

public class MultipleAssertionsError
extends AssertionError {
    private static final long serialVersionUID = -5547434453993413952L;
    private final List<? extends AssertionError> errors;

    public MultipleAssertionsError(List<? extends AssertionError> errors2) {
        super((Object)MultipleAssertionsError.createMessage(errors2));
        this.errors = errors2;
    }

    public MultipleAssertionsError(Description description, List<? extends AssertionError> errors2) {
        super((Object)(MultipleAssertionsError.formatDescription(description) + MultipleAssertionsError.createMessage(errors2)));
        this.errors = errors2;
    }

    public List<? extends AssertionError> getErrors() {
        return this.errors;
    }

    private static String formatDescription(Description description) {
        return DescriptionFormatter.instance().format(description);
    }

    private static String createMessage(List<? extends AssertionError> errors2) {
        List<String> errorsMessage = errors2.stream().map(Throwable::getMessage).collect(Collectors.toList());
        return AssertionErrorMessagesAggregator.aggregateErrorMessages(errorsMessage);
    }
}

