/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.RecursiveAssertionAssert;
import org.assertj.core.api.RecursiveComparisonAssert;
import org.assertj.core.api.recursive.assertion.RecursiveAssertionConfiguration;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.description.Description;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.util.CheckReturnValue;

public abstract class AbstractObjectAssert<SELF extends AbstractObjectAssert<SELF, ACTUAL>, ACTUAL>
extends AbstractAssert<SELF, ACTUAL> {
    private Map<String, Comparator<?>> comparatorsByPropertyOrField = new TreeMap();
    private TypeComparators comparatorsByType;

    public AbstractObjectAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    @CheckReturnValue
    public SELF as(Description description) {
        return (SELF)((AbstractObjectAssert)super.as(description));
    }

    @Override
    @CheckReturnValue
    public SELF as(String description, Object ... args) {
        return (SELF)((AbstractObjectAssert)super.as(description, args));
    }

    @Deprecated
    public SELF isEqualToIgnoringNullFields(Object other) {
        this.objects.assertIsEqualToIgnoringNullFields(this.info, this.actual, other, this.comparatorsByPropertyOrField, this.getComparatorsByType());
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    @Deprecated
    public SELF isEqualToComparingOnlyGivenFields(Object other, String ... propertiesOrFieldsUsedInComparison) {
        this.objects.assertIsEqualToComparingOnlyGivenFields(this.info, this.actual, other, this.comparatorsByPropertyOrField, this.getComparatorsByType(), propertiesOrFieldsUsedInComparison);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    @Deprecated
    public SELF isEqualToIgnoringGivenFields(Object other, String ... propertiesOrFieldsToIgnore) {
        this.objects.assertIsEqualToIgnoringGivenFields(this.info, this.actual, other, this.comparatorsByPropertyOrField, this.getComparatorsByType(), propertiesOrFieldsToIgnore);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF hasNoNullFieldsOrProperties() {
        this.objects.assertHasNoNullFieldsOrPropertiesExcept(this.info, this.actual, new String[0]);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF hasAllNullFieldsOrProperties() {
        this.objects.assertHasAllNullFieldsOrPropertiesExcept(this.info, this.actual, new String[0]);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF hasNoNullFieldsOrPropertiesExcept(String ... propertiesOrFieldsToIgnore) {
        this.objects.assertHasNoNullFieldsOrPropertiesExcept(this.info, this.actual, propertiesOrFieldsToIgnore);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF hasAllNullFieldsOrPropertiesExcept(String ... propertiesOrFieldsToIgnore) {
        this.objects.assertHasAllNullFieldsOrPropertiesExcept(this.info, this.actual, propertiesOrFieldsToIgnore);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    @Deprecated
    public SELF isEqualToComparingFieldByField(Object other) {
        this.objects.assertIsEqualToIgnoringGivenFields(this.info, this.actual, other, this.comparatorsByPropertyOrField, this.getComparatorsByType(), new String[0]);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    protected TypeComparators getComparatorsByType() {
        if (this.comparatorsByType == null) {
            this.comparatorsByType = TypeComparators.defaultTypeComparators();
        }
        return this.comparatorsByType;
    }

    @CheckReturnValue
    public <T> SELF usingComparatorForFields(Comparator<T> comparator, String ... propertiesOrFields) {
        for (String propertyOrField : propertiesOrFields) {
            this.comparatorsByPropertyOrField.put(propertyOrField, comparator);
        }
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    @CheckReturnValue
    public <T> SELF usingComparatorForType(Comparator<? super T> comparator, Class<T> type) {
        this.getComparatorsByType().registerComparator(type, comparator);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF hasFieldOrProperty(String name) {
        this.objects.assertHasFieldOrProperty(this.info, this.actual, name);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF hasFieldOrPropertyWithValue(String name, Object value2) {
        this.objects.assertHasFieldOrPropertyWithValue(this.info, this.actual, name, value2);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public SELF hasOnlyFields(String ... expectedFieldNames) {
        this.objects.assertHasOnlyFields(this.info, this.actual, expectedFieldNames);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<?>, Object, ObjectAssert<Object>> extracting(String ... propertiesOrFields) {
        Tuple values = Extractors.byName(propertiesOrFields).apply(this.actual);
        String extractedPropertiesOrFieldsDescription = Extractors.extractedDescriptionOf(propertiesOrFields);
        String description = Description.mostRelevantDescription(this.info.description(), extractedPropertiesOrFieldsDescription);
        return ((AbstractListAssert)this.newListAssertInstance(values.toList()).withAssertionState(this.myself)).as(description, new Object[0]);
    }

    @CheckReturnValue
    public AbstractObjectAssert<?, ?> extracting(String propertyOrField) {
        return super.extracting(propertyOrField, this::newObjectAssert);
    }

    @Override
    @CheckReturnValue
    public <ASSERT extends AbstractAssert<?, ?>> ASSERT extracting(String propertyOrField, InstanceOfAssertFactory<?, ASSERT> assertFactory) {
        return super.extracting(propertyOrField, this::newObjectAssert).asInstanceOf(assertFactory);
    }

    @SafeVarargs
    @CheckReturnValue
    public final AbstractListAssert<?, List<?>, Object, ObjectAssert<Object>> extracting(Function<? super ACTUAL, ?> ... extractors) {
        return this.extractingForProxy(extractors);
    }

    protected AbstractListAssert<?, List<?>, Object, ObjectAssert<Object>> extractingForProxy(Function<? super ACTUAL, ?>[] extractors) {
        java.util.Objects.requireNonNull(extractors, ShouldNotBeNull.shouldNotBeNull("extractors")::create);
        List values = Stream.of(extractors).map(extractor -> extractor.apply(this.actual)).collect(Collectors.toList());
        return (AbstractListAssert)this.newListAssertInstance(values).withAssertionState(this.myself);
    }

    @CheckReturnValue
    public <T> AbstractObjectAssert<?, T> extracting(Function<? super ACTUAL, T> extractor) {
        return super.extracting(extractor, this::newObjectAssert);
    }

    @Override
    @CheckReturnValue
    public <T, ASSERT extends AbstractAssert<?, ?>> ASSERT extracting(Function<? super ACTUAL, T> extractor, InstanceOfAssertFactory<?, ASSERT> assertFactory) {
        return super.extracting(extractor, this::newObjectAssert).asInstanceOf(assertFactory);
    }

    @Deprecated
    public SELF isEqualToComparingFieldByFieldRecursively(Object other) {
        this.objects.assertIsEqualToComparingFieldByFieldRecursively(this.info, this.actual, other, this.comparatorsByPropertyOrField, this.getComparatorsByType());
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public <T> SELF returns(T expected, Function<ACTUAL, T> from) {
        java.util.Objects.requireNonNull(from, "The given getter method/Function must not be null");
        this.isNotNull();
        Objects objects = this.getComparatorBasedObjectAssertions(expected);
        objects.assertEqual(this.info, from.apply(this.actual), expected);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    public <T> SELF doesNotReturn(T expected, Function<ACTUAL, T> from) {
        java.util.Objects.requireNonNull(from, "The given getter method/Function must not be null");
        this.isNotNull();
        Objects objects = this.getComparatorBasedObjectAssertions(expected);
        objects.assertNotEqual(this.info, from.apply(this.actual), expected);
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    private Objects getComparatorBasedObjectAssertions(Object value2) {
        if (value2 == null) {
            return this.objects;
        }
        Class<?> type = value2.getClass();
        TypeComparators comparatorsByType = this.getComparatorsByType();
        if (comparatorsByType.hasComparatorForType(type)) {
            return new Objects(new ComparatorBasedComparisonStrategy(comparatorsByType.getComparatorForType(type)));
        }
        return this.objects;
    }

    @Override
    public RecursiveComparisonAssert<?> usingRecursiveComparison() {
        return super.usingRecursiveComparison();
    }

    @Override
    public RecursiveComparisonAssert<?> usingRecursiveComparison(RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        return super.usingRecursiveComparison(recursiveComparisonConfiguration).withTypeComparators(this.comparatorsByType);
    }

    @Override
    public RecursiveAssertionAssert usingRecursiveAssertion() {
        return super.usingRecursiveAssertion();
    }

    @Override
    public RecursiveAssertionAssert usingRecursiveAssertion(RecursiveAssertionConfiguration recursiveAssertionConfiguration) {
        return super.usingRecursiveAssertion(recursiveAssertionConfiguration);
    }

    protected <T> AbstractObjectAssert<?, T> newObjectAssert(T objectUnderTest) {
        return new ObjectAssert<T>(objectUnderTest);
    }

    @Override
    SELF withAssertionState(AbstractAssert assertInstance) {
        if (assertInstance instanceof AbstractObjectAssert) {
            AbstractObjectAssert objectAssert = (AbstractObjectAssert)assertInstance;
            return ((AbstractObjectAssert)((AbstractObjectAssert)super.withAssertionState(assertInstance)).withTypeComparator(objectAssert.comparatorsByType)).withComparatorByPropertyOrField(objectAssert.comparatorsByPropertyOrField);
        }
        return (SELF)((AbstractObjectAssert)super.withAssertionState(assertInstance));
    }

    SELF withTypeComparator(TypeComparators comparatorsByType) {
        this.comparatorsByType = comparatorsByType;
        return (SELF)((AbstractObjectAssert)this.myself);
    }

    SELF withComparatorByPropertyOrField(Map<String, Comparator<?>> comparatorsToPropaget) {
        this.comparatorsByPropertyOrField = comparatorsToPropaget;
        return (SELF)((AbstractObjectAssert)this.myself);
    }
}

