/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.navigation.OCGotoDeclarationHandler;
import com.jetbrains.cidr.lang.navigation.OCGotoTest;
import java.util.Arrays;
import junit.framework.TestCase;

public interface OCGotoDeclarationTestBase
extends OCGotoTest {
    public Project getProject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public void doTest(Pair<String, Integer> source, Pair<String, Integer> ... targets) {
        Project project = this.getProject();
        PsiElement sourceElement = this.findElement((String)source.getFirst(), (Integer)source.getSecond(), project);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(sourceElement.getContainingFile());
        TestCase.assertNotNull((Object)document);
        Editor editor2 = EditorFactory.getInstance().createEditor(document, project);
        try {
            PsiElement targetElement;
            TestCase.assertNotNull((Object)editor2);
            PsiElement[] resolvedElements = new OCGotoDeclarationHandler().getGotoDeclarationTargets(sourceElement, ((Integer)source.getSecond()).intValue(), editor2);
            if ((resolvedElements == null || resolvedElements.length == 0) && (targetElement = TargetElementUtil.getInstance().findTargetElement(editor2, ImplementationSearcher.getFlags(), ((Integer)source.getSecond()).intValue())) != null) {
                resolvedElements = new PsiElement[]{targetElement};
            }
            TestCase.assertTrue((String)"Targets count mismatch", (resolvedElements != null && resolvedElements.length == targets.length ? 1 : 0) != 0);
            this.assertTargets(Arrays.asList(resolvedElements), targets);
        }
        finally {
            EditorFactory.getInstance().releaseEditor(editor2);
        }
    }
}

