/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.util.MathUtil;
import com.intellij.util.TimeoutUtil;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;

final class CpuTimings {
    private static final Mandelbrot MANDELBROT = new Mandelbrot(765);

    CpuTimings() {
    }

    static long calcStableCpuTiming() {
        long start = System.currentTimeMillis();
        long minTime = Integer.MAX_VALUE;
        long minIteration = -1L;
        int i2 = 0;
        while (true) {
            long time;
            if ((time = TimeoutUtil.measureExecutionTime(MANDELBROT::compute)) < minTime) {
                minTime = time;
                minIteration = i2;
            } else if ((long)i2 - minIteration > 100L) {
                System.out.println("CPU timing rating: " + minTime + " (calculated in " + (System.currentTimeMillis() - start) + "ms)");
                return minTime;
            }
            ++i2;
        }
    }

    private static void addBigIntegers() {
        BigInteger k = new BigInteger("1");
        for (int i2 = 0; i2 < 1000000; ++i2) {
            k = k.add(new BigInteger("1"));
        }
    }

    private static void mulDiv() {
        long k = 241L;
        for (int i2 = 0; i2 < 22222222; ++i2) {
            k = i2 % 10 == 3 ? k * 239L : k % 12342L;
        }
        CpuTimings.ensureOdd(k);
    }

    private static void ensureOdd(long k) {
        if (k % 2L == 0L) {
            throw new AssertionError((Object)"Should be an odd value");
        }
    }

    private static void mulDivMemAccess() {
        int[] array = new int[240000];
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = i2 * 42 + 1;
        }
        int k = 241;
        for (int i3 = 0; i3 < 5750000; ++i3) {
            k *= array[MathUtil.nonNegativeAbs((int)k) % array.length];
        }
        CpuTimings.ensureOdd(k);
    }

    public static double getProcessCpuLoad() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList list = mbs.getAttributes(name, new String[]{"ProcessCpuLoad"});
            if (list.isEmpty()) {
                return Double.NaN;
            }
            Attribute att = (Attribute)list.get(0);
            Double value2 = (Double)att.getValue();
            if (value2 == -1.0) {
                return Double.NaN;
            }
            return (double)((int)(value2 * 1000.0)) / 10.0;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static double getSystemCpuLoad() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList list = mbs.getAttributes(name, new String[]{"SystemCpuLoad"});
            if (list.isEmpty()) {
                return Double.NaN;
            }
            Attribute att = (Attribute)list.get(0);
            Double value2 = (Double)att.getValue();
            if (value2 == -1.0) {
                return Double.NaN;
            }
            return (double)((int)(value2 * 1000.0)) / 10.0;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        for (int i2 = 0; i2 < 20; ++i2) {
        }
    }

    private static class Mandelbrot {
        private static final double LIMIT_SQUARED = 4.0;
        private static final int ITERATIONS = 50;
        final int size;
        final double fac;
        final int shift;

        Mandelbrot(int size2) {
            this.size = size2;
            this.fac = 2.0 / (double)size2;
            int offset = size2 % 8;
            this.shift = offset == 0 ? 0 : 8 - offset;
        }

        void compute() {
            int t = 0;
            for (int y = 0; y < this.size; ++y) {
                t += this.computeRow(y);
            }
            if (t == 0) {
                throw new AssertionError();
            }
        }

        private int computeRow(int y) {
            int count = 0;
            for (int x = 0; x < this.size; ++x) {
                double Zr = 0.0;
                double Zi = 0.0;
                double Cr = (double)x * this.fac - 1.5;
                double Ci = (double)y * this.fac - 1.0;
                int i2 = 50;
                double ZrN = 0.0;
                double ZiN = 0.0;
                while (!((ZiN = (Zi = 2.0 * Zr * Zi + Ci) * Zi) + (ZrN = (Zr = ZrN - ZiN + Cr) * Zr) > 4.0) && --i2 > 0) {
                }
                if (i2 != 0) continue;
                ++count;
            }
            return count;
        }
    }
}

