/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.assertion.moduleAssertion;

import com.intellij.platform.testFramework.assertion.collectionAssertion.CollectionAssertions;
import com.intellij.platform.workspace.jps.entities.InheritedSdkDependency;
import com.intellij.platform.workspace.jps.entities.LibraryDependency;
import com.intellij.platform.workspace.jps.entities.ModuleDependency;
import com.intellij.platform.workspace.jps.entities.ModuleDependencyItem;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleSourceDependency;
import com.intellij.platform.workspace.jps.entities.SdkDependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u000f\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011J*\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000b0\u0015J*\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000b0\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/testFramework/assertion/moduleAssertion/DependencyAssertions;", "", "<init>", "()V", "INHERITED_SDK", "", "getINHERITED_SDK", "()Ljava/lang/String;", "MODULE_SOURCE", "getMODULE_SOURCE", "assertDependencies", "", "module", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "expectedNames", "", "(Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;[Ljava/lang/String;)V", "", "assertLibraryDependency", "name", "assertion", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/jps/entities/LibraryDependency;", "assertModuleDependency", "Lcom/intellij/platform/workspace/jps/entities/ModuleDependency;", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nDependencyAssertions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyAssertions.kt\ncom/intellij/platform/testFramework/assertion/moduleAssertion/DependencyAssertions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1557#2:50\n1628#2,3:51\n808#2,11:54\n808#2,11:66\n1#3:65\n*S KotlinDebug\n*F\n+ 1 DependencyAssertions.kt\ncom/intellij/platform/testFramework/assertion/moduleAssertion/DependencyAssertions\n*L\n18#1:50\n18#1:51,3\n31#1:54,11\n41#1:66,11\n*E\n"})
public final class DependencyAssertions {
    @NotNull
    public static final DependencyAssertions INSTANCE = new DependencyAssertions();
    @NotNull
    private static final String INHERITED_SDK;
    @NotNull
    private static final String MODULE_SOURCE;

    private DependencyAssertions() {
    }

    @NotNull
    public final String getINHERITED_SDK() {
        return INHERITED_SDK;
    }

    @NotNull
    public final String getMODULE_SOURCE() {
        return MODULE_SOURCE;
    }

    public final void assertDependencies(@NotNull ModuleEntity module2, String ... expectedNames) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)expectedNames, (String)"expectedNames");
        this.assertDependencies(module2, ArraysKt.asList((Object[])expectedNames));
    }

    /*
     * WARNING - void declaration
     */
    public final void assertDependencies(@NotNull ModuleEntity module2, @NotNull List<String> expectedNames) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter(expectedNames, (String)"expectedNames");
        Iterable $this$map$iv = module2.getDependencies();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void dependency;
            ModuleDependencyItem moduleDependencyItem = (ModuleDependencyItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var13_12 = dependency;
            if (Intrinsics.areEqual((Object)var13_12, (Object)InheritedSdkDependency.INSTANCE)) {
                string = INHERITED_SDK;
            } else if (Intrinsics.areEqual((Object)var13_12, (Object)ModuleSourceDependency.INSTANCE)) {
                string = MODULE_SOURCE;
            } else if (var13_12 instanceof LibraryDependency) {
                string = ((LibraryDependency)dependency).getLibrary().getName();
            } else if (var13_12 instanceof ModuleDependency) {
                string = ((ModuleDependency)dependency).getModule().getName();
            } else if (var13_12 instanceof SdkDependency) {
                string = ((SdkDependency)dependency).getSdk().getName();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(string);
        }
        List actualNames = (List)destination$iv$iv;
        CollectionAssertions.assertEqualsUnordered$default(expectedNames, actualNames, null, 4, null);
    }

    public final void assertLibraryDependency(@NotNull ModuleEntity module2, @NotNull String name, @NotNull Function1<? super LibraryDependency, Unit> assertion) {
        Object v0;
        block2: {
            Iterator $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(assertion, (String)"assertion");
            Iterable $this$filterIsInstance$iv = module2.getDependencies();
            boolean $i$f$filterIsInstance22 = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                if (!(element$iv$iv instanceof LibraryDependency)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filterIsInstance22 = (List)destination$iv$iv;
            for (Object t : $i$f$filterIsInstance22) {
                LibraryDependency it = (LibraryDependency)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getLibrary().getName(), (Object)name)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        LibraryDependency dependency = v0;
        boolean bl = false;
        Assertions.assertNotNull((Object)dependency, (String)("Cannot find '" + name + "' library dependency in '" + module2.getName() + "' module"));
        LibraryDependency libraryDependency = dependency;
        Intrinsics.checkNotNull((Object)libraryDependency);
        Assertions.assertEquals((Object)name, (Object)libraryDependency.getLibrary().getName());
        assertion.invoke((Object)dependency);
    }

    public final void assertModuleDependency(@NotNull ModuleEntity module2, @NotNull String name, @NotNull Function1<? super ModuleDependency, Unit> assertion) {
        Object v0;
        block2: {
            Iterator $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(assertion, (String)"assertion");
            Iterable $this$filterIsInstance$iv = module2.getDependencies();
            boolean $i$f$filterIsInstance22 = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                if (!(element$iv$iv instanceof ModuleDependency)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filterIsInstance22 = (List)destination$iv$iv;
            for (Object t : $i$f$filterIsInstance22) {
                ModuleDependency it = (ModuleDependency)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getModule().getName(), (Object)name)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        ModuleDependency dependency = v0;
        boolean bl = false;
        Assertions.assertNotNull((Object)dependency, (String)("Cannot find '" + name + "' module dependency in '" + module2.getName() + "' module"));
        ModuleDependency moduleDependency = dependency;
        Intrinsics.checkNotNull((Object)moduleDependency);
        Assertions.assertEquals((Object)name, (Object)moduleDependency.getModule().getName());
        assertion.invoke((Object)dependency);
    }

    static {
        String string = Reflection.getOrCreateKotlinClass(InheritedSdkDependency.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        INHERITED_SDK = string;
        String string2 = Reflection.getOrCreateKotlinClass(ModuleSourceDependency.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string2);
        MODULE_SOURCE = string2;
    }
}

