/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.dfaassist;

import com.intellij.debugger.engine.MockDebugProcess;
import com.intellij.debugger.engine.dfaassist.DebuggerDfaRunner;
import com.intellij.debugger.engine.dfaassist.DfaTestUtilsKt;
import com.intellij.debugger.mockJDI.MockStackFrame;
import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.impl.dfaassist.DfaResult;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public abstract class DfaAssistTest
extends LightPlatformCodeInsightTestCase {
    protected void doTest(String text, BiConsumer<? super MockVirtualMachine, ? super MockStackFrame> mockValues, String fileName) {
        this.doTest(text, mockValues, fileName, "");
    }

    protected void doTest(String text, BiConsumer<? super MockVirtualMachine, ? super MockStackFrame> mockValues, String fileName, @Nullable String context2) {
        DfaResult dfaResult;
        String filteredText = text.replaceAll("/\\*\\w+\\*/", "");
        this.configureFromFileText(fileName, filteredText);
        PsiFile file = this.getFile();
        int offset = this.getEditor().getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        DfaAssistTest.assertNotNull((String)context2, (Object)element);
        MockVirtualMachine vm = new MockVirtualMachine();
        MockStackFrame frame = new MockStackFrame(vm, element);
        mockValues.accept(vm, frame);
        MockDebugProcess process = new MockDebugProcess(this.getProject(), vm, this.getTestRootDisposable());
        DebuggerDfaRunner runner = DfaTestUtilsKt.getDfaRunnerNow(element, process, frame);
        DfaAssistTest.assertNotNull((String)context2, (Object)runner);
        try {
            dfaResult = (DfaResult)ReadAction.nonBlocking(() -> runner.computeHints()).submit((Executor)AppExecutorUtil.getAppExecutorService()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        Map hints = dfaResult.hints;
        String fileText = filteredText.replace("<caret>", "");
        EntryStream hintStream = EntryStream.of((Map)hints).mapKeys(ex -> ex.getTextRange().getEndOffset()).mapValues(hint -> "/*" + hint + "*/");
        EntryStream unreachableStream = StreamEx.of((Collection)dfaResult.unreachable).flatMapToEntry(range -> Map.of(range.getStartOffset(), "/*unreachable_start*/", range.getEndOffset(), "/*unreachable_end*/"));
        String result = ((StreamEx)((EntryStream)((EntryStream)hintStream.append((Stream)unreachableStream)).sorted(Map.Entry.comparingByKey())).prepend((Object)0, (Object)"").append((Object)fileText.length(), (Object)"").chain(StreamEx::of)).pairMap((prev, next) -> StreamEx.of((Object[])new String[]{fileText.substring((Integer)prev.getKey(), (Integer)next.getKey()), (String)next.getValue()})).flatMap(Function.identity()).joining();
        String expectedText = text.replace("<caret>", "");
        DfaAssistTest.assertEquals((String)context2, (String)expectedText, (String)result);
    }
}

