/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test.junit4.matchers;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.test.junit4.matchers.BitmapMatcher;
import androidx.compose.ui.test.junit4.matchers.MatchResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Landroidx/compose/ui/test/junit4/matchers/PixelPerfectMatcher;", "Landroidx/compose/ui/test/junit4/matchers/BitmapMatcher;", "()V", "compareBitmaps", "Landroidx/compose/ui/test/junit4/matchers/MatchResult;", "expected", "", "given", "width", "", "height", "diffColor", "referenceColor", "testColor", "ui-test-junit4"})
@StabilityInferred(parameters=1)
public final class PixelPerfectMatcher
implements BitmapMatcher {
    public static final int $stable;

    @Override
    @NotNull
    public MatchResult compareBitmaps(@NotNull int[] expected, @NotNull int[] given, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)given, (String)"given");
        if (!(expected.length == given.length)) {
            throw new IllegalStateException("Check failed.");
        }
        int different = 0;
        int same = 0;
        int[] diffArray = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int index = x + y * width;
                int referenceColor = expected[index];
                int testColor = given[index];
                if (referenceColor == testColor) {
                    ++same;
                } else {
                    ++different;
                }
                diffArray[index] = this.diffColor(referenceColor, testColor);
            }
        }
        if (different > 0) {
            String stats = "[PixelPerfect] Same pixels: " + same + ", Different pixels: " + different;
            return new MatchResult(false, stats, diffArray);
        }
        String stats = "[PixelPerfect]";
        return new MatchResult(true, stats, null);
    }

    private final int diffColor(int referenceColor, int testColor) {
        return referenceColor != testColor ? -65281 : 0;
    }
}

