/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test.junit4;

import androidx.annotation.FloatRange;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.test.InternalTestApi;
import androidx.compose.ui.test.junit4.DesktopScreenshotTestRule_desktopKt;
import androidx.compose.ui.test.junit4.ScreenshotResultProto;
import androidx.compose.ui.test.junit4.matchers.BitmapMatcher;
import androidx.compose.ui.test.junit4.matchers.MSSIMMatcher;
import androidx.compose.ui.test.junit4.matchers.MatchResult;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.Image;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00032\b\b\u0003\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u000eH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u001c\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u0002JD\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Landroidx/compose/ui/test/junit4/ScreenshotTestRule;", "Lorg/junit/rules/TestRule;", "fsGoldenPath", "", "modulePath", "(Ljava/lang/String;Ljava/lang/String;)V", "imageExtension", "testIdentifier", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "assertImageAgainstGolden", "", "actual", "Lorg/jetbrains/skia/Image;", "goldenIdentifier", "matcher", "Landroidx/compose/ui/test/junit4/matchers/BitmapMatcher;", "idSuffix", "threshold", "", "dumpImage", "path", "data", "", "ensureDir", "fetchExpectedImage", "goldenIdentifierResolver", "id", "suffix", "reportResult", "status", "Landroidx/compose/ui/test/junit4/ScreenshotResultProto$Status;", "comparisonStatistics", "expected", "diff", "ui-test-junit4"})
@InternalTestApi
@StabilityInferred(parameters=0)
public final class ScreenshotTestRule
implements TestRule {
    @NotNull
    private final String fsGoldenPath;
    @NotNull
    private final String modulePath;
    @NotNull
    private final String imageExtension;
    private String testIdentifier;
    public static final int $stable = 8;

    public ScreenshotTestRule(@NotNull String fsGoldenPath, @NotNull String modulePath) {
        Intrinsics.checkNotNullParameter((Object)fsGoldenPath, (String)"fsGoldenPath");
        Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
        this.fsGoldenPath = fsGoldenPath;
        this.modulePath = modulePath;
        this.imageExtension = ".png";
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @Nullable Description description) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        return new Statement(this, description, base){
            final /* synthetic */ ScreenshotTestRule this$0;
            final /* synthetic */ Description $description;
            final /* synthetic */ Statement $base;
            {
                this.this$0 = $receiver;
                this.$description = $description;
                this.$base = $base;
            }

            public void evaluate() {
                Description description = this.$description;
                Intrinsics.checkNotNull((Object)description);
                ScreenshotTestRule.access$setTestIdentifier$p(this.this$0, StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)(description.getClassName() + "_" + this.$description.getMethodName()), (String)".", (String)"_", (boolean)false, (int)4, null), (String)",", (String)"_", (boolean)false, (int)4, null), (String)" ", (String)"_", (boolean)false, (int)4, null), (String)"__", (String)"_", (boolean)false, (int)4, null));
                this.$base.evaluate();
            }
        };
    }

    public final void assertImageAgainstGolden(@NotNull Image actual, @Nullable String idSuffix, @FloatRange(from=0.0, to=1.0) double threshold) {
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        String string = this.testIdentifier;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testIdentifier");
            string = null;
        }
        String string2 = idSuffix;
        String goldenIdentifier = string + (String)(string2 != null ? "_" + string2 : "");
        MSSIMMatcher matcher = new MSSIMMatcher(threshold);
        this.assertImageAgainstGolden(actual, goldenIdentifier, matcher);
    }

    public static /* synthetic */ void assertImageAgainstGolden$default(ScreenshotTestRule screenshotTestRule, Image image, String string, double d, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            d = 0.96;
        }
        screenshotTestRule.assertImageAgainstGolden(image, string, d);
    }

    private final void assertImageAgainstGolden(Image actual, String goldenIdentifier, BitmapMatcher matcher) {
        CharSequence charSequence = goldenIdentifier;
        if (!new Regex("^[A-Za-z0-9_-]+$").matches(charSequence)) {
            throw new IllegalArgumentException("The given golden identifier '" + goldenIdentifier + "' does not satisfy the naming requirement. Allowed characters are: '[A-Za-z0-9_-]'");
        }
        Image expected = this.fetchExpectedImage(goldenIdentifier);
        if (expected == null) {
            ScreenshotTestRule.reportResult$default(this, ScreenshotResultProto.Status.MISSING_GOLDEN, goldenIdentifier, actual, null, null, null, 56, null);
            throw new AssertionError((Object)("Missing golden image '" + ScreenshotTestRule.goldenIdentifierResolver$default(this, goldenIdentifier, null, 2, null) + "'. Did you mean to check in a new image?"));
        }
        if (actual.getWidth() != expected.getWidth() || actual.getHeight() != expected.getHeight()) {
            ScreenshotTestRule.reportResult$default(this, ScreenshotResultProto.Status.SIZE_MISMATCH, goldenIdentifier, actual, null, expected, null, 40, null);
            throw new AssertionError((Object)("Sizes are different! Expected: [" + expected.getWidth() + ", " + expected.getHeight() + "], Actual: [" + actual.getWidth() + ", " + actual.getHeight() + "]"));
        }
        MatchResult comparisonResult = matcher.compareBitmaps(DesktopScreenshotTestRule_desktopKt.access$toIntArray(expected), DesktopScreenshotTestRule_desktopKt.access$toIntArray(actual), actual.getWidth(), actual.getHeight());
        ScreenshotResultProto.Status status = comparisonResult.getMatches() ? ScreenshotResultProto.Status.PASSED : ScreenshotResultProto.Status.FAILED;
        int[] nArray = comparisonResult.getDiff();
        this.reportResult(status, goldenIdentifier, actual, comparisonResult.getComparisonStatistics(), expected, nArray != null ? DesktopScreenshotTestRule_desktopKt.access$toImage(nArray, actual.getWidth(), actual.getHeight()) : null);
        if (!comparisonResult.getMatches()) {
            throw new AssertionError((Object)("Image mismatch!\n\tExpected image: '" + ScreenshotTestRule.goldenIdentifierResolver$default(this, goldenIdentifier, null, 2, null) + "'\n\tActual image: '" + this.goldenIdentifierResolver(goldenIdentifier, "actual") + "'\n\tDiff image: '" + this.goldenIdentifierResolver(goldenIdentifier, "diff") + "'\n\tFS location: '" + this.fsGoldenPath + "'\n\tComparison stats: '" + comparisonResult.getComparisonStatistics() + "'"));
        }
    }

    private final void dumpImage(String path, byte[] data) {
        File file = new File(this.fsGoldenPath, path);
        FilesKt.writeBytes((File)file, (byte[])data);
    }

    private final String goldenIdentifierResolver(String id, String suffix) {
        return suffix == null ? this.modulePath + "/" + id + this.imageExtension : this.modulePath + "/" + id + "_" + suffix + this.imageExtension;
    }

    static /* synthetic */ String goldenIdentifierResolver$default(ScreenshotTestRule screenshotTestRule, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return screenshotTestRule.goldenIdentifierResolver(string, string2);
    }

    private final Image fetchExpectedImage(String goldenIdentifier) {
        File file = new File(this.fsGoldenPath, ScreenshotTestRule.goldenIdentifierResolver$default(this, goldenIdentifier, null, 2, null));
        if (!file.exists()) {
            return null;
        }
        return Image.Companion.makeFromEncoded(FilesKt.readBytes((File)file));
    }

    private final void ensureDir() {
        new File(this.fsGoldenPath, this.modulePath).mkdirs();
    }

    private final void reportResult(ScreenshotResultProto.Status status, String goldenIdentifier, Image actual, String comparisonStatistics, Image expected, Image diff) {
        if (status == ScreenshotResultProto.Status.PASSED) {
            return;
        }
        String currentScreenshotFileName = this.goldenIdentifierResolver(goldenIdentifier, "actual");
        this.ensureDir();
        Data data = Image.encodeToData$default((Image)actual, null, (int)0, (int)3, null);
        Intrinsics.checkNotNull((Object)data);
        byte[] encodedActual = data.getBytes();
        this.dumpImage(currentScreenshotFileName, encodedActual);
        if (diff != null) {
            String diffImageFileName = this.goldenIdentifierResolver(goldenIdentifier, "diff");
            Data data2 = Image.encodeToData$default((Image)diff, null, (int)0, (int)3, null);
            Intrinsics.checkNotNull((Object)data2);
            byte[] encodedDiff = data2.getBytes();
            this.dumpImage(diffImageFileName, encodedDiff);
        }
    }

    static /* synthetic */ void reportResult$default(ScreenshotTestRule screenshotTestRule, ScreenshotResultProto.Status status, String string, Image image, String string2, Image image2, Image image3, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            image2 = null;
        }
        if ((n & 0x20) != 0) {
            image3 = null;
        }
        screenshotTestRule.reportResult(status, string, image, string2, image2, image3);
    }

    public static final /* synthetic */ void access$setTestIdentifier$p(ScreenshotTestRule $this, String string) {
        $this.testIdentifier = string;
    }
}

