/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.test.ErrorMessagesKt;
import androidx.compose.ui.test.OutputKt;
import androidx.compose.ui.test.SelectionResult;
import androidx.compose.ui.test.SemanticsMatcher;
import androidx.compose.ui.test.SemanticsSelector;
import androidx.compose.ui.test.SemanticsSelectorKt;
import androidx.compose.ui.test.TestContext;
import androidx.compose.ui.test.TestOwnerKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\rJ\u0012\u0010\u0018\u001a\u00020\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\rJ\u001e\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u001b\u001a\u00020\u0005H\u0002J\u0012\u0010\u001c\u001a\u00020\u001a2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\rJ+\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u001b\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b J\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\"2\b\u0010\u0017\u001a\u0004\u0018\u00010\rH\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Landroidx/compose/ui/test/SemanticsNodeInteraction;", "", "testContext", "Landroidx/compose/ui/test/TestContext;", "useUnmergedTree", "", "matcher", "Landroidx/compose/ui/test/SemanticsMatcher;", "(Landroidx/compose/ui/test/TestContext;ZLandroidx/compose/ui/test/SemanticsMatcher;)V", "selector", "Landroidx/compose/ui/test/SemanticsSelector;", "(Landroidx/compose/ui/test/TestContext;ZLandroidx/compose/ui/test/SemanticsSelector;)V", "lastSeenSemantics", "", "getSelector$ui_test", "()Landroidx/compose/ui/test/SemanticsSelector;", "getTestContext$ui_test", "()Landroidx/compose/ui/test/TestContext;", "getUseUnmergedTree$ui_test", "()Z", "assertDoesNotExist", "", "assertExists", "errorMessageOnFail", "assertIsDeactivated", "fetchOneOrThrow", "Landroidx/compose/ui/semantics/SemanticsNode;", "skipDeactivatedNodes", "fetchSemanticsNode", "fetchSemanticsNodes", "Landroidx/compose/ui/test/SelectionResult;", "atLeastOneRootRequired", "fetchSemanticsNodes$ui_test", "getNodesInUnmergedTree", "", "ui-test"})
@StabilityInferred(parameters=0)
public final class SemanticsNodeInteraction {
    @NotNull
    private final TestContext testContext;
    private final boolean useUnmergedTree;
    @NotNull
    private final SemanticsSelector selector;
    @Nullable
    private String lastSeenSemantics;
    public static final int $stable = 8;

    public SemanticsNodeInteraction(@NotNull TestContext testContext, boolean useUnmergedTree, @NotNull SemanticsSelector selector) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        this.testContext = testContext;
        this.useUnmergedTree = useUnmergedTree;
        this.selector = selector;
    }

    @NotNull
    public final TestContext getTestContext$ui_test() {
        return this.testContext;
    }

    public final boolean getUseUnmergedTree$ui_test() {
        return this.useUnmergedTree;
    }

    @NotNull
    public final SemanticsSelector getSelector$ui_test() {
        return this.selector;
    }

    public SemanticsNodeInteraction(@NotNull TestContext testContext, boolean useUnmergedTree, @NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        this(testContext, useUnmergedTree, SemanticsSelectorKt.SemanticsSelector(matcher));
    }

    @NotNull
    public final SelectionResult fetchSemanticsNodes$ui_test(boolean atLeastOneRootRequired, @Nullable String errorMessageOnFail, boolean skipDeactivatedNodes) {
        return (SelectionResult)TestOwnerKt.getAllSemanticsNodes(this.testContext.getTestOwner$ui_test(), atLeastOneRootRequired, this.useUnmergedTree, skipDeactivatedNodes, (Function1)new Function1<Iterable<? extends SemanticsNode>, SelectionResult>(this, errorMessageOnFail){
            final /* synthetic */ SemanticsNodeInteraction this$0;
            final /* synthetic */ String $errorMessageOnFail;
            {
                this.this$0 = $receiver;
                this.$errorMessageOnFail = $errorMessageOnFail;
                super(1);
            }

            public final SelectionResult invoke(Iterable<SemanticsNode> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                SemanticsSelector semanticsSelector = this.this$0.getSelector$ui_test();
                String string = this.$errorMessageOnFail;
                if (string == null) {
                    string = "";
                }
                return semanticsSelector.map(it, string);
            }
        });
    }

    public static /* synthetic */ SelectionResult fetchSemanticsNodes$ui_test$default(SemanticsNodeInteraction semanticsNodeInteraction, boolean bl, String string, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return semanticsNodeInteraction.fetchSemanticsNodes$ui_test(bl, string, bl2);
    }

    @NotNull
    public final SemanticsNode fetchSemanticsNode(@Nullable String errorMessageOnFail) {
        return SemanticsNodeInteraction.fetchOneOrThrow$default(this, errorMessageOnFail, false, 2, null);
    }

    public static /* synthetic */ SemanticsNode fetchSemanticsNode$default(SemanticsNodeInteraction semanticsNodeInteraction, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return semanticsNodeInteraction.fetchSemanticsNode(string);
    }

    public final void assertDoesNotExist() {
        SelectionResult result = SemanticsNodeInteraction.fetchSemanticsNodes$ui_test$default(this, false, "Failed: assertDoesNotExist.", false, 4, null);
        if (!((Collection)result.getSelectedNodes()).isEmpty()) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForCountMismatch$default("Failed: assertDoesNotExist.", this.selector, result.getSelectedNodes(), 0, null, 16, null));
        }
    }

    @NotNull
    public final SemanticsNodeInteraction assertExists(@Nullable String errorMessageOnFail) {
        SemanticsNodeInteraction.fetchOneOrThrow$default(this, errorMessageOnFail, false, 2, null);
        return this;
    }

    public static /* synthetic */ SemanticsNodeInteraction assertExists$default(SemanticsNodeInteraction semanticsNodeInteraction, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return semanticsNodeInteraction.assertExists(string);
    }

    public final void assertIsDeactivated(@Nullable String errorMessageOnFail) {
        SemanticsNode node = SemanticsNodeInteraction.fetchOneOrThrow$default(this, null, false, 1, null);
        if (!node.getLayoutInfo().isDeactivated()) {
            String string = errorMessageOnFail;
            if (string == null) {
                string = "Failed: assertDeactivated";
            }
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage(string, this.selector, node));
        }
    }

    public static /* synthetic */ void assertIsDeactivated$default(SemanticsNodeInteraction semanticsNodeInteraction, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        semanticsNodeInteraction.assertIsDeactivated(string);
    }

    private final SemanticsNode fetchOneOrThrow(String errorMessageOnFail, boolean skipDeactivatedNodes) {
        String finalErrorMessage;
        SelectionResult result;
        String string = errorMessageOnFail;
        if (string == null) {
            string = "Failed: assertExists.";
        }
        if (((Collection)(result = this.fetchSemanticsNodes$ui_test(true, finalErrorMessage = string, skipDeactivatedNodes)).getSelectedNodes()).size() != 1) {
            if (result.getSelectedNodes().isEmpty() && this.lastSeenSemantics != null) {
                String string2 = this.lastSeenSemantics;
                Intrinsics.checkNotNull((Object)string2);
                throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForNodeMissingInTree(finalErrorMessage, this.selector, string2));
            }
            if (result.getCustomErrorOnNoMatch() != null) {
                throw new AssertionError((Object)(finalErrorMessage + "\n" + result.getCustomErrorOnNoMatch()));
            }
            List<SemanticsNode> list = result.getSelectedNodes();
            SemanticsSelector semanticsSelector = this.selector;
            List<SemanticsNode> list2 = this.getNodesInUnmergedTree(errorMessageOnFail);
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForCountMismatch(finalErrorMessage, semanticsSelector, list, 1, list2));
        }
        this.lastSeenSemantics = OutputKt.printToString$default((SemanticsNode)CollectionsKt.first(result.getSelectedNodes()), 0, 1, null);
        return (SemanticsNode)CollectionsKt.first(result.getSelectedNodes());
    }

    static /* synthetic */ SemanticsNode fetchOneOrThrow$default(SemanticsNodeInteraction semanticsNodeInteraction, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return semanticsNodeInteraction.fetchOneOrThrow(string, bl);
    }

    private final List<SemanticsNode> getNodesInUnmergedTree(String errorMessageOnFail) {
        return !this.useUnmergedTree ? (List)TestOwnerKt.getAllSemanticsNodes$default(this.testContext.getTestOwner$ui_test(), true, true, false, (Function1)new Function1<Iterable<? extends SemanticsNode>, List<? extends SemanticsNode>>(this, errorMessageOnFail){
            final /* synthetic */ SemanticsNodeInteraction this$0;
            final /* synthetic */ String $errorMessageOnFail;
            {
                this.this$0 = $receiver;
                this.$errorMessageOnFail = $errorMessageOnFail;
                super(1);
            }

            public final List<SemanticsNode> invoke(Iterable<SemanticsNode> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                SemanticsSelector semanticsSelector = this.this$0.getSelector$ui_test();
                String string = this.$errorMessageOnFail;
                if (string == null) {
                    string = "";
                }
                return semanticsSelector.map(it, string).getSelectedNodes();
            }
        }, 4, null) : CollectionsKt.emptyList();
    }
}

