/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection.annotation;

import android.databinding.tool.LibTypes;
import android.databinding.tool.reflection.ImportBag;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.TypeUtil;
import android.databinding.tool.reflection.annotation.AnnotationClass;
import android.databinding.tool.reflection.annotation.AnnotationTypeUtil;
import android.databinding.tool.util.L;
import com.google.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class AnnotationAnalyzer
extends ModelAnalyzer {
    public static final Map<String, TypeKind> PRIMITIVE_TYPES = new HashMap<String, TypeKind>();
    public final ProcessingEnvironment mProcessingEnv;

    public AnnotationAnalyzer(ProcessingEnvironment processingEnvironment, LibTypes libTypes) {
        super(libTypes);
        this.mProcessingEnv = processingEnvironment;
    }

    public static AnnotationAnalyzer get() {
        return (AnnotationAnalyzer)AnnotationAnalyzer.getInstance();
    }

    @Override
    public AnnotationClass loadPrimitive(String className) {
        TypeKind typeKind = PRIMITIVE_TYPES.get(className);
        if (typeKind == null) {
            return null;
        }
        Types typeUtils = this.getTypeUtils();
        return new AnnotationClass(typeUtils.getPrimitiveType(typeKind));
    }

    @Override
    public ModelClass findClassInternal(String className, ImportBag imports) {
        DeclaredType declaredType;
        Types typeUtils = this.getTypeUtils();
        className = className.trim();
        int numDimensions = 0;
        while (className.endsWith("[]")) {
            ++numDimensions;
            className = className.substring(0, className.length() - 2);
        }
        AnnotationClass primitive = this.loadPrimitive(className);
        if (primitive != null) {
            return this.addDimension(primitive.typeMirror, numDimensions);
        }
        if ("void".equals(className)) {
            return this.addDimension(typeUtils.getNoType(TypeKind.VOID), numDimensions);
        }
        int templateOpenIndex = className.indexOf(60);
        if (templateOpenIndex < 0) {
            TypeElement typeElement = this.getTypeElement(className, imports);
            if (typeElement == null) {
                return null;
            }
            declaredType = MoreTypes.asDeclared((TypeMirror)typeElement.asType());
        } else {
            int templateCloseIndex = className.lastIndexOf(62);
            String paramStr = className.substring(templateOpenIndex + 1, templateCloseIndex);
            String baseClassName = className.substring(0, templateOpenIndex);
            TypeElement typeElement = this.getTypeElement(baseClassName, imports);
            if (typeElement == null) {
                L.e("cannot find type element for %s", baseClassName);
                return null;
            }
            ArrayList<String> templateParameters = this.splitTemplateParameters(paramStr);
            TypeMirror[] typeArgs = new TypeMirror[templateParameters.size()];
            for (int i = 0; i < typeArgs.length; ++i) {
                AnnotationClass clazz = (AnnotationClass)this.findClass(templateParameters.get(i), imports);
                if (clazz == null) {
                    L.e("cannot find type argument for %s in %s", templateParameters.get(i), baseClassName);
                    return null;
                }
                typeArgs[i] = clazz.typeMirror;
            }
            declaredType = typeUtils.getDeclaredType(typeElement, typeArgs);
        }
        return this.addDimension(declaredType, numDimensions);
    }

    private AnnotationClass addDimension(TypeMirror type, int numDimensions) {
        while (numDimensions > 0) {
            type = this.getTypeUtils().getArrayType(type);
            --numDimensions;
        }
        return new AnnotationClass(type);
    }

    private TypeElement getTypeElement(String className, ImportBag imports) {
        String importedClass;
        boolean hasDot;
        Elements elementUtils = this.getElementUtils();
        boolean bl = hasDot = className.indexOf(46) >= 0;
        if (!hasDot && imports != null && (importedClass = imports.find(className)) != null) {
            className = importedClass;
        }
        if (className.indexOf(46) < 0) {
            String javaLangClass = "java.lang." + className;
            try {
                TypeElement javaLang = elementUtils.getTypeElement(javaLangClass);
                if (javaLang != null) {
                    return javaLang;
                }
            }
            catch (Exception javaLang) {
                // empty catch block
            }
        }
        try {
            String converted;
            int lastDot;
            TypeElement parent;
            TypeElement typeElement = elementUtils.getTypeElement(className);
            if (typeElement == null && hasDot && imports != null && (parent = this.getTypeElement(className.substring(0, lastDot = className.lastIndexOf(46)), imports)) != null) {
                String name = parent.getQualifiedName() + "." + className.substring(lastDot + 1);
                return this.getTypeElement(name, null);
            }
            if (typeElement == null && !(converted = this.libTypes.convert(className)).equals(className)) {
                return this.getTypeElement(converted, imports);
            }
            return typeElement;
        }
        catch (Exception e) {
            return null;
        }
    }

    private ArrayList<String> splitTemplateParameters(String templateParameters) {
        ArrayList<String> list = new ArrayList<String>();
        int openCount = 0;
        StringBuilder arg = new StringBuilder();
        for (int index = 0; index < templateParameters.length(); ++index) {
            char c = templateParameters.charAt(index);
            if (c == ',' && openCount == 0) {
                list.add(arg.toString());
                arg.delete(0, arg.length());
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            arg.append(c);
            if (c == '<') {
                ++openCount;
                continue;
            }
            if (c != '>') continue;
            --openCount;
        }
        list.add(arg.toString());
        return list;
    }

    public ModelClass findClass(Class classType) {
        return this.findClass(classType.getCanonicalName(), null);
    }

    public Types getTypeUtils() {
        return this.mProcessingEnv.getTypeUtils();
    }

    public Elements getElementUtils() {
        return this.mProcessingEnv.getElementUtils();
    }

    public ProcessingEnvironment getProcessingEnv() {
        return this.mProcessingEnv;
    }

    @Override
    public TypeUtil createTypeUtil() {
        return new AnnotationTypeUtil(this);
    }

    @Override
    protected boolean findGeneratedAnnotation() {
        return this.getElementUtils().getTypeElement(GENERATED_ANNOTATION) != null;
    }

    static {
        PRIMITIVE_TYPES.put("boolean", TypeKind.BOOLEAN);
        PRIMITIVE_TYPES.put("byte", TypeKind.BYTE);
        PRIMITIVE_TYPES.put("short", TypeKind.SHORT);
        PRIMITIVE_TYPES.put("char", TypeKind.CHAR);
        PRIMITIVE_TYPES.put("int", TypeKind.INT);
        PRIMITIVE_TYPES.put("long", TypeKind.LONG);
        PRIMITIVE_TYPES.put("float", TypeKind.FLOAT);
        PRIMITIVE_TYPES.put("double", TypeKind.DOUBLE);
    }
}

