/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrUtilsExecutionBundle;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import com.jetbrains.cidr.system.RemoteUnixPipe;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cidr.toolchains.PathSeparator;
import com.jetbrains.cidr.toolchains.wsl.CidrWSLDistribution;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class CidrWSLHost
implements HostMachine {
    @NotNull
    protected final CidrWSLDistribution myWSL;

    public CidrWSLHost(@NotNull CidrWSLDistribution wsl) {
        if (wsl == null) {
            CidrWSLHost.$$$reportNull$$$0(0);
        }
        this.myWSL = wsl;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public boolean isWsl() {
        return true;
    }

    @Override
    public boolean hasRemoteFS() {
        return false;
    }

    @Override
    @NotNull
    public OSType getOSType() {
        OSType oSType = OSType.LINUX;
        if (oSType == null) {
            CidrWSLHost.$$$reportNull$$$0(1);
        }
        return oSType;
    }

    @Override
    @NotNull
    public String getName() {
        String string = "WSL (" + this.myWSL.getWslDistributionName() + ")";
        if (string == null) {
            CidrWSLHost.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getHostId() {
        String string = this.myWSL.getWslDistributionName();
        if (string == null) {
            CidrWSLHost.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String convertToLocal(@NotNull String remotePath) {
        if (remotePath == null) {
            CidrWSLHost.$$$reportNull$$$0(4);
        }
        String string = this.myWSL.toLocalPath(null, remotePath);
        if (string == null) {
            CidrWSLHost.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String convertToRemote(@NotNull String localPath) {
        if (localPath == null) {
            CidrWSLHost.$$$reportNull$$$0(6);
        }
        String string = this.myWSL.toEnvPath(localPath);
        if (string == null) {
            CidrWSLHost.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public NamedPipe openNamedPipe() throws ExecutionException {
        return new RemoteUnixPipe(this);
    }

    @Override
    @NotNull
    public CidrProcessBuilder createProcessBuilder() {
        final WSLDistribution distribution = this.myWSL.getWslDistribution();
        return new CidrProcessBuilder(){

            @Override
            @NotNull
            protected BaseProcessHandler<?> build(@NotNull GeneralCommandLine cl, @NotNull CidrProcessBuilder.Parameters params) throws ExecutionException {
                if (cl == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (params == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (distribution == null) {
                    throw new ExecutionException(CidrUtilsExecutionBundle.message("wsl.toolchain.not.found", CidrWSLHost.this.myWSL.getWslDistributionName()));
                }
                cl = CidrWSLHost.this.patchCommandLine(distribution, cl, params.isElevated());
                Object processHandler = params.isEmulateTerminal() ? new LocalHost.TerminalEmulatorOSProcessHandler(cl) : (params.isColored() ? new LocalHost.ParameterizedColoredProcessHandler(cl, params) : (params.isCapturedOutput() ? new LocalHost.ParameterizedCapturingProcessHandler(cl, params) : new LocalHost.ParameterizedOSProcessHandler(cl, params)));
                CidrRunProcessUtil.setHasPty(processHandler, params.isPty());
                Object object = processHandler;
                if (object == null) {
                    1.$$$reportNull$$$0(2);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cl";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "params";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/toolchains/wsl/CidrWSLHost$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/toolchains/wsl/CidrWSLHost$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "build";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "build";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Override
    public void destroyProcess(@NotNull BaseProcessHandler<?> handler) {
        if (handler == null) {
            CidrWSLHost.$$$reportNull$$$0(8);
        }
        handler.destroyProcess();
    }

    @NotNull
    private GeneralCommandLine patchCommandLine(@NotNull WSLDistribution dist, @NotNull GeneralCommandLine cl, boolean isElevated) throws ExecutionException {
        if (dist == null) {
            CidrWSLHost.$$$reportNull$$$0(9);
        }
        if (cl == null) {
            CidrWSLHost.$$$reportNull$$$0(10);
        }
        if (cl instanceof PtyCommandLine) {
            ((PtyCommandLine)cl).withInitialColumns(2500);
        }
        String exe = cl.getExePath();
        cl.setExePath(this.convertToRemote(exe));
        Path wd = cl.getWorkingDirectory();
        String wdPath = wd == null ? null : this.convertToRemote(wd.normalize().toString());
        WSLCommandLineOptions options = new WSLCommandLineOptions().setSudo(isElevated).setRemoteWorkingDirectory(wdPath).setExecuteCommandInLoginShell(AdvancedSettings.getBoolean((String)"wsl.toolchain.execute.login.shell")).setSleepTimeoutSec(Registry.doubleValue((String)"clion.wsl.sleep.timeout")).setPassEnvVarsUsingInterop(false);
        String pathValue = cl.getEnvironment().getOrDefault("PATH", null);
        if (pathValue != null && cl.isPassParentEnvironment()) {
            options.addInitCommand("export PATH=\"" + pathValue + PathSeparator.UNIX + "$PATH\"");
            cl.getEnvironment().remove("PATH");
        }
        GeneralCommandLine generalCommandLine = dist.patchCommandLine(cl, null, options);
        if (generalCommandLine == null) {
            CidrWSLHost.$$$reportNull$$$0(11);
        }
        return generalCommandLine;
    }

    @Override
    @NotNull
    public List<ProcessInfo> getProcessList() throws ExecutionException {
        throw new UnsupportedOperationException("CidrWSLHost is not capable of listing processes");
    }

    public void killProcessTree(@NotNull BaseProcessHandler handler) {
        if (handler == null) {
            CidrWSLHost.$$$reportNull$$$0(12);
        }
        OSProcessUtil.killProcessTree((Process)handler.getProcess());
    }

    @Override
    public int sendSignal(int pid, @NotNull String signalName) {
        if (signalName == null) {
            CidrWSLHost.$$$reportNull$$$0(13);
        }
        return CidrToolsUtil.sendUnixSignal(this, pid, signalName);
    }

    @Override
    @NotNull
    public Path getTempDirectory() {
        Path path = Paths.get(FileUtil.getTempDirectory(), new String[0]);
        if (path == null) {
            CidrWSLHost.$$$reportNull$$$0(14);
        }
        return path;
    }

    @Override
    @NotNull
    public Path createTempDirectory(@NotNull String prefix, @Nullable String suffix) throws IOException {
        if (prefix == null) {
            CidrWSLHost.$$$reportNull$$$0(15);
        }
        Path path = FileUtil.createTempDirectory((String)prefix, (String)suffix).toPath();
        if (path == null) {
            CidrWSLHost.$$$reportNull$$$0(16);
        }
        return path;
    }

    @Override
    @NotNull
    public Path getPath(@NotNull String first, String ... more) {
        if (first == null) {
            CidrWSLHost.$$$reportNull$$$0(17);
        }
        if (more == null) {
            CidrWSLHost.$$$reportNull$$$0(18);
        }
        String[] others = new String[more.length];
        for (int i = 0; i < more.length; ++i) {
            others[i] = this.convertToLocal(more[i]);
        }
        Path path = Paths.get(this.convertToLocal(first), others);
        if (path == null) {
            CidrWSLHost.$$$reportNull$$$0(19);
        }
        return path;
    }

    @Override
    @NotNull
    public File resolvePath(@NotNull Path remoteFile) {
        if (remoteFile == null) {
            CidrWSLHost.$$$reportNull$$$0(20);
        }
        return new File(this.convertToLocal(remoteFile.toString()));
    }

    @Override
    @NotNull
    public File resolvePath(@NotNull File localFile) {
        if (localFile == null) {
            CidrWSLHost.$$$reportNull$$$0(21);
        }
        File file = localFile;
        if (file == null) {
            CidrWSLHost.$$$reportNull$$$0(22);
        }
        return file;
    }

    @Override
    @NotNull
    public @Unmodifiable List<String> resolveAndCache(@NotNull List<String> paths) {
        if (paths == null) {
            CidrWSLHost.$$$reportNull$$$0(23);
        }
        List list = ContainerUtil.map(paths, path -> this.convertToLocal((String)path));
        if (list == null) {
            CidrWSLHost.$$$reportNull$$$0(24);
        }
        return list;
    }

    @Override
    @NotNull
    public @NotNull String @NotNull [] toCanonicalPath(@NotNull List<@NonNls String> paths, boolean resolveSymlink) {
        if (paths == null) {
            CidrWSLHost.$$$reportNull$$$0(25);
        }
        String[] stringArray = (String[])ContainerUtil.map2Array(paths, String.class, p -> this.toCanonicalPathInternal((String)p, resolveSymlink));
        if (stringArray == null) {
            CidrWSLHost.$$$reportNull$$$0(26);
        }
        return stringArray;
    }

    @NotNull
    private String toCanonicalPathInternal(@NotNull String filePath, boolean resolveSymlink) {
        String envFilePath;
        if (filePath == null) {
            CidrWSLHost.$$$reportNull$$$0(27);
        }
        if (!(envFilePath = this.myWSL.toEnvPath(filePath)).startsWith("/mnt/") && resolveSymlink) {
            String resolvedPath = this.myWSL.resolveSymlink(envFilePath);
            String string = this.myWSL.toLocalPath(null, resolvedPath);
            if (string == null) {
                CidrWSLHost.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = FileUtil.toCanonicalPath((String)filePath, (boolean)resolveSymlink);
        if (string == null) {
            CidrWSLHost.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 7, 11, 14, 16, 19, 22, 24, 26, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wsl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/toolchains/wsl/CidrWSLHost";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dist";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signalName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "more";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/toolchains/wsl/CidrWSLHost";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOSType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToLocal";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRemote";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommandLine";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAndCache";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalPath";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalPathInternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertToLocal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertToRemote";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "destroyProcess";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sendSignal";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTempDirectory";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndCache";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPathInternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 7, 11, 14, 16, 19, 22, 24, 26, 28, 29 -> new IllegalStateException(string);
        };
    }
}

