/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.remote;

import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.remote.CidrRemotePathMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BQ\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"J\u000e\u0010$\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0007J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010+\u001a\u00020\nH\u00c6\u0003J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003JQ\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0001J\u0013\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00101\u001a\u00020\nH\u00d6\u0001J\t\u00102\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019\u00a8\u00063"}, d2={"Lcom/jetbrains/cidr/execution/debugger/remote/CidrRemoteDebugParameters;", "", "remoteCommand", "", "symbolFile", "sysroot", "pathMappings", "", "Lcom/jetbrains/cidr/execution/debugger/remote/CidrRemotePathMapping;", "warmupMs", "", "additionalCommands", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;ILjava/util/List;)V", "getRemoteCommand", "()Ljava/lang/String;", "setRemoteCommand", "(Ljava/lang/String;)V", "getSymbolFile", "setSymbolFile", "getSysroot", "setSysroot", "getPathMappings", "()Ljava/util/List;", "setPathMappings", "(Ljava/util/List;)V", "getWarmupMs", "()I", "setWarmupMs", "(I)V", "getAdditionalCommands", "setAdditionalCommands", "expandRemoteCommand", "project", "Lcom/intellij/openapi/project/Project;", "expandSymbolFile", "expandSysroot", "driverPathMapping", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$PathMapping;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nCidrRemoteGDBDebugProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrRemoteGDBDebugProcess.kt\ncom/jetbrains/cidr/execution/debugger/remote/CidrRemoteDebugParameters\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1611#2,9:65\n1863#2:74\n1864#2:76\n1620#2:77\n1#3:75\n*S KotlinDebug\n*F\n+ 1 CidrRemoteGDBDebugProcess.kt\ncom/jetbrains/cidr/execution/debugger/remote/CidrRemoteDebugParameters\n*L\n32#1:65,9\n32#1:74\n32#1:76\n32#1:77\n32#1:75\n*E\n"})
public final class CidrRemoteDebugParameters {
    @NotNull
    private String remoteCommand;
    @NotNull
    private String symbolFile;
    @NotNull
    private String sysroot;
    @NotNull
    private List<CidrRemotePathMapping> pathMappings;
    private int warmupMs;
    @NotNull
    private List<String> additionalCommands;

    @JvmOverloads
    public CidrRemoteDebugParameters(@NotNull String remoteCommand, @NotNull String symbolFile, @NotNull String sysroot, @NotNull List<CidrRemotePathMapping> pathMappings, int warmupMs, @NotNull List<String> additionalCommands) {
        Intrinsics.checkNotNullParameter((Object)remoteCommand, (String)"remoteCommand");
        Intrinsics.checkNotNullParameter((Object)symbolFile, (String)"symbolFile");
        Intrinsics.checkNotNullParameter((Object)sysroot, (String)"sysroot");
        Intrinsics.checkNotNullParameter(pathMappings, (String)"pathMappings");
        Intrinsics.checkNotNullParameter(additionalCommands, (String)"additionalCommands");
        this.remoteCommand = remoteCommand;
        this.symbolFile = symbolFile;
        this.sysroot = sysroot;
        this.pathMappings = pathMappings;
        this.warmupMs = warmupMs;
        this.additionalCommands = additionalCommands;
    }

    public /* synthetic */ CidrRemoteDebugParameters(String string, String string2, String string3, List list, int n, List list2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        if ((n2 & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(string, string2, string3, list, n, list2);
    }

    @NotNull
    public final String getRemoteCommand() {
        return this.remoteCommand;
    }

    public final void setRemoteCommand(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.remoteCommand = string;
    }

    @NotNull
    public final String getSymbolFile() {
        return this.symbolFile;
    }

    public final void setSymbolFile(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.symbolFile = string;
    }

    @NotNull
    public final String getSysroot() {
        return this.sysroot;
    }

    public final void setSysroot(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.sysroot = string;
    }

    @NotNull
    public final List<CidrRemotePathMapping> getPathMappings() {
        return this.pathMappings;
    }

    public final void setPathMappings(@NotNull List<CidrRemotePathMapping> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.pathMappings = list;
    }

    public final int getWarmupMs() {
        return this.warmupMs;
    }

    public final void setWarmupMs(int n) {
        this.warmupMs = n;
    }

    @NotNull
    public final List<String> getAdditionalCommands() {
        return this.additionalCommands;
    }

    public final void setAdditionalCommands(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.additionalCommands = list;
    }

    @NotNull
    public final String expandRemoteCommand(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = ProgramParametersUtil.expandPathAndMacros((String)this.remoteCommand, null, (Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expandPathAndMacros(...)");
        return string;
    }

    @NotNull
    public final String expandSymbolFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = ProgramParametersUtil.expandPathAndMacros((String)this.symbolFile, null, (Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expandPathAndMacros(...)");
        return string;
    }

    @NotNull
    public final String expandSysroot(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = ProgramParametersUtil.expandPathAndMacros((String)this.sysroot, null, (Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expandPathAndMacros(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DebuggerDriver.PathMapping> driverPathMapping() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.pathMappings;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DebuggerDriver.PathMapping it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            CidrRemotePathMapping it = (CidrRemotePathMapping)element$iv$iv;
            boolean bl2 = false;
            if (it.getDriverPathMapping() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String component1() {
        return this.remoteCommand;
    }

    @NotNull
    public final String component2() {
        return this.symbolFile;
    }

    @NotNull
    public final String component3() {
        return this.sysroot;
    }

    @NotNull
    public final List<CidrRemotePathMapping> component4() {
        return this.pathMappings;
    }

    public final int component5() {
        return this.warmupMs;
    }

    @NotNull
    public final List<String> component6() {
        return this.additionalCommands;
    }

    @NotNull
    public final CidrRemoteDebugParameters copy(@NotNull String remoteCommand, @NotNull String symbolFile, @NotNull String sysroot, @NotNull List<CidrRemotePathMapping> pathMappings, int warmupMs, @NotNull List<String> additionalCommands) {
        Intrinsics.checkNotNullParameter((Object)remoteCommand, (String)"remoteCommand");
        Intrinsics.checkNotNullParameter((Object)symbolFile, (String)"symbolFile");
        Intrinsics.checkNotNullParameter((Object)sysroot, (String)"sysroot");
        Intrinsics.checkNotNullParameter(pathMappings, (String)"pathMappings");
        Intrinsics.checkNotNullParameter(additionalCommands, (String)"additionalCommands");
        return new CidrRemoteDebugParameters(remoteCommand, symbolFile, sysroot, pathMappings, warmupMs, additionalCommands);
    }

    public static /* synthetic */ CidrRemoteDebugParameters copy$default(CidrRemoteDebugParameters cidrRemoteDebugParameters, String string, String string2, String string3, List list, int n, List list2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = cidrRemoteDebugParameters.remoteCommand;
        }
        if ((n2 & 2) != 0) {
            string2 = cidrRemoteDebugParameters.symbolFile;
        }
        if ((n2 & 4) != 0) {
            string3 = cidrRemoteDebugParameters.sysroot;
        }
        if ((n2 & 8) != 0) {
            list = cidrRemoteDebugParameters.pathMappings;
        }
        if ((n2 & 0x10) != 0) {
            n = cidrRemoteDebugParameters.warmupMs;
        }
        if ((n2 & 0x20) != 0) {
            list2 = cidrRemoteDebugParameters.additionalCommands;
        }
        return cidrRemoteDebugParameters.copy(string, string2, string3, list, n, list2);
    }

    @NotNull
    public String toString() {
        return "CidrRemoteDebugParameters(remoteCommand=" + this.remoteCommand + ", symbolFile=" + this.symbolFile + ", sysroot=" + this.sysroot + ", pathMappings=" + this.pathMappings + ", warmupMs=" + this.warmupMs + ", additionalCommands=" + this.additionalCommands + ")";
    }

    public int hashCode() {
        int result = this.remoteCommand.hashCode();
        result = result * 31 + this.symbolFile.hashCode();
        result = result * 31 + this.sysroot.hashCode();
        result = result * 31 + ((Object)this.pathMappings).hashCode();
        result = result * 31 + Integer.hashCode(this.warmupMs);
        result = result * 31 + ((Object)this.additionalCommands).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CidrRemoteDebugParameters)) {
            return false;
        }
        CidrRemoteDebugParameters cidrRemoteDebugParameters = (CidrRemoteDebugParameters)other;
        if (!Intrinsics.areEqual((Object)this.remoteCommand, (Object)cidrRemoteDebugParameters.remoteCommand)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.symbolFile, (Object)cidrRemoteDebugParameters.symbolFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sysroot, (Object)cidrRemoteDebugParameters.sysroot)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.pathMappings, cidrRemoteDebugParameters.pathMappings)) {
            return false;
        }
        if (this.warmupMs != cidrRemoteDebugParameters.warmupMs) {
            return false;
        }
        return Intrinsics.areEqual(this.additionalCommands, cidrRemoteDebugParameters.additionalCommands);
    }

    @JvmOverloads
    public CidrRemoteDebugParameters(@NotNull String remoteCommand, @NotNull String symbolFile, @NotNull String sysroot, @NotNull List<CidrRemotePathMapping> pathMappings, int warmupMs) {
        Intrinsics.checkNotNullParameter((Object)remoteCommand, (String)"remoteCommand");
        Intrinsics.checkNotNullParameter((Object)symbolFile, (String)"symbolFile");
        Intrinsics.checkNotNullParameter((Object)sysroot, (String)"sysroot");
        Intrinsics.checkNotNullParameter(pathMappings, (String)"pathMappings");
        this(remoteCommand, symbolFile, sysroot, pathMappings, warmupMs, null, 32, null);
    }

    @JvmOverloads
    public CidrRemoteDebugParameters(@NotNull String remoteCommand, @NotNull String symbolFile, @NotNull String sysroot, @NotNull List<CidrRemotePathMapping> pathMappings) {
        Intrinsics.checkNotNullParameter((Object)remoteCommand, (String)"remoteCommand");
        Intrinsics.checkNotNullParameter((Object)symbolFile, (String)"symbolFile");
        Intrinsics.checkNotNullParameter((Object)sysroot, (String)"sysroot");
        Intrinsics.checkNotNullParameter(pathMappings, (String)"pathMappings");
        this(remoteCommand, symbolFile, sysroot, pathMappings, 0, null, 48, null);
    }

    @JvmOverloads
    public CidrRemoteDebugParameters(@NotNull String remoteCommand, @NotNull String symbolFile, @NotNull String sysroot) {
        Intrinsics.checkNotNullParameter((Object)remoteCommand, (String)"remoteCommand");
        Intrinsics.checkNotNullParameter((Object)symbolFile, (String)"symbolFile");
        Intrinsics.checkNotNullParameter((Object)sysroot, (String)"sysroot");
        this(remoteCommand, symbolFile, sysroot, null, 0, null, 56, null);
    }

    @JvmOverloads
    public CidrRemoteDebugParameters(@NotNull String remoteCommand, @NotNull String symbolFile) {
        Intrinsics.checkNotNullParameter((Object)remoteCommand, (String)"remoteCommand");
        Intrinsics.checkNotNullParameter((Object)symbolFile, (String)"symbolFile");
        this(remoteCommand, symbolFile, null, null, 0, null, 60, null);
    }

    @JvmOverloads
    public CidrRemoteDebugParameters(@NotNull String remoteCommand) {
        Intrinsics.checkNotNullParameter((Object)remoteCommand, (String)"remoteCommand");
        this(remoteCommand, null, null, null, 0, null, 62, null);
    }

    @JvmOverloads
    public CidrRemoteDebugParameters() {
        this(null, null, null, null, 0, null, 63, null);
    }
}

