/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.DocRegion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\"B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u001cH\u0096@\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u001cH\u0014J\b\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/AbstractDocRegion;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "<init>", "(Lcom/intellij/openapi/editor/ex/DocumentEx;Lcom/intellij/openapi/util/TextRange;Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;)V", "getDocument", "()Lcom/intellij/openapi/editor/ex/DocumentEx;", "getDataRegion", "()Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "getRangeMarker", "()Lcom/intellij/openapi/editor/RangeMarker;", "lifetimeJob", "Lkotlinx/coroutines/CompletableJob;", "getLineRangeInDocument", "Lkotlin/ranges/IntRange;", "deleteFromDocument", "", "awaitUnallocation", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "disposeOnDeletion", "toString", "", "Companion", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nDocRegion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocRegion.kt\ncom/jetbrains/cidr/execution/debugger/memory/AbstractDocRegion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,308:1\n1#2:309\n*E\n"})
public abstract class AbstractDocRegion<T>
implements DocRegion<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DocumentEx document;
    @NotNull
    private final CidrMemoryData.DataRegion<T> dataRegion;
    @NotNull
    private final RangeMarker rangeMarker;
    @NotNull
    private final CompletableJob lifetimeJob;

    public AbstractDocRegion(@NotNull DocumentEx document, @NotNull TextRange textRange2, @NotNull CidrMemoryData.DataRegion<T> dataRegion) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)textRange2, (String)"textRange");
        Intrinsics.checkNotNullParameter(dataRegion, (String)"dataRegion");
        this.document = document;
        this.dataRegion = dataRegion;
        RangeMarker rangeMarker = this.document.createRangeMarker(textRange2);
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
        this.rangeMarker = rangeMarker;
        this.lifetimeJob = JobKt.Job$default(null, (int)1, null);
    }

    @NotNull
    public final DocumentEx getDocument() {
        return this.document;
    }

    @Override
    @NotNull
    public final CidrMemoryData.DataRegion<T> getDataRegion() {
        return this.dataRegion;
    }

    @Override
    @NotNull
    public final AddressRange getRange() {
        return this.dataRegion.getRange();
    }

    @Override
    @NotNull
    public final RangeMarker getRangeMarker() {
        return this.rangeMarker;
    }

    @Override
    @NotNull
    public IntRange getLineRangeInDocument() {
        if (!this.rangeMarker.isValid()) {
            boolean $i$a$-check-AbstractDocRegion$getLineRangeInDocument$22 = false;
            String $i$a$-check-AbstractDocRegion$getLineRangeInDocument$22 = "Region is disposed or otherwise removed from the Document";
            throw new IllegalStateException($i$a$-check-AbstractDocRegion$getLineRangeInDocument$22.toString());
        }
        int regionStartLineNumber = this.document.getLineNumber(this.rangeMarker.getStartOffset());
        int regionEndLineNumber = this.document.getLineNumber(this.rangeMarker.getEndOffset());
        return new IntRange(regionStartLineNumber, regionEndLineNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFromDocument() {
        try {
            if (this.rangeMarker.isValid()) {
                this.document.deleteString(this.rangeMarker.getStartOffset(), this.rangeMarker.getEndOffset());
            }
        }
        finally {
            this.disposeOnDeletion();
        }
    }

    @Override
    @Nullable
    public Object awaitUnallocation(@NotNull Continuation<? super Unit> $completion) {
        return AbstractDocRegion.awaitUnallocation$suspendImpl(this, $completion);
    }

    static /* synthetic */ <T> Object awaitUnallocation$suspendImpl(AbstractDocRegion<T> $this, Continuation<? super Unit> $completion) {
        Object object = $this.lifetimeJob.join($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    protected void disposeOnDeletion() {
        if (this.rangeMarker.isValid()) {
            this.rangeMarker.dispose();
        }
        this.lifetimeJob.complete();
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.dataRegion.getRange());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0001\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\nH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/AbstractDocRegion$Companion;", "", "<init>", "()V", "withMarkerGreedy", "R", "Lcom/intellij/openapi/editor/RangeMarker;", "value", "", "block", "Lkotlin/Function0;", "withMarkerGreedy$intellij_cidr_debugger", "(Lcom/intellij/openapi/editor/RangeMarker;ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <R> R withMarkerGreedy$intellij_cidr_debugger(@NotNull RangeMarker $this$withMarkerGreedy, boolean value, @NotNull Function0<? extends R> block) {
            Intrinsics.checkNotNullParameter((Object)$this$withMarkerGreedy, (String)"<this>");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$withMarkerGreedy$intellij_cidr_debugger = false;
            boolean savedToLeft = $this$withMarkerGreedy.isGreedyToLeft();
            boolean savedToRight = $this$withMarkerGreedy.isGreedyToRight();
            $this$withMarkerGreedy.setGreedyToLeft(value);
            $this$withMarkerGreedy.setGreedyToRight(value);
            try {
                Object object = block.invoke();
                return (R)object;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                $this$withMarkerGreedy.setGreedyToLeft(savedToLeft);
                $this$withMarkerGreedy.setGreedyToRight(savedToRight);
                InlineMarker.finallyEnd((int)1);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

