/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ContainerValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererUtils;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NSContainerValueRenderer
extends ContainerValueRenderer {
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("@?\"?\\d+ ((values?)|(elements?)|(key/value pairs?))\"?");

    public NSContainerValueRenderer(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            NSContainerValueRenderer.$$$reportNull$$$0(0);
        }
        super(value);
    }

    @Override
    protected boolean ignoreDescription(@NotNull String description) {
        if (description == null) {
            NSContainerValueRenderer.$$$reportNull$$$0(1);
        }
        return super.ignoreDescription(description) || !DESCRIPTION_PATTERN.matcher(description).matches();
    }

    @Override
    @NotNull
    protected String doComputeFallbackValue(@NotNull EvaluationContext context, @NotNull LLValue var, @NotNull LLValueData data) throws ExecutionException, DebuggerCommandException {
        String type;
        if (context == null) {
            NSContainerValueRenderer.$$$reportNull$$$0(2);
        }
        if (var == null) {
            NSContainerValueRenderer.$$$reportNull$$$0(3);
        }
        if (data == null) {
            NSContainerValueRenderer.$$$reportNull$$$0(4);
        }
        String name = StringUtil.containsIgnoreCase((String)(type = this.getValue().getType()), (String)"Dictionary") ? "key/value pair" : (StringUtil.contains((CharSequence)type, (CharSequence)"NS") ? "element" : "value");
        int count = this.computeChildrenCount(context);
        String string = count + " " + StringUtil.pluralize((String)name, (int)count);
        if (string == null) {
            NSContainerValueRenderer.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public Icon getIcon(boolean hasChildren) {
        return AllIcons.Debugger.Db_array;
    }

    @Override
    @NotNull
    public String getDisplayType() {
        String string = ValueRendererUtils.shortenTemplateType(this.myValue.getVar().getDisplayType());
        if (string == null) {
            NSContainerValueRenderer.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    protected static Couple<LLValue> getDictionaryEntryChildren(@NotNull EvaluationContext context, @NotNull LLValue entry) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            NSContainerValueRenderer.$$$reportNull$$$0(7);
        }
        if (entry == null) {
            NSContainerValueRenderer.$$$reportNull$$$0(8);
        }
        DebuggerDriver.ResultList<LLValue> result = context.getVariableChildren(entry, 0, 2);
        if (result.list.size() == 2 && !result.hasMore) {
            return Couple.of((Object)((Object)((LLValue)((Object)result.list.get(0)))), (Object)((Object)((LLValue)((Object)result.list.get(1)))));
        }
        CidrDebuggerLog.LOG.warn("Unexpected dictionary layout");
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSContainerValueRenderer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSContainerValueRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeFallbackValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "ignoreDescription";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doComputeFallbackValue";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDictionaryEntryChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

