/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.childProcessDebugging;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.ui.EDT;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.CidrDebuggerPluginService;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.ChildProcessDebuggingFileType;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.DebuggingRules;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.DebuggingRulesHandler;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.ParseResult;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import javax.swing.Icon;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u001a\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000b\u001a\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0006\u0010\u0014\u001a\u00020\u0015\u001a\b\u0010\u0016\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0017\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"XmlTagDebuggingRules", "", "XmlTagDefaultRule", "XmlAttributeAttach", "XmlTagRule", "XmlAttributeProcessName", "XmlAttributeCommandLine", "parseChildProcessDebuggingFileFormat", "Lcom/jetbrains/cidr/execution/debugger/childProcessDebugging/ParseResult;", "fileName", "getProject", "Lcom/intellij/openapi/project/Project;", "getIdeaPath", "Ljava/nio/file/Path;", "project", "getRulesFilePath", "isProjectAvailable", "", "childProcDebuggerSchema", "childProcDebuggerSchemaFile", "createExampleFile", "", "generateExampleDebuggingRulesXmlContent", "generateChildProcDebuggerSchema", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nChildProcessDebuggingFileFormatUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChildProcessDebuggingFileFormatUtils.kt\ncom/jetbrains/cidr/execution/debugger/childProcessDebugging/ChildProcessDebuggingFileFormatUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n1#2:327\n*E\n"})
public final class ChildProcessDebuggingFileFormatUtilsKt {
    @NotNull
    private static final String XmlTagDebuggingRules = "DebuggingRules";
    @NotNull
    private static final String XmlTagDefaultRule = "DefaultRule";
    @NotNull
    private static final String XmlAttributeAttach = "attach";
    @NotNull
    private static final String XmlTagRule = "Rule";
    @NotNull
    private static final String XmlAttributeProcessName = "processName";
    @NotNull
    private static final String XmlAttributeCommandLine = "commandLine";
    @NotNull
    private static final String childProcDebuggerSchema = "https://jetbrains.com/schemas/cidr/debugger/child-proc-dbg/2024-10-14";
    @NotNull
    private static final String childProcDebuggerSchemaFile = "child-process-debugging-2024-10-14.xsd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ParseResult parseChildProcessDebuggingFileFormat(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        try {
            File xmlFile = new File(fileName);
            if (!xmlFile.exists()) {
                Object[] objectArray = new Object[]{fileName};
                String string = CidrDebuggerBundle.message("debug.childProcessDebugging.parseXml.FileNotFound", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return new ParseResult.Error(string);
            }
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            String string = xmlFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            DebuggingRulesHandler handler = new DebuggingRulesHandler(string);
            Closeable closeable = new FileInputStream(fileName);
            Throwable throwable = null;
            try {
                FileInputStream inputStream = (FileInputStream)closeable;
                boolean bl = false;
                saxParser.parse(new InputSource(inputStream), (DefaultHandler)handler);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            DebuggingRules debuggingRules = handler.getDebuggingRules();
            String error = handler.getFirstError();
            if (error != null) {
                return new ParseResult.Error(error);
            }
            if (debuggingRules == null) {
                Object[] objectArray = new Object[]{xmlFile};
                String string2 = CidrDebuggerBundle.message("debug.childProcessDebugging.parseXml.NoRules", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                return new ParseResult.Error(string2);
            }
            return new ParseResult.Success(debuggingRules);
        }
        catch (SAXException e) {
            Object[] objectArray = new Object[]{fileName, e.getMessage()};
            String string = CidrDebuggerBundle.message("debug.childProcessDebugging.parseXml.FailedToParse", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new ParseResult.Error(string);
        }
        catch (Exception e) {
            CidrDebuggerLog.LOG.warn("Unexpected error while parsing " + fileName + ": " + e);
            Object[] objectArray = new Object[]{fileName, e.getMessage()};
            String string = CidrDebuggerBundle.message("debug.childProcessDebugging.parseXml.UnexpectedError", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new ParseResult.Error(string);
        }
    }

    private static final Project getProject() {
        Project project;
        Project it = project = ProjectUtil.getActiveProject();
        boolean bl = false;
        return it != null && it.isInitialized() && !it.isDisposed() && it.isOpen() ? project : null;
    }

    private static final Path getIdeaPath(Project project) {
        Path path;
        try {
            path = ProjectKt.getStateStore((Project)project).getDirectoryStorePath();
        }
        catch (IllegalStateException e) {
            CidrDebuggerLog.LOG.warn("ChildProcessDebugging project state store not found: " + e);
            return null;
        }
        Path ideaPath = path;
        if (ideaPath == null) {
            CidrDebuggerLog.LOG.warn("ChildProcessDebugging setting file not found: '.idea' path is null");
            return null;
        }
        return ideaPath;
    }

    @Nullable
    public static final String getRulesFilePath(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path = ChildProcessDebuggingFileFormatUtilsKt.getIdeaPath(project);
        if (path == null) {
            return null;
        }
        Path ideaPath = path;
        Path rulesFile = ideaPath.resolve("." + ChildProcessDebuggingFileType.Companion.getINSTANCE().getDefaultExtension());
        return ((Object)rulesFile).toString();
    }

    public static final boolean isProjectAvailable() {
        Project project = ChildProcessDebuggingFileFormatUtilsKt.getProject();
        return project != null;
    }

    public static final void createExampleFile() {
        EDT.assertIsEdt();
        Project project = ChildProcessDebuggingFileFormatUtilsKt.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        String string = ChildProcessDebuggingFileFormatUtilsKt.getRulesFilePath(project2);
        if (string == null) {
            return;
        }
        String rulesFileString = string;
        File rulesFile = new File(rulesFileString);
        File xsdFile = new File(rulesFile.getParent(), childProcDebuggerSchemaFile);
        CoroutineScope coroutineScope = ((CidrDebuggerPluginService)project2.getService(CidrDebuggerPluginService.class)).getCoroutineScope();
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(rulesFile, xsdFile, project2, null){
            int label;
            final /* synthetic */ File $rulesFile;
            final /* synthetic */ File $xsdFile;
            final /* synthetic */ Project $project;
            {
                this.$rulesFile = $rulesFile;
                this.$xsdFile = $xsdFile;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        if (!this.$rulesFile.exists()) ** GOTO lbl25
                        v0 = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                        v1 = ModalityState.any();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"any(...)");
                        this.label = 1;
                        v2 = BuildersKt.withContext((CoroutineContext)v0.plus(ModalityKt.asContextElement((ModalityState)v1)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(this.$rulesFile, this.$project, null){
                            int label;
                            final /* synthetic */ File $rulesFile;
                            final /* synthetic */ Project $project;
                            {
                                this.$rulesFile = $rulesFile;
                                this.$project = $project;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Object[] objectArray = new Object[]{this.$rulesFile};
                                        String string = CidrDebuggerBundle.message("debug.childProcessDebugging.settingsFile.overwrite.confirmation", objectArray);
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                        String message = string;
                                        String string2 = CidrDebuggerBundle.message("debug.childProcessDebugging.settingsFile.overwrite.title", new Object[0]);
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                                        String title = string2;
                                        return Boxing.boxInt((int)Messages.showYesNoDialog((Project)this.$project, (String)message, (String)title, (Icon)Messages.getQuestionIcon()));
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl17:
                        // 2 sources

                        var3_3 = v2;
                        it = ((Number)var3_3).intValue();
                        $i$a$-takeIf-ChildProcessDebuggingFileFormatUtilsKt$createExampleFile$1$2 = false;
                        v3 = (Integer)(it == 0 != false ? var3_3 : null);
                        if (v3 != null) {
                            v3.intValue();
                        } else {
                            return Unit.INSTANCE;
                        }
lbl25:
                        // 2 sources

                        exampleFileContent = ChildProcessDebuggingFileFormatUtilsKt.access$generateExampleDebuggingRulesXmlContent();
                        schemaFileContent = ChildProcessDebuggingFileFormatUtilsKt.access$generateChildProcDebuggerSchema();
                        this.$rulesFile.getParentFile().mkdirs();
                        FilesKt.writeText$default((File)this.$rulesFile, (String)exampleFileContent, null, (int)2, null);
                        FilesKt.writeText$default((File)this.$xsdFile, (String)schemaFileContent, null, (int)2, null);
                        v4 = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                        v5 = ModalityState.any();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"any(...)");
                        this.label = 2;
                        v6 = BuildersKt.withContext((CoroutineContext)v4.plus(ModalityKt.asContextElement((ModalityState)v5)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$rulesFile, this.$xsdFile, this.$project, null){
                            int label;
                            final /* synthetic */ File $rulesFile;
                            final /* synthetic */ File $xsdFile;
                            final /* synthetic */ Project $project;
                            {
                                this.$rulesFile = $rulesFile;
                                this.$xsdFile = $xsdFile;
                                this.$project = $project;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        VirtualFile rulesVirtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.$rulesFile);
                                        VirtualFile schemaVirtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.$xsdFile);
                                        if (rulesVirtualFile == null || schemaVirtualFile == null) {
                                            CidrDebuggerLog.LOG.warn("ChildProcessDebugging setting file not found: " + this.$rulesFile + ", " + this.$xsdFile);
                                            return Unit.INSTANCE;
                                        }
                                        FileEditorManager.getInstance((Project)this.$project).openFile(rulesVirtualFile, true);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v6 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl42
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl42:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final String generateExampleDebuggingRulesXmlContent() {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<DebuggingRules xmlns=\"https://jetbrains.com/schemas/cidr/debugger/child-proc-dbg/2024-10-14\"\n              xsi:schemaLocation=\"https://jetbrains.com/schemas/cidr/debugger/child-proc-dbg/2024-10-14 child-process-debugging-2024-10-14.xsd\"\n              xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n\n  <!-- Default rule determines whether to attach to all child processes if no specific rules are matched -->\n  <DefaultRule attach=\"false\"/>\n\n  <!-- Specific rules can override the default behavior.\n\n      Attribute 'processName' refers to the executable command, not the exact path to the executable file.\n      This is the command used to start the process. For example, if you use 'cmd', it will execute 'cmd.exe'.\n      Thus, if you specify 'cmd.exe', the rule will not match the created process because the invoked command was 'cmd'.\n\n      Attribute 'commandLine' refers to the arguments that follow the process name.\n\n      Values are case-insensitive. Wildcards (*) and '?' are supported in both 'processName' and 'commandLine' values.\n      Note: Both 'processName' and 'commandLine' are implicitly surrounded by '*' on both sides. This means that an empty string\n      for these attributes will match any value.\n  -->\n\n  <!-- This rule matches commands where the executable's path contains 'part_of_path' and the executable name starts with 'my_app'.\n      It will match:\n          CreateProcess(\"c:/Programs/part_of_path/bin/my_app.exe\", \"app_command -arg1 -arg2\" ...)\n      But it will not match:\n          CreateProcess(\"c:/Programs/Game/bin/my_app.exe\", \"app_command -arg1 -arg2\" ...)\n          CreateProcess(\"my_app\", \"app_command -arg1 -arg2\" ...)\n  -->\n  <Rule processName=\"part_of_path*/my_app*\" commandLine=\"-arg1\" attach=\"true\"/>\n  <Rule processName=\"cm?\" attach=\"true\"/>\n\n</DebuggingRules>";
    }

    private static final String generateChildProcDebuggerSchema() {
        return "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n           targetNamespace=\"https://jetbrains.com/schemas/cidr/debugger/child-proc-dbg/2024-10-14\"\n           xmlns=\"https://jetbrains.com/schemas/cidr/debugger/child-proc-dbg/2024-10-14\"\n           elementFormDefault=\"qualified\">\n  <xs:element name=\"DebuggingRules\">\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element name=\"DefaultRule\" type=\"DefaultRuleType\" minOccurs=\"1\" maxOccurs=\"1\" />\n        <xs:element name=\"Rule\" type=\"RuleDetailType\" maxOccurs=\"unbounded\" minOccurs=\"0\" />\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n\n  <xs:complexType name=\"DefaultRuleType\">\n    <xs:attribute name=\"attach\" type=\"xs:boolean\" use=\"required\" />\n  </xs:complexType>\n\n  <xs:complexType name=\"RuleDetailType\">\n    <xs:attribute name=\"processName\" type=\"xs:string\" use=\"optional\" />\n    <xs:attribute name=\"commandLine\" type=\"xs:string\" use=\"optional\" />\n    <xs:attribute name=\"attach\" type=\"xs:boolean\" use=\"required\" />\n  </xs:complexType>\n</xs:schema>";
    }

    public static final /* synthetic */ String access$generateExampleDebuggingRulesXmlContent() {
        return ChildProcessDebuggingFileFormatUtilsKt.generateExampleDebuggingRulesXmlContent();
    }

    public static final /* synthetic */ String access$generateChildProcDebuggerSchema() {
        return ChildProcessDebuggingFileFormatUtilsKt.generateChildProcDebuggerSchema();
    }
}

