/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb.formatters;

import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.formatters.LLDBNatvisDiagnosticsLevel;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\n"}, d2={"initializeNatvis", "", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "diagnosticsLevel", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/formatters/LLDBNatvisDiagnosticsLevel;", "loadNatvisFiles", "natvisFilesList", "", "", "intellij.cidr.debugger"})
public final class LLDBNatvisSupportKt {
    public static final void initializeNatvis(@NotNull DebuggerDriver driver, @NotNull LLDBNatvisDiagnosticsLevel diagnosticsLevel) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)((Object)diagnosticsLevel), (String)"diagnosticsLevel");
        driver.executeInterpreterCommand(-1L, -1, "command script import renderers.jb_lldb_logging_manager");
        driver.executeInterpreterCommand(-1L, -1, "jb_renderers_set_diagnostics_level " + diagnosticsLevel.getLevel());
        driver.executeInterpreterCommand(-1L, -1, "command script import renderers.jb_lldb_declarative_formatters");
        driver.executeInterpreterCommand(-1L, -1, "jb_renderers_loaders_add natvis renderers.jb_lldb_natvis_loader natvis_loader");
    }

    public static final void loadNatvisFiles(@NotNull DebuggerDriver driver, @NotNull List<String> natvisFilesList) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter(natvisFilesList, (String)"natvisFilesList");
        if (natvisFilesList.isEmpty()) {
            return;
        }
        LLDBDriver lLDBDriver = (LLDBDriver)driver;
        lLDBDriver.getNatvisLoader().loadNatvisFiles(driver, natvisFilesList);
        lLDBDriver.setNatvisEnabled(true);
    }
}

