/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.execution.CidrExecUtil;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.MacOsSymbolSettings;
import com.jetbrains.cidr.execution.debugger.NtSymbolPathEntry;
import com.jetbrains.cidr.execution.debugger.NtSymbolSettings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.lldb.CustomLLDBSupportKt;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBBundle;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBEvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.lldb.formatters.LLDBNatvisLoader;
import com.jetbrains.cidr.execution.debugger.backend.lldb.lang.LLDBLanguage;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisLoader;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBDriverConfiguration
extends DebuggerDriverConfiguration {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([\\d]+\\.[\\d]+(?:\\.[\\d]+)*).*");
    private static final boolean isWindowsPseudoConsoleApiAvailable = Objects.requireNonNullElse(SystemInfo.getWinBuildNumber(), 0L) >= 17763L;
    private static boolean ourIsDebugModeEnabled = false;
    @Nullable
    private CrashDumpStrategy crashDumpStrategy = null;
    @Nullable
    private String myCustomLLDBPath;
    protected final boolean isLegacyHandleInheritanceMode = Registry.is((String)"cidr.debugger.bundled.launchInferiorsWithHandlesInheriting");

    public static void setDebugMode(boolean isEnabled) {
        ourIsDebugModeEnabled = isEnabled;
    }

    public static boolean isDebugModeEnabled() {
        return ourIsDebugModeEnabled;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getDriverName() {
        return "LLDB";
    }

    @NotNull
    public static ArchitectureType getDefaultTargetArchitecture() {
        ArchitectureType architectureType = CpuArch.isArm64() ? ArchitectureType.ARM64 : ArchitectureType.X86_64;
        if (architectureType == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(0);
        }
        return architectureType;
    }

    @Nullable
    public String readVersion() {
        ToolVersion version = this.readToolVersion();
        return version == null ? null : version.toCompactString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ToolVersion readToolVersion() {
        String displayVersion;
        GeneralCommandLine commandLine = null;
        try {
            commandLine = this.createLLDBFrontendCommandLine(LLDBDriverConfiguration.getDefaultTargetArchitecture());
            commandLine.addParameter("--version");
            displayVersion = CidrRunProcessUtil.readOneLineWithProgress(commandLine, 10000);
        }
        catch (ExecutionException e) {
            CidrDebuggerLog.LOG.info("Cannot read LLDB version", (Throwable)e);
            ToolVersion toolVersion = null;
            return toolVersion;
        }
        finally {
            CustomLLDBSupportKt.deleteTempFiles(commandLine);
        }
        if (displayVersion == null) {
            return null;
        }
        return LLDBDriverConfiguration.parseVersion(displayVersion);
    }

    @NotNull
    public static ToolVersion parseVersion(@NotNull String displayVersion) {
        if (displayVersion == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(1);
        }
        ToolVersion toolVersion = ToolVersion.parse(displayVersion, VERSION_PATTERN);
        if (toolVersion == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(2);
        }
        return toolVersion;
    }

    public boolean supportsTerminalEmulation() {
        return !SystemInfo.isWindows || isWindowsPseudoConsoleApiAvailable;
    }

    @Override
    @NotNull
    public LLDBDriver createDriver(@NotNull DebuggerDriver.Handler handler, @NotNull ArchitectureType architectureType) throws ExecutionException {
        if (handler == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(3);
        }
        if (architectureType == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(4);
        }
        return new LLDBDriver(handler, this, architectureType);
    }

    @NotNull
    protected static String getPathForArch(@NotNull ArchitectureType architectureType, @NotNull String path) {
        String archDirName;
        if (architectureType == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(5);
        }
        if (path == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(6);
        }
        if ((archDirName = LLDBDriverConfiguration.getArchDirName(architectureType)) == null) {
            archDirName = LLDBDriverConfiguration.getArchDirName(ArchitectureType.forVmCpuArch(CpuArch.CURRENT));
        }
        if (archDirName == null) {
            throw new UnsupportedOperationException("Unable to locate bundled LLDB for architecture " + architectureType);
        }
        String string = archDirName + "/" + path;
        if (string == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static String getArchDirName(@NotNull ArchitectureType architectureType) {
        if (architectureType == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(8);
        }
        return switch (architectureType) {
            case ArchitectureType.I386 -> "x86";
            case ArchitectureType.X86_64 -> "x64";
            case ArchitectureType.ARM64 -> "aarch64";
            default -> null;
        };
    }

    @NotNull
    protected File getLLDBFrameworkFile(@NotNull ArchitectureType architectureType) {
        if (architectureType == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(9);
        }
        File file = this.getBundledLLDBFrameworkFile(architectureType);
        if (file == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(10);
        }
        return file;
    }

    @NotNull
    protected File getLLDBFrontendFile(@NotNull ArchitectureType architectureType) {
        if (architectureType == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(11);
        }
        File file = this.getLLDBBinFile(LLDBDriverConfiguration.getPathForArch(architectureType, SystemInfo.isMac ? "LLDBFrontend" : (SystemInfo.isWindows ? "bin/LLDBFrontend.exe" : "bin/LLDBFrontend")));
        if (file == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(12);
        }
        return file;
    }

    @NotNull
    protected File getLLDBBinFile(@NotNull String relativePath) {
        if (relativePath == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(13);
        }
        File file = CidrDebuggerPathManager.getLLDBBinFile(relativePath, null);
        if (file == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(14);
        }
        return file;
    }

    @NotNull
    protected File getBundledLLDBFrameworkFile(ArchitectureType architectureType) {
        File file = CidrDebuggerPathManager.getLLDBBinFile(LLDBDriverConfiguration.getPathForArch(architectureType, SystemInfo.isMac ? "LLDB.framework" : (SystemInfo.isWindows ? "bin/liblldb.dll" : "lib/liblldb.so")), LLDBDriverConfiguration.getPathForArch(architectureType, SystemInfo.isMac ? "LLDB.framework/Resources" : "bin"));
        if (file == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(15);
        }
        return file;
    }

    public static boolean hasBundledLLDB() {
        return new LLDBDriverConfiguration().getBundledLLDBFrameworkFile(LLDBDriverConfiguration.getDefaultTargetArchitecture()).exists();
    }

    @Override
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver, @NotNull ArchitectureType architectureType) throws ExecutionException {
        if (driver == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(16);
        }
        if (architectureType == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(17);
        }
        GeneralCommandLine result = this.createLLDBFrontendCommandLine(architectureType);
        result.addParameter(String.valueOf(((LLDBDriver)driver).getPort()));
        this.configureDriverCommandLine(result);
        GeneralCommandLine generalCommandLine = result;
        if (generalCommandLine == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(18);
        }
        return generalCommandLine;
    }

    @NotNull
    private GeneralCommandLine createLLDBFrontendCommandLine(@NotNull ArchitectureType architectureType) throws ExecutionException {
        MacOsSymbolSettings macSettings;
        boolean loadDSymNearBinaries;
        File lldbFrameworkFile;
        if (architectureType == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(19);
        }
        if (!(lldbFrameworkFile = this.getLLDBFrameworkFile(architectureType)).exists()) {
            throw new ExecutionException(LLDBBundle.message("error.lldb.library.not.found", lldbFrameworkFile));
        }
        File frontendExecutable = this.getLLDBFrontendFile(architectureType);
        if (!frontendExecutable.exists()) {
            throw new ExecutionException(LLDBBundle.message("error.lldbfrontend.not.found", frontendExecutable.getAbsolutePath()));
        }
        GeneralCommandLine result = new GeneralCommandLine().withExePath(frontendExecutable.getAbsolutePath());
        Map env = result.getEnvironment();
        String customLldbPath = this.myCustomLLDBPath;
        if (SystemInfo.isLinux) {
            if (customLldbPath != null) {
                CustomLLDBSupportKt.initCustomLinuxLldb(result, customLldbPath);
            } else {
                env.put("LD_LIBRARY_PATH", lldbFrameworkFile.getParent());
            }
        } else if (SystemInfo.isWindows) {
            if (customLldbPath != null) {
                throw new ExecutionException(LLDBBundle.message("error.customLldb.notSupportedOnWindows", new Object[0]));
            }
            File lldbFrameworkDir = lldbFrameworkFile.getParentFile();
            CidrExecUtil.appendSearchPath(env, "PATH", lldbFrameworkDir.getPath());
            File lldbFrontendDir = frontendExecutable.getParentFile();
            if (!FileUtil.filesEqual((File)lldbFrontendDir, (File)lldbFrameworkDir)) {
                CidrExecUtil.appendSearchPath(env, "PATH", lldbFrontendDir.getPath());
            }
            String parentPATH = (String)result.getParentEnvironment().get("PATH");
            CidrExecUtil.appendSearchPath(env, "PATH", parentPATH);
            if (this.isLegacyHandleInheritanceMode) {
                env.put("JB_LLDB_LAUNCH_INFERIORS_WITH_HANDLES_INHERITING", "1");
            }
        } else if (SystemInfo.isMac) {
            if (customLldbPath != null) {
                CustomLLDBSupportKt.initCustomMacLldb(result, customLldbPath);
            } else {
                env.put("DYLD_FRAMEWORK_PATH", lldbFrameworkFile.getParent());
            }
            env.put("NSUnbufferedIO", "YES");
        }
        if (SystemInfo.isUnix && this.useSTLRenderers()) {
            result.putUserData(LLDBDriver.ENABLE_STL_RENDERERS, (Object)true);
            env.put("PYTHONPATH", CidrDebuggerPathManager.getBundledLLDBSTLPrettyPrinters().getAbsolutePath());
        }
        if (this.disableASLR()) {
            env.put("LLDB_LAUNCH_FLAG_DISABLE_ASLR", "1");
        }
        if (this.useRustTypeSystem()) {
            env.put("LLDB_USE_RUST_TYPE_SYSTEM", "1");
        }
        if (SystemInfo.isWindows) {
            CidrDebuggerSettings settings = CidrDebuggerSettings.getInstance();
            NtSymbolSettings srvSettings = settings.getNtSymbolSettings();
            String envNtSymbolPath = srvSettings.getUseNtSymbolServers() ? LLDBDriverConfiguration.buildNtSymbolPath(srvSettings) : "";
            env.put("_NT_SYMBOL_PATH", envNtSymbolPath);
        }
        if (SystemInfo.isMac && (loadDSymNearBinaries = (macSettings = CidrDebuggerSettings.getInstance().getMacOSSymbolSettings()).getLoadDSymNearBinaries())) {
            env.put("JB_LLDB_LOOK_FOR_DSYM", "1");
        }
        if (this.crashDumpStrategy != null) {
            String dumpType = this.crashDumpStrategy.isFullDump ? "FULL" : "NORMAL";
            env.put("JB_LLDB_CRASH_DUMP_PATH", this.crashDumpStrategy.pathForDump.toString());
            env.put("JB_LLDB_CRASH_DUMP_TYPE", dumpType);
        }
        LLDBDriverConfiguration.setupCommonParameters(result);
        GeneralCommandLine generalCommandLine = result;
        if (generalCommandLine == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(20);
        }
        return generalCommandLine;
    }

    protected void configureDriverCommandLine(@NotNull GeneralCommandLine result) {
        if (result == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(21);
        }
        if (LLDBDriverConfiguration.isDebugModeEnabled()) {
            result.addParameter("--debug");
        }
    }

    @ApiStatus.Internal
    @NotNull
    public DebuggerDriverConfiguration setupCrashDumpStrategy() {
        try {
            HostMachine machine = this.getHostMachine();
            if (machine.getOS() == OS.Windows && !machine.isRemote() && !machine.isWsl()) {
                RegistryValue registryValue = Registry.get((String)"cidr.debugger.lldb.generateCrashDumpOnCrash");
                boolean isFullDump = registryValue.isOptionEnabled("Full");
                boolean isNormalDump = registryValue.isOptionEnabled("Normal");
                if (isFullDump || isNormalDump) {
                    File dumpFile = FileUtil.generateRandomTemporaryPath((String)"JB_LldbDump_", (String)".dmp");
                    Files.createDirectories(dumpFile.getParentFile().toPath(), new FileAttribute[0]);
                    this.crashDumpStrategy = new CrashDumpStrategy(dumpFile.toPath(), isFullDump);
                }
            }
        }
        catch (Throwable e) {
            CidrDebuggerLog.LOG.error("Failed to setup crashdump strategy", e);
        }
        LLDBDriverConfiguration lLDBDriverConfiguration = this;
        if (lLDBDriverConfiguration == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(22);
        }
        return lLDBDriverConfiguration;
    }

    @NotNull
    private static String buildNtSymbolPath(@NotNull NtSymbolSettings srvSettings) {
        String url;
        if (srvSettings == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(23);
        }
        StringBuilder result = new StringBuilder();
        String cachePath = srvSettings.getNtSymbolCache().trim();
        if (cachePath.isEmpty()) {
            cachePath = NtSymbolSettings.getDefaultSymbolCachePath();
        }
        for (NtSymbolPathEntry entry : srvSettings.getNtSymbolServers()) {
            if (!entry.isEnabled() || (url = entry.getUrl().trim()).isEmpty()) continue;
            result.append("srv*");
            result.append(cachePath);
            result.append("*");
            result.append(url);
            result.append(";");
        }
        result.append("cache*");
        result.append(cachePath);
        result.append(";");
        for (NtSymbolPathEntry entry : srvSettings.getNtSymbolPaths()) {
            if (!entry.isEnabled() || (url = entry.getUrl().trim()).isEmpty()) continue;
            result.append(url);
            result.append(";");
        }
        String string = result.toString();
        if (string == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Override
    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull LLThread thread, @NotNull LLFrame frame, @NotNull UserDataHolderEx cacheHolder) {
        if (driver == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(25);
        }
        if (thread == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(26);
        }
        if (frame == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(27);
        }
        if (cacheHolder == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(28);
        }
        return new LLDBEvaluationContext(driver, expirable, thread, frame, cacheHolder);
    }

    @Override
    public boolean supportsArrayEvaluation() {
        return true;
    }

    @Override
    public boolean isCodeFragmentEvaluationSupported() {
        return true;
    }

    public boolean isStaticVarsLoadingEnabled() {
        return Registry.is((String)"cidr.debugger.lldb.statics");
    }

    public boolean disableASLR() {
        return false;
    }

    public boolean useRustTypeSystem() {
        return false;
    }

    public boolean useSTLRenderers() {
        return true;
    }

    @Contract(value="null -> null")
    public String convertToProjectModelPath(@Nullable String absolutePath) {
        return absolutePath;
    }

    @Override
    @NotNull
    public Language getConsoleLanguage() {
        LLDBLanguage lLDBLanguage = LLDBLanguage.INSTANCE;
        if (lLDBLanguage == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(29);
        }
        return lLDBLanguage;
    }

    @NotNull
    public NatvisLoader getNatvisLoader() {
        LLDBNatvisLoader lLDBNatvisLoader = LLDBNatvisLoader.INSTANCE;
        if (lLDBNatvisLoader == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(30);
        }
        return lLDBNatvisLoader;
    }

    @ApiStatus.Experimental
    public boolean shouldExtractRichStrings() {
        return Registry.is((String)"cidr.debugger.lldb.extractRichStrings");
    }

    @ApiStatus.Experimental
    public void setCustomLLDBPath(@Nullable String customLLDBPath) {
        this.myCustomLLDBPath = customLLDBPath;
    }

    @Override
    @NotNull
    public String getDesignator() {
        if (this.myCustomLLDBPath != null) {
            String string = ((Object)((Object)this)).getClass().getName() + ":" + this.myCustomLLDBPath;
            if (string == null) {
                LLDBDriverConfiguration.$$$reportNull$$$0(31);
            }
            return string;
        }
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseProcessHandler<?> createDebugProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(33);
        }
        BaseProcessHandler<?> result = super.createDebugProcessHandler(commandLine);
        CustomLLDBSupportKt.registerTempFilesCleanupOnExit(commandLine, result);
        BaseProcessHandler<?> baseProcessHandler = result;
        if (baseProcessHandler == null) {
            LLDBDriverConfiguration.$$$reportNull$$$0(34);
        }
        return baseProcessHandler;
    }

    @Override
    @Nullable
    public Path getCrashDumpPath() {
        try {
            boolean hasGeneratedCrashDump;
            boolean bl = hasGeneratedCrashDump = this.crashDumpStrategy != null && Files.exists(this.crashDumpStrategy.pathForDump, new LinkOption[0]);
            if (hasGeneratedCrashDump) {
                return this.crashDumpStrategy.pathForDump;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 8, 9, 11, 13, 16, 17, 19, 21, 23, 25, 26, 27, 28, 33 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriverConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayVersion";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "architectureType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srvSettings";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheHolder";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTargetArchitecture";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriverConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersion";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathForArch";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLDBFrameworkFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLDBFrontendFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLDBBinFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledLLDBFrameworkFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createDriverCommandLine";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createLLDBFrontendCommandLine";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "setupCrashDumpStrategy";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNtSymbolPath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleLanguage";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getNatvisLoader";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignator";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDriver";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPathForArch";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getArchDirName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLLDBFrameworkFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLLDBFrontendFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLLDBBinFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDriverCommandLine";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createLLDBFrontendCommandLine";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "configureDriverCommandLine";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "buildNtSymbolPath";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluationContext";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcessHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 8, 9, 11, 13, 16, 17, 19, 21, 23, 25, 26, 27, 28, 33 -> new IllegalArgumentException(string);
        };
    }

    private record CrashDumpStrategy(@NotNull Path pathForDump, boolean isFullDump) {
        @NotNull
        private final Path pathForDump;

        private CrashDumpStrategy(@NotNull Path pathForDump, boolean isFullDump) {
            if (pathForDump == null) {
                CrashDumpStrategy.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public Path pathForDump() {
            Path path = this.pathForDump;
            if (path == null) {
                CrashDumpStrategy.$$$reportNull$$$0(1);
            }
            return path;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathForDump";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriverConfiguration$CrashDumpStrategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriverConfiguration$CrashDumpStrategy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "pathForDump";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

