/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtilKt;
import com.jetbrains.cidr.execution.debugger.CidrExecutionStack;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLineBreakpointType;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ<\u0010\u0010\u001a\u00020\u00072\u000b\u0010\u0011\u001a\u00070\t\u00a2\u0006\u0002\b\u00122\u000b\u0010\u0013\u001a\u00070\t\u00a2\u0006\u0002\b\u00122\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0004J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0004J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0004J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tH\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020\t0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrSourceFileLocator;", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "forceFileMapping", "", "path", "", "hash", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerSourceFileHash;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "askUser", "", "askUserAndDoForceFileMapping", "title", "Lorg/jetbrains/annotations/Nls;", "message", "doForceFileMapping", "locate", "locateFileByPath", "locateFileByPathMappings", "locateFileByName", "addPathMapping", "from", "to", "isHashMatched", "getDigest", "Ljava/security/MessageDigest;", "type", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerSourceFileHash$Type;", "isMappingApplicable", "mapping", "getCommonValidPathSuffixLength", "", "hashMappingList", "", "Lcom/intellij/openapi/util/Pair;", "forcedMappingList", "pathMappingList", "mutex", "Ljava/lang/Object;", "notFoundFilesSet", "Ljava/util/HashSet;", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nCidrSourceFileLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrSourceFileLocator.kt\ncom/jetbrains/cidr/execution/debugger/CidrSourceFileLocator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,308:1\n13402#2,2:309\n*S KotlinDebug\n*F\n+ 1 CidrSourceFileLocator.kt\ncom/jetbrains/cidr/execution/debugger/CidrSourceFileLocator\n*L\n105#1:309,2\n*E\n"})
public class CidrSourceFileLocator {
    @NotNull
    private final CidrDebugProcess process;
    @NotNull
    private final List<Pair<DebuggerSourceFileHash, String>> hashMappingList;
    @NotNull
    private final List<Pair<String, String>> forcedMappingList;
    @NotNull
    private final List<Pair<String, String>> pathMappingList;
    @NotNull
    private final Object mutex;
    @NotNull
    private final HashSet<String> notFoundFilesSet;

    public CidrSourceFileLocator(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        this.process = process;
        this.hashMappingList = new ArrayList();
        this.forcedMappingList = new ArrayList();
        this.pathMappingList = new ArrayList();
        this.mutex = new Object();
        this.notFoundFilesSet = new HashSet();
    }

    public final void forceFileMapping(@NotNull String path, @Nullable DebuggerSourceFileHash hash, @NotNull VirtualFile file, boolean askUser) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (askUser) {
            if (hash != null) {
                if (!this.isHashMatched(file, hash)) {
                    String string = CidrDebuggerBundle.message("debug.force.file.mapping.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String string2 = CidrDebuggerBundle.message("debug.force.file.mapping.invalid.hash", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    this.askUserAndDoForceFileMapping(string, string2, path, hash, file);
                    return;
                }
            } else if (!StringsKt.equals((String)PathUtil.getFileName((String)path), (String)file.getName(), (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
                String string = CidrDebuggerBundle.message("debug.force.file.mapping.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                Object[] objectArray = new Object[]{file.getName(), PathUtil.getFileName((String)path)};
                String string3 = CidrDebuggerBundle.message("debug.force.file.mapping.invalid.name", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                this.askUserAndDoForceFileMapping(string, string3, path, null, file);
                return;
            }
        }
        this.doForceFileMapping(path, hash, file);
    }

    private final void askUserAndDoForceFileMapping(String title, String message, String path, DebuggerSourceFileHash hash, VirtualFile file) {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> CidrSourceFileLocator.askUserAndDoForceFileMapping$lambda$0(title, message, this, path, hash, file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doForceFileMapping(String path, DebuggerSourceFileHash hash, VirtualFile file) {
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String toPath = string;
        Ref.IntRef index = new Ref.IntRef();
        Iterator iterator = this.mutex;
        synchronized (iterator) {
            boolean bl = false;
            if (hash != null) {
                index.element = 0;
                Pair pair = Pair.create((Object)hash, (Object)toPath);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                pair = pair;
                if (this.hashMappingList.contains(pair)) {
                    return;
                }
                this.hashMappingList.add(0, (Pair<DebuggerSourceFileHash, String>)pair);
            } else {
                index.element = this.hashMappingList.size();
                Pair pair = Pair.create((Object)path, (Object)toPath);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                pair = pair;
                if (this.forcedMappingList.contains(pair)) {
                    return;
                }
                this.forcedMappingList.add(0, (Pair<String, String>)pair);
            }
            Unit $i$a$-synchronized-CidrSourceFileLocator$doForceFileMapping$2 = Unit.INSTANCE;
        }
        this.process.postCommand(arg_0 -> CidrSourceFileLocator.doForceFileMapping$lambda$2(index, path, hash, toPath, arg_0));
        this.addPathMapping(path, toPath);
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)this.process.getProject()).getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointManager, (String)"getBreakpointManager(...)");
        XBreakpointManager breakpointManager = xBreakpointManager;
        for (XLineBreakpoint bp : breakpointManager.getBreakpoints(CidrLineBreakpointType.class)) {
            if (!Intrinsics.areEqual((Object)VfsUtilCore.urlToPath((String)bp.getFileUrl()), (Object)toPath)) continue;
            XBreakpointBase xBreakpointBase = bp instanceof XBreakpointBase ? (XBreakpointBase)bp : null;
            if (xBreakpointBase == null) continue;
            xBreakpointBase.fireBreakpointChanged();
        }
        XExecutionStack[] xExecutionStackArray = this.process.getSession();
        if (xExecutionStackArray != null && (xExecutionStackArray = CidrDebuggerUtilKt.getCidrSuspendContext((XDebugSession)xExecutionStackArray)) != null && (xExecutionStackArray = xExecutionStackArray.getExecutionStacks()) != null) {
            XExecutionStack[] $this$forEach$iv = xExecutionStackArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                XExecutionStack element$iv;
                XExecutionStack stack = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!(stack instanceof CidrExecutionStack)) continue;
                ((CidrExecutionStack)stack).renewTopFrame();
            }
        }
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> CidrSourceFileLocator.doForceFileMapping$lambda$4(this));
    }

    @Nullable
    public VirtualFile locate(@NotNull String path, @Nullable DebuggerSourceFileHash hash) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        VirtualFile file = this.locateFileByPath(path, hash);
        if (file != null) {
            return file;
        }
        file = this.locateFileByPathMappings(path, hash);
        if (file != null) {
            return file;
        }
        file = this.locateFileByName(path, hash);
        if (file != null) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            this.addPathMapping(path, string);
            return file;
        }
        return null;
    }

    @Nullable
    protected final VirtualFile locateFileByPath(@NotNull String path, @Nullable DebuggerSourceFileHash hash) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        return file != null && (hash == null || this.isHashMatched(file, hash)) ? file : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected final VirtualFile locateFileByPathMappings(@NotNull String path, @Nullable DebuggerSourceFileHash hash) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = this.mutex;
        synchronized (object) {
            VirtualFile virtualFile;
            VirtualFile file;
            boolean bl = false;
            if (hash != null) {
                for (Pair pair : this.hashMappingList) {
                    if (!Intrinsics.areEqual((Object)hash, (Object)pair.first)) continue;
                    VirtualFile virtualFile2 = file = LocalFileSystem.getInstance().findFileByPath((String)pair.second);
                    if (virtualFile2 == null) continue;
                    return virtualFile2;
                }
            }
            for (Pair pair : this.forcedMappingList) {
                if (!Intrinsics.areEqual((Object)path, (Object)pair.first)) continue;
                VirtualFile virtualFile3 = file = LocalFileSystem.getInstance().findFileByPath((String)pair.second);
                if (virtualFile3 == null) continue;
                return virtualFile3;
            }
            Iterator<Object> iterator = this.pathMappingList.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return null;
                }
                Pair pair = (Pair)iterator.next();
                Object object2 = pair.first;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first");
                if (!this.isMappingApplicable(path, (String)object2)) continue;
                Object object3 = pair.second;
                String string = path.substring(((String)pair.first).length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                virtualFile = file = this.locateFileByPath(object3 + string, hash);
                if (virtualFile != null) break;
            }
            return virtualFile;
        }
    }

    @Nullable
    protected VirtualFile locateFileByName(@NotNull String path, @Nullable DebuggerSourceFileHash hash) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = PathUtil.getFileName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String fileName = string;
        if (this.notFoundFilesSet.contains(fileName)) {
            return null;
        }
        Ref bestFile = new Ref();
        int[] nArray = new int[]{-1};
        int[] bestSuffixLen = nArray;
        try {
            FilenameIndex.processFilesByName((String)fileName, (boolean)SystemInfo.isFileSystemCaseSensitive, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.process.getProject()), arg_0 -> CidrSourceFileLocator.locateFileByName$lambda$7(arg_0 -> CidrSourceFileLocator.locateFileByName$lambda$6(hash, this, path, bestSuffixLen, bestFile, arg_0), arg_0));
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        VirtualFile file = (VirtualFile)bestFile.get();
        if (file == null) {
            this.notFoundFilesSet.add(fileName);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addPathMapping(@NotNull String from, @NotNull String to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        int suffixLen = this.getCommonValidPathSuffixLength(from, to);
        int fromSubstrLen = from.length() - suffixLen;
        Ref.IntRef index = new Ref.IntRef();
        Ref.ObjectRef fromCut = new Ref.ObjectRef();
        Ref.ObjectRef toCut = new Ref.ObjectRef();
        Object object = this.mutex;
        synchronized (object) {
            int i;
            boolean bl = false;
            for (i = 0; i < this.pathMappingList.size() && ((String)this.pathMappingList.get((int)i).first).length() > fromSubstrLen; ++i) {
            }
            String string = from.substring(0, fromSubstrLen);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            fromCut.element = string;
            String string2 = to.substring(0, to.length() - suffixLen);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            toCut.element = string2;
            if (StringsKt.equals((String)((String)fromCut.element), (String)((String)toCut.element), (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
                return;
            }
            Pair pair = Pair.create((Object)fromCut.element, (Object)toCut.element);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
            Pair pair2 = pair;
            if (this.pathMappingList.contains(pair2) || this.forcedMappingList.contains(pair2)) {
                return;
            }
            this.pathMappingList.add(i, (Pair<String, String>)pair2);
            index.element = this.hashMappingList.size() + this.forcedMappingList.size() + i;
            Unit unit = Unit.INSTANCE;
        }
        this.process.postCommand(arg_0 -> CidrSourceFileLocator.addPathMapping$lambda$9(index, fromCut, toCut, arg_0));
    }

    private final boolean isHashMatched(VirtualFile file, DebuggerSourceFileHash hash) {
        ProgressManager.checkCanceled();
        DebuggerSourceFileHash.Type type = hash.getType();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)type), (String)"getType(...)");
        MessageDigest digest = this.getDigest(type);
        try {
            digest.update(file.contentsToByteArray());
        }
        catch (IOException ignored) {
            return false;
        }
        return StringsKt.equals((String)DigestUtil.digestToHash((MessageDigest)digest), (String)hash.getHash(), (boolean)true);
    }

    private final MessageDigest getDigest(DebuggerSourceFileHash.Type type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> DigestUtil.md5();
            case 2 -> DigestUtil.sha1();
            case 3 -> DigestUtil.sha256();
            default -> throw new UnsupportedOperationException();
        };
    }

    private final boolean isMappingApplicable(String path, String mapping) {
        if (!StringsKt.startsWith$default((String)path, (String)mapping, (boolean)false, (int)2, null)) {
            return false;
        }
        if (mapping.length() == path.length()) {
            return true;
        }
        if (StringsKt.endsWith$default((String)mapping, (String)"\\", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)mapping, (String)"/", (boolean)false, (int)2, null)) {
            return true;
        }
        String string = path.substring(mapping.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String suffix = string;
        return StringsKt.startsWith$default((String)suffix, (String)"\\", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)suffix, (String)"/", (boolean)false, (int)2, null);
    }

    private final int getCommonValidPathSuffixLength(String from, String to) {
        int suffixLen;
        String fromNormalized = null;
        String toNormalized = null;
        if (!SystemInfo.isFileSystemCaseSensitive) {
            String string = from;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            fromNormalized = string2;
            string = to;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string3 = string.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            toNormalized = string3;
        } else {
            fromNormalized = from;
            toNormalized = to;
        }
        block3: for (suffixLen = StringUtil.commonSuffixLength((CharSequence)fromNormalized, (CharSequence)toNormalized); suffixLen > 0; --suffixLen) {
            char cutChar = fromNormalized.charAt(fromNormalized.length() - suffixLen);
            switch (cutChar) {
                case '/': 
                case '\\': {
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        return suffixLen;
    }

    private static final void askUserAndDoForceFileMapping$lambda$0(String $title, String $message, CidrSourceFileLocator this$0, String $path, DebuggerSourceFileHash $hash, VirtualFile $file) {
        MessageDialogBuilder.YesNo yesNo = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo($title, $message).icon(Messages.getWarningIcon());
        if (yesNo.ask(this$0.process.getProject())) {
            this$0.doForceFileMapping($path, $hash, $file);
        }
    }

    private static final void doForceFileMapping$lambda$2(Ref.IntRef $index, String $path, DebuggerSourceFileHash $hash, String $toPath, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        driver.addForcedFileMapping($index.element, $path, $hash, $toPath);
    }

    private static final void doForceFileMapping$lambda$4(CidrSourceFileLocator this$0) {
        this$0.process.getSession().rebuildViews();
        this$0.process.getSession().showExecutionPoint();
    }

    private static final boolean locateFileByName$lambda$6(DebuggerSourceFileHash $hash, CidrSourceFileLocator this$0, String $path, int[] $bestSuffixLen, Ref $bestFile, VirtualFile currFile) {
        if (!currFile.isValid()) {
            return true;
        }
        if (currFile.isDirectory()) {
            return true;
        }
        if ($hash == null) {
            String string = currFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            int suffixLen = this$0.getCommonValidPathSuffixLength($path, string);
            if (suffixLen > $bestSuffixLen[0]) {
                $bestFile.set((Object)currFile);
                $bestSuffixLen[0] = suffixLen;
                return true;
            }
        } else {
            Intrinsics.checkNotNull((Object)currFile);
            if (this$0.isHashMatched(currFile, $hash)) {
                $bestFile.set((Object)currFile);
                return false;
            }
        }
        return true;
    }

    private static final boolean locateFileByName$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void addPathMapping$lambda$9(Ref.IntRef $index, Ref.ObjectRef $fromCut, Ref.ObjectRef $toCut, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        driver.addPathMapping($index.element, (String)$fromCut.element, (String)$toCut.element);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DebuggerSourceFileHash.Type.values().length];
            try {
                nArray[DebuggerSourceFileHash.Type.MD5.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DebuggerSourceFileHash.Type.SHA1.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DebuggerSourceFileHash.Type.SHA256.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

