/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class CidrLogService {
    @NotNull
    public static final Logger LOG = Logger.getInstance((String)CidrLogService.class.getPackage().getName());
    @NotNull
    private final Cache<StackTail, Object> myStackCache = CacheBuilder.newBuilder().maximumSize(1024L).expireAfterWrite(60L, TimeUnit.MINUTES).build();

    public static void logOnce(@NotNull Level level, @NonNls @NotNull String message) {
        if (level == null) {
            CidrLogService.$$$reportNull$$$0(0);
        }
        if (message == null) {
            CidrLogService.$$$reportNull$$$0(1);
        }
        CidrLogService.logOnce(LOG, level, message);
    }

    public static void logOnce(@NotNull Logger logger, @NotNull Level level, @NonNls @NotNull String message) {
        if (logger == null) {
            CidrLogService.$$$reportNull$$$0(2);
        }
        if (level == null) {
            CidrLogService.$$$reportNull$$$0(3);
        }
        if (message == null) {
            CidrLogService.$$$reportNull$$$0(4);
        }
        CidrLogService.getInstance().logMessageOnce(logger, level, message);
    }

    public static void logOnce(@NotNull Level level, @NonNls @Nullable String message, @NotNull Throwable ex) {
        if (level == null) {
            CidrLogService.$$$reportNull$$$0(5);
        }
        if (ex == null) {
            CidrLogService.$$$reportNull$$$0(6);
        }
        CidrLogService.logOnce(LOG, level, message, ex);
    }

    public static void logOnce(@NotNull Logger logger, @NotNull Level level, @NonNls @Nullable String message, @NotNull Throwable ex) {
        if (logger == null) {
            CidrLogService.$$$reportNull$$$0(7);
        }
        if (level == null) {
            CidrLogService.$$$reportNull$$$0(8);
        }
        if (ex == null) {
            CidrLogService.$$$reportNull$$$0(9);
        }
        CidrLogService.getInstance().logExceptionOnce(logger, level, message, ex);
    }

    @NotNull
    private static CidrLogService getInstance() {
        CidrLogService cidrLogService = (CidrLogService)ApplicationManager.getApplication().getService(CidrLogService.class);
        if (cidrLogService == null) {
            CidrLogService.$$$reportNull$$$0(10);
        }
        return cidrLogService;
    }

    private void logMessageOnce(@NotNull Logger logger, @NotNull Level level, @NonNls @NotNull String message) {
        StackTail stackTail;
        Object present;
        if (logger == null) {
            CidrLogService.$$$reportNull$$$0(11);
        }
        if (level == null) {
            CidrLogService.$$$reportNull$$$0(12);
        }
        if (message == null) {
            CidrLogService.$$$reportNull$$$0(13);
        }
        if ((present = this.myStackCache.getIfPresent((Object)(stackTail = new StackTail(message)))) == null) {
            this.myStackCache.put((Object)stackTail, (Object)true);
            if (level.equals(Level.SEVERE)) {
                logger.error(message);
            } else if (level.equals(Level.WARNING)) {
                logger.warn(message);
            } else if (level.equals(Level.INFO)) {
                logger.warn(message);
            }
        }
    }

    private void logExceptionOnce(@NotNull Logger logger, @NotNull Level level, @Nullable String message, @NotNull Throwable ex) {
        StackTail stackTail;
        Object present;
        if (logger == null) {
            CidrLogService.$$$reportNull$$$0(14);
        }
        if (level == null) {
            CidrLogService.$$$reportNull$$$0(15);
        }
        if (ex == null) {
            CidrLogService.$$$reportNull$$$0(16);
        }
        if ((present = this.myStackCache.getIfPresent((Object)(stackTail = new StackTail(message, ex)))) == null) {
            this.myStackCache.put((Object)stackTail, (Object)true);
            if (level.equals(Level.SEVERE)) {
                logger.error(message != null ? message : ex.getMessage(), ex);
            } else if (level.equals(Level.WARNING)) {
                logger.warn(message != null ? message : ex.getMessage(), ex);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 6: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrLogService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrLogService";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logOnce";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "logMessageOnce";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "logExceptionOnce";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }

    private static class StackTail {
        private static final int TAIL_SIZE = 5;
        @Nullable
        private final String myMessage;
        private final StackTraceElement @NotNull [] myStackTrace;
        private final int myHashCode;

        StackTail(@NotNull String message) {
            if (message == null) {
                StackTail.$$$reportNull$$$0(0);
            }
            this.myMessage = message;
            this.myStackTrace = new StackTraceElement[0];
            this.myHashCode = StackTail.calculateHashCode(this.myMessage, this.myStackTrace);
        }

        StackTail(@Nullable String message, @NotNull Throwable thr) {
            if (thr == null) {
                StackTail.$$$reportNull$$$0(1);
            }
            this.myMessage = message;
            StackTraceElement[] stackTrace = thr.getStackTrace();
            int numToTake = Math.min(stackTrace.length, 5);
            this.myStackTrace = new StackTraceElement[numToTake];
            System.arraycopy(stackTrace, 0, this.myStackTrace, 0, numToTake);
            this.myHashCode = StackTail.calculateHashCode(this.myMessage, this.myStackTrace);
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StackTail)) {
                return false;
            }
            StackTail other = (StackTail)obj;
            if (!Objects.equals(this.myMessage, other.myMessage)) {
                return false;
            }
            if (this.myStackTrace.length != other.myStackTrace.length) {
                return false;
            }
            for (int i = 0; i < this.myStackTrace.length; ++i) {
                if (this.myStackTrace[i].equals(other.myStackTrace[i])) continue;
                return false;
            }
            return true;
        }

        private static int calculateHashCode(@Nullable String message, StackTraceElement @NotNull [] stackTrace) {
            if (stackTrace == null) {
                StackTail.$$$reportNull$$$0(2);
            }
            int hc = Objects.hash(message);
            for (StackTraceElement element : stackTrace) {
                hc ^= element.hashCode();
            }
            return hc;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thr";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stackTrace";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/CidrLogService$StackTail";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateHashCode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

