/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle;

import com.android.ide.common.gradle.Version;
import com.google.common.collect.BoundType;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u0000 02\u00020\u0001:\u00010B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00040\u0004J\u000e\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\f0\fJ\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u000e\u001a\n \n*\u0004\u0018\u00010\u00040\u0004J\u000e\u0010\u000f\u001a\n \n*\u0004\u0018\u00010\f0\fJ\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0004J\u0014\u0010\u0013\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0000J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000J\u0014\u0010\u001c\u001a\u00020\u00002\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eJ\u0013\u0010\u001f\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u0004\u0018\u00010#J\b\u0010$\u001a\u00020#H\u0016J\r\u0010*\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b+J\b\u0010,\u001a\u00020\bH\u0002J\b\u0010-\u001a\u00020\bH\u0002J\b\u0010.\u001a\u00020\bH\u0002J\b\u0010/\u001a\u00020\bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0013\u0010'\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u00061"}, d2={"Lcom/android/ide/common/gradle/VersionRange;", "", "range", "Lcom/google/common/collect/Range;", "Lcom/android/ide/common/gradle/Version;", "<init>", "(Lcom/google/common/collect/Range;)V", "hasLowerBound", "", "lowerEndpoint", "kotlin.jvm.PlatformType", "lowerBoundType", "Lcom/google/common/collect/BoundType;", "hasUpperBound", "upperEndpoint", "upperBoundType", "isEmpty", "contains", "version", "containsAll", "versions", "", "encloses", "other", "isConnected", "intersection", "gap", "span", "canonical", "domain", "Lcom/google/common/collect/DiscreteDomain;", "equals", "hashCode", "", "toIdentifier", "", "toString", "isSingleton", "()Z", "singletonVersion", "getSingletonVersion", "()Lcom/android/ide/common/gradle/Version;", "withoutUpperBound", "withoutUpperBound$android_sdktools_sdk_common_gradle", "isPrefixRange", "isSingletonRange", "validLowerBoundForMavenRange", "validUpperBoundForMavenRange", "Companion", "android.sdktools.sdk-common.gradle"})
@SourceDebugExtension(value={"SMAP\nVersionRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionRange.kt\ncom/android/ide/common/gradle/VersionRange\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1#2:219\n*E\n"})
public final class VersionRange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Range<Version> range;
    @NotNull
    private static final Regex MAVEN_STYLE_REGEX = new Regex("^[\\[(\\]][^,]*,[^,]*[\\[)\\]]$");

    public VersionRange(@NotNull Range<Version> range) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        this.range = range;
    }

    public final boolean hasLowerBound() {
        return this.range.hasLowerBound();
    }

    public final Version lowerEndpoint() {
        return (Version)this.range.lowerEndpoint();
    }

    public final BoundType lowerBoundType() {
        return this.range.lowerBoundType();
    }

    public final boolean hasUpperBound() {
        return this.range.hasUpperBound();
    }

    public final Version upperEndpoint() {
        return (Version)this.range.upperEndpoint();
    }

    public final BoundType upperBoundType() {
        return this.range.upperBoundType();
    }

    public final boolean isEmpty() {
        return this.range.isEmpty();
    }

    public final boolean contains(@NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.range.contains((Comparable)version);
    }

    public final boolean containsAll(@NotNull Iterable<Version> versions) {
        Intrinsics.checkNotNullParameter(versions, (String)"versions");
        return this.range.containsAll(versions);
    }

    public final boolean encloses(@NotNull VersionRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.range.encloses(other.range);
    }

    public final boolean isConnected(@NotNull VersionRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.range.isConnected(other.range);
    }

    @NotNull
    public final VersionRange intersection(@NotNull VersionRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Range range = this.range.intersection(other.range);
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"intersection(...)");
        return new VersionRange((Range<Version>)range);
    }

    @NotNull
    public final VersionRange gap(@NotNull VersionRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Range range = this.range.gap(other.range);
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"gap(...)");
        return new VersionRange((Range<Version>)range);
    }

    @NotNull
    public final VersionRange span(@NotNull VersionRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Range range = this.range.span(other.range);
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"span(...)");
        return new VersionRange((Range<Version>)range);
    }

    @NotNull
    public final VersionRange canonical(@NotNull DiscreteDomain<Version> domain) {
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        Range range = this.range.canonical(domain);
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"canonical(...)");
        return new VersionRange((Range<Version>)range);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof VersionRange && Intrinsics.areEqual(this.range, ((VersionRange)other).range);
    }

    public int hashCode() {
        return this.range.hashCode();
    }

    @Nullable
    public final String toIdentifier() {
        if (!this.hasLowerBound() && !this.hasUpperBound()) {
            return "+";
        }
        if (this.isSingletonRange()) {
            String id = String.valueOf(this.lowerEndpoint());
            return StringsKt.endsWith$default((CharSequence)id, (char)'+', (boolean)false, (int)2, null) ? null : (MAVEN_STYLE_REGEX.matches((CharSequence)id) ? null : id);
        }
        if (this.isPrefixRange()) {
            return this.lowerEndpoint().prefixVersion() + ".+";
        }
        if (this.isEmpty() || this.validLowerBoundForMavenRange() && this.validUpperBoundForMavenRange()) {
            StringBuilder stringBuilder;
            String it;
            StringBuilder stringBuilder2;
            StringBuilder sb = new StringBuilder();
            if (!this.hasLowerBound()) {
                stringBuilder2 = sb.append("(");
            } else {
                it = this.lowerEndpoint().toString();
                boolean bl = false;
                boolean bl2 = StringsKt.contains$default((CharSequence)it, (char)',', (boolean)false, (int)2, null) || ((CharSequence)it).length() == 0;
                if (bl2) {
                    return null;
                }
                stringBuilder2 = this.lowerBoundType() == BoundType.OPEN ? sb.append("" + '(' + this.lowerEndpoint()) : sb.append("" + '[' + this.lowerEndpoint());
            }
            sb.append(",");
            if (!this.hasUpperBound()) {
                stringBuilder = sb.append(")");
            } else {
                it = this.upperEndpoint().toString();
                boolean bl = false;
                boolean bl3 = StringsKt.contains$default((CharSequence)it, (char)',', (boolean)false, (int)2, null) || ((CharSequence)it).length() == 0;
                if (bl3) {
                    return null;
                }
                stringBuilder = this.upperBoundType() == BoundType.OPEN ? sb.append("" + this.upperEndpoint().prefixVersion() + ')') : sb.append("" + this.upperEndpoint() + ']');
            }
            return sb.toString();
        }
        return null;
    }

    @NotNull
    public String toString() {
        String id = this.toIdentifier();
        String string = id;
        if (string == null) {
            string = "VersionRange(range=" + this.range + ')';
        }
        return string;
    }

    public final boolean isSingleton() {
        return this.isSingletonRange();
    }

    @Nullable
    public final Version getSingletonVersion() {
        return this.isSingletonRange() ? this.lowerEndpoint() : null;
    }

    @NotNull
    public final VersionRange withoutUpperBound$android_sdktools_sdk_common_gradle() {
        VersionRange versionRange;
        if (!this.hasUpperBound()) {
            versionRange = this;
        } else if (!this.hasLowerBound()) {
            Range range = Range.all();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"all(...)");
            versionRange = new VersionRange((Range<Version>)range);
        } else {
            BoundType boundType = this.lowerBoundType();
            switch (boundType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[boundType.ordinal()]) {
                case 1: {
                    Range range = Range.atLeast((Comparable)this.lowerEndpoint());
                    Intrinsics.checkNotNullExpressionValue((Object)range, (String)"atLeast(...)");
                    versionRange = new VersionRange((Range<Version>)range);
                    break;
                }
                case 2: {
                    Range range = Range.greaterThan((Comparable)this.lowerEndpoint());
                    Intrinsics.checkNotNullExpressionValue((Object)range, (String)"greaterThan(...)");
                    versionRange = new VersionRange((Range<Version>)range);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return versionRange;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPrefixRange() {
        if (!this.hasLowerBound()) return false;
        if (!this.hasUpperBound()) return false;
        VersionRange it = this;
        boolean bl = false;
        Version lower = this.lowerEndpoint();
        Version upper = this.upperEndpoint();
        if (this.lowerBoundType() != BoundType.CLOSED) return false;
        if (!lower.isPrefixInfimum()) return false;
        if (this.upperBoundType() != BoundType.OPEN) return false;
        if (!upper.isPrefixInfimum()) return false;
        if (!Intrinsics.areEqual((Object)lower.nextPrefix(), (Object)upper)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSingletonRange() {
        if (!this.hasLowerBound()) return false;
        if (!this.hasUpperBound()) return false;
        VersionRange it = this;
        boolean bl = false;
        Version lower = this.lowerEndpoint();
        Version upper = this.upperEndpoint();
        if (this.lowerBoundType() != BoundType.CLOSED) return false;
        if (lower.isPrefixInfimum()) return false;
        if (this.upperBoundType() != BoundType.CLOSED) return false;
        if (!Intrinsics.areEqual((Object)lower, (Object)upper)) return false;
        return true;
    }

    private final boolean validLowerBoundForMavenRange() {
        return !this.hasLowerBound() || !this.lowerEndpoint().isPrefixInfimum();
    }

    private final boolean validUpperBoundForMavenRange() {
        return !this.hasUpperBound() || this.upperBoundType() == BoundType.CLOSED && !this.upperEndpoint().isPrefixInfimum() || this.upperBoundType() == BoundType.OPEN && this.upperEndpoint().isPrefixInfimum();
    }

    @JvmStatic
    @NotNull
    public static final VersionRange parse(@NotNull String string) {
        return Companion.parse(string);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J4\u0010\r\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\f0\f \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\f0\f\u0018\u00010\u000b0\u000b2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/ide/common/gradle/VersionRange$Companion;", "", "<init>", "()V", "MAVEN_STYLE_REGEX", "Lkotlin/text/Regex;", "parse", "Lcom/android/ide/common/gradle/VersionRange;", "string", "", "parseMavenRange", "Lcom/google/common/collect/Range;", "Lcom/android/ide/common/gradle/Version;", "emptyRange", "kotlin.jvm.PlatformType", "version", "parsePrefixRange", "parseSingletonRange", "android.sdktools.sdk-common.gradle"})
    @SourceDebugExtension(value={"SMAP\nVersionRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionRange.kt\ncom/android/ide/common/gradle/VersionRange$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1#2:219\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final VersionRange parse(@NotNull String string) {
            Range<Version> range;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            if (Intrinsics.areEqual((Object)string, (Object)"+")) {
                range = Range.all();
            } else {
                CharSequence charSequence = string;
                range = MAVEN_STYLE_REGEX.matches(charSequence) ? this.parseMavenRange(string) : (StringsKt.endsWith$default((String)string, (String)"+", (boolean)false, (int)2, null) ? this.parsePrefixRange(string) : this.parseSingletonRange(string));
            }
            Range<Version> range2 = range;
            Intrinsics.checkNotNull((Object)range2);
            return new VersionRange(range2);
        }

        private final Range<Version> parseMavenRange(String string) {
            Range range;
            boolean higherClosed;
            int commaIndex = StringsKt.indexOf$default((CharSequence)string, (char)',', (int)0, (boolean)false, (int)6, null);
            String string2 = string.substring(1, commaIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String lowerString = string2;
            String string3 = string.substring(commaIndex + 1, string.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String higherString = string3;
            boolean lowerClosed = string.charAt(0) == '[';
            boolean bl = higherClosed = string.charAt(string.length() - 1) == ']';
            if (Intrinsics.areEqual((Object)lowerString, (Object)"") && Intrinsics.areEqual((Object)higherString, (Object)"")) {
                Range range2 = Range.all();
                Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"all(...)");
                return range2;
            }
            if (Intrinsics.areEqual((Object)higherString, (Object)"")) {
                Range range3;
                boolean bl2 = lowerClosed;
                if (bl2) {
                    Range range4 = Range.atLeast((Comparable)Version.Companion.parse(lowerString));
                    range3 = range4;
                    Intrinsics.checkNotNullExpressionValue((Object)range4, (String)"atLeast(...)");
                } else if (!bl2) {
                    Range range5 = Range.greaterThan((Comparable)Version.Companion.parse(lowerString));
                    range3 = range5;
                    Intrinsics.checkNotNullExpressionValue((Object)range5, (String)"greaterThan(...)");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return range3;
            }
            if (Intrinsics.areEqual((Object)lowerString, (Object)"")) {
                Range range6;
                boolean bl3 = higherClosed;
                if (bl3) {
                    Range range7 = Range.atMost((Comparable)Version.Companion.parse(higherString));
                    range6 = range7;
                    Intrinsics.checkNotNullExpressionValue((Object)range7, (String)"atMost(...)");
                } else if (!bl3) {
                    Range range8 = Range.lessThan((Comparable)Version.Companion.prefixInfimum(higherString));
                    range6 = range8;
                    Intrinsics.checkNotNullExpressionValue((Object)range8, (String)"lessThan(...)");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return range6;
            }
            Version lowerVersion = Version.Companion.parse(lowerString);
            String it = higherString;
            boolean bl4 = false;
            Version higherVersion = higherClosed ? Version.Companion.parse(it) : Version.Companion.prefixInfimum(it);
            if (lowerVersion.compareTo(higherVersion) > 0) {
                Range range9 = this.emptyRange(lowerVersion);
                range = range9;
                Intrinsics.checkNotNullExpressionValue(range9, (String)"emptyRange(...)");
            } else if (lowerClosed && higherClosed) {
                Range range10 = Range.closed((Comparable)lowerVersion, (Comparable)higherVersion);
                range = range10;
                Intrinsics.checkNotNullExpressionValue((Object)range10, (String)"closed(...)");
            } else if (lowerClosed && !higherClosed) {
                Range range11 = Range.closedOpen((Comparable)lowerVersion, (Comparable)higherVersion);
                range = range11;
                Intrinsics.checkNotNullExpressionValue((Object)range11, (String)"closedOpen(...)");
            } else if (!lowerClosed && higherClosed) {
                Range range12 = Range.openClosed((Comparable)lowerVersion, (Comparable)higherVersion);
                range = range12;
                Intrinsics.checkNotNullExpressionValue((Object)range12, (String)"openClosed(...)");
            } else {
                Range range13 = Range.open((Comparable)lowerVersion, (Comparable)higherVersion);
                range = range13;
                Intrinsics.checkNotNullExpressionValue((Object)range13, (String)"open(...)");
            }
            return range;
        }

        private final Range<Version> emptyRange(Version version) {
            return Range.closedOpen((Comparable)version, (Comparable)version);
        }

        private final Range<Version> parsePrefixRange(String string) {
            CharSequence charSequence = string;
            Regex regex = new Regex("[-+_.]?\\+$");
            String string2 = "";
            Version lower = Version.Companion.prefixInfimum(regex.replace(charSequence, string2));
            Version upper = lower.nextPrefix();
            Range range = Range.closedOpen((Comparable)lower, (Comparable)upper);
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"closedOpen(...)");
            return range;
        }

        private final Range<Version> parseSingletonRange(String string) {
            Range range = Range.singleton((Comparable)Version.Companion.parse(string));
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"singleton(...)");
            return range;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BoundType.values().length];
            try {
                nArray[BoundType.CLOSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoundType.OPEN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

