/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkImage;
import org.eclipse.swt.internal.gtk.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public int pixmap;
    public int mask;
    public int surface;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image(Device device) {
        super(device);
    }

    public Image(Device device, int n, int n2) {
        super(device);
        this.init(n, n2);
        this.init();
    }

    public Image(Device device, Image image, int n) {
        super(device);
        int n2;
        int n3;
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        device = this.device;
        this.type = image.type;
        if (OS.USE_CAIRO) {
            int n4;
            if (n != 1) {
                this.transparentPixel = image.transparentPixel;
            }
            this.alpha = image.alpha;
            if (image.alphaData != null) {
                this.alphaData = new byte[image.alphaData.length];
                System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
            int n5 = image.surface;
            int n6 = this.width = image.width;
            int n7 = this.height = image.height;
            int n8 = Cairo.cairo_surface_get_content(n5) == 4096 ? 1 : 0;
            boolean bl = n8 == 0;
            this.surface = Cairo.cairo_image_surface_create(n8, n6, n7);
            if (this.surface == 0) {
                SWT.error(2);
            }
            if ((n4 = Cairo.cairo_create(this.surface)) == 0) {
                SWT.error(2);
            }
            Cairo.cairo_set_operator(n4, 1);
            Cairo.cairo_set_source_surface(n4, n5, 0.0, 0.0);
            Cairo.cairo_paint(n4);
            Cairo.cairo_destroy(n4);
            if (n != 0) {
                int n9;
                int n10;
                int n11;
                int n12;
                int n13 = Cairo.cairo_image_surface_get_stride(this.surface);
                int n14 = Cairo.cairo_image_surface_get_data(this.surface);
                if (OS.BIG_ENDIAN) {
                    n12 = 0;
                    n11 = 1;
                    n10 = 2;
                    n9 = 3;
                } else {
                    n12 = 3;
                    n11 = 2;
                    n10 = 1;
                    n9 = 0;
                }
                switch (n) {
                    case 1: {
                        Color color = device.getSystemColor(18);
                        RGB rGB = color.getRGB();
                        int n15 = rGB.red;
                        int n16 = rGB.green;
                        int n17 = rGB.blue;
                        Color color2 = device.getSystemColor(22);
                        RGB rGB2 = color2.getRGB();
                        int n18 = rGB2.red;
                        int n19 = rGB2.green;
                        int n20 = rGB2.blue;
                        byte[] byArray = new byte[n13];
                        int n21 = 0;
                        while (n21 < n7) {
                            OS.memmove(byArray, n14 + n21 * n13, n13);
                            int n22 = 0;
                            int n23 = 0;
                            while (n22 < n6) {
                                int n24;
                                int n25 = byArray[n23 + n12] & 0xFF;
                                int n26 = byArray[n23 + n11] & 0xFF;
                                int n27 = byArray[n23 + n10] & 0xFF;
                                int n28 = byArray[n23 + n9] & 0xFF;
                                if (bl && n25 != 0) {
                                    n26 = (n26 * 255 + n25 / 2) / n25;
                                    n27 = (n27 * 255 + n25 / 2) / n25;
                                    n28 = (n28 * 255 + n25 / 2) / n25;
                                }
                                if ((n24 = n26 * n26 + n27 * n27 + n28 * n28) < 98304) {
                                    n26 = n15;
                                    n27 = n16;
                                    n28 = n17;
                                } else {
                                    n26 = n18;
                                    n27 = n19;
                                    n28 = n20;
                                }
                                if (bl) {
                                    n26 = n26 * n25 + 128;
                                    n26 = n26 + (n26 >> 8) >> 8;
                                    n27 = n27 * n25 + 128;
                                    n27 = n27 + (n27 >> 8) >> 8;
                                    n28 = n28 * n25 + 128;
                                    n28 = n28 + (n28 >> 8) >> 8;
                                }
                                byArray[n23 + n11] = (byte)n26;
                                byArray[n23 + n10] = (byte)n27;
                                byArray[n23 + n9] = (byte)n28;
                                ++n22;
                                n23 += 4;
                            }
                            OS.memmove(n14 + n21 * n13, byArray, n13);
                            ++n21;
                        }
                        break;
                    }
                    case 2: {
                        byte[] byArray = new byte[n13];
                        int n29 = 0;
                        while (n29 < n7) {
                            OS.memmove(byArray, n14 + n29 * n13, n13);
                            int n30 = 0;
                            int n31 = 0;
                            while (n30 < n6) {
                                int n32 = byArray[n31 + n12] & 0xFF;
                                int n33 = byArray[n31 + n11] & 0xFF;
                                int n34 = byArray[n31 + n10] & 0xFF;
                                int n35 = byArray[n31 + n9] & 0xFF;
                                if (bl && n32 != 0) {
                                    n33 = (n33 * 255 + n32 / 2) / n32;
                                    n34 = (n34 * 255 + n32 / 2) / n32;
                                    n35 = (n35 * 255 + n32 / 2) / n32;
                                }
                                int n36 = n33 + n33 + n34 + n34 + n34 + n34 + n34 + n35 >> 3;
                                if (bl) {
                                    n36 = n36 * n32 + 128;
                                    n36 = n36 + (n36 >> 8) >> 8;
                                }
                                byte by = (byte)n36;
                                byArray[n31 + n9] = by;
                                byArray[n31 + n10] = by;
                                byArray[n31 + n11] = by;
                                ++n30;
                                n31 += 4;
                            }
                            OS.memmove(n14 + n29 * n13, byArray, n13);
                            ++n29;
                        }
                        break;
                    }
                }
            }
            this.init();
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(image.pixmap, nArray, nArray2);
        int n37 = nArray[0];
        int n38 = nArray2[0];
        if (image.type == 1 && image.mask != 0 || image.transparentPixel != -1) {
            if (image.transparentPixel != -1) {
                image.createMask();
            }
            if ((n3 = OS.gdk_pixmap_new(0, n37, n38, 1)) == 0) {
                SWT.error(2);
            }
            if ((n2 = OS.gdk_gc_new(n3)) == 0) {
                SWT.error(2);
            }
            OS.gdk_draw_drawable(n3, n2, image.mask, 0, 0, 0, 0, n37, n38);
            OS.g_object_unref(n2);
            this.mask = n3;
            if (image.transparentPixel != -1 && image.memGC != null) {
                image.destroyMask();
            }
        }
        if (n != 1) {
            this.transparentPixel = image.transparentPixel;
        }
        this.alpha = image.alpha;
        if (image.alphaData != null) {
            this.alphaData = new byte[image.alphaData.length];
            System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
        }
        this.createAlphaMask(n37, n38);
        n3 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), n37, n38, -1);
        if (n3 == 0) {
            SWT.error(2);
        }
        if ((n2 = OS.gdk_gc_new(n3)) == 0) {
            SWT.error(2);
        }
        this.pixmap = n3;
        if (n == 0) {
            OS.gdk_draw_drawable(n3, n2, image.pixmap, 0, 0, 0, 0, n37, n38);
            OS.g_object_unref(n2);
        } else {
            int n39 = OS.gdk_pixbuf_new(0, false, 8, n37, n38);
            if (n39 == 0) {
                SWT.error(2);
            }
            int n40 = OS.gdk_colormap_get_system();
            OS.gdk_pixbuf_get_from_drawable(n39, image.pixmap, n40, 0, 0, 0, 0, n37, n38);
            int n41 = OS.gdk_pixbuf_get_rowstride(n39);
            int n42 = OS.gdk_pixbuf_get_pixels(n39);
            switch (n) {
                case 1: {
                    Color color = device.getSystemColor(18);
                    RGB rGB = color.getRGB();
                    byte by = (byte)rGB.red;
                    byte by2 = (byte)rGB.green;
                    byte by3 = (byte)rGB.blue;
                    Color color3 = device.getSystemColor(22);
                    RGB rGB3 = color3.getRGB();
                    byte by4 = (byte)rGB3.red;
                    byte by5 = (byte)rGB3.green;
                    byte by6 = (byte)rGB3.blue;
                    byte[] byArray = new byte[n41];
                    int n43 = 0;
                    while (n43 < n38) {
                        OS.memmove(byArray, n42 + n43 * n41, n41);
                        int n44 = 0;
                        while (n44 < n37) {
                            int n45 = n44 * 3;
                            int n46 = byArray[n45] & 0xFF;
                            int n47 = byArray[n45 + 1] & 0xFF;
                            int n48 = byArray[n45 + 2] & 0xFF;
                            int n49 = n46 * n46 + n47 * n47 + n48 * n48;
                            if (n49 < 98304) {
                                byArray[n45] = by;
                                byArray[n45 + 1] = by2;
                                byArray[n45 + 2] = by3;
                            } else {
                                byArray[n45] = by4;
                                byArray[n45 + 1] = by5;
                                byArray[n45 + 2] = by6;
                            }
                            ++n44;
                        }
                        OS.memmove(n42 + n43 * n41, byArray, n41);
                        ++n43;
                    }
                    break;
                }
                case 2: {
                    byte[] byArray = new byte[n41];
                    int n50 = 0;
                    while (n50 < n38) {
                        OS.memmove(byArray, n42 + n50 * n41, n41);
                        int n51 = 0;
                        while (n51 < n37) {
                            byte by;
                            int n52 = n51 * 3;
                            int n53 = byArray[n52] & 0xFF;
                            int n54 = byArray[n52 + 1] & 0xFF;
                            int n55 = byArray[n52 + 2] & 0xFF;
                            byte by7 = by = (byte)(n53 + n53 + n54 + n54 + n54 + n54 + n54 + n55 >> 3);
                            byArray[n52 + 2] = by7;
                            byArray[n52 + 1] = by7;
                            byArray[n52] = by7;
                            ++n51;
                        }
                        OS.memmove(n42 + n50 * n41, byArray, n41);
                        ++n50;
                    }
                    break;
                }
            }
            OS.gdk_pixbuf_render_to_drawable(n39, n3, n2, 0, 0, 0, 0, n37, n38, 1, 0, 0);
            OS.g_object_unref(n39);
            OS.g_object_unref(n2);
        }
        this.init();
    }

    public Image(Device device, Rectangle rectangle) {
        super(device);
        if (rectangle == null) {
            SWT.error(4);
        }
        this.init(rectangle.width, rectangle.height);
        this.init();
    }

    public Image(Device device, ImageData imageData) {
        super(device);
        this.init(imageData);
        this.init();
    }

    public Image(Device device, ImageData imageData, ImageData imageData2) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        imageData2 = ImageData.convertMask(imageData2);
        ImageData imageData3 = new ImageData(imageData.width, imageData.height, imageData.depth, imageData.palette, imageData.scanlinePad, imageData.data);
        imageData3.maskPad = imageData2.scanlinePad;
        imageData3.maskData = imageData2.data;
        this.init(imageData3);
        this.init();
    }

    public Image(Device device, InputStream inputStream) {
        super(device);
        this.init(new ImageData(inputStream));
        this.init();
    }

    public Image(Device device, String string) {
        super(device);
        if (string == null) {
            SWT.error(4);
        }
        this.initNative(string);
        if (this.pixmap == 0 && this.surface == 0) {
            this.init(new ImageData(string));
        }
        this.init();
    }

    /*
     * Exception decompiling
     */
    void initNative(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 70->76)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void createAlphaMask(int n, int n2) {
        if (this.device.useXRender && (this.alpha != -1 || this.alphaData != null)) {
            this.mask = OS.gdk_pixmap_new(0, this.alpha != -1 ? 1 : n, this.alpha != -1 ? 1 : n2, 8);
            if (this.mask == 0) {
                SWT.error(2);
            }
            int n3 = OS.gdk_gc_new(this.mask);
            if (this.alpha != -1) {
                GdkColor gdkColor = new GdkColor();
                gdkColor.pixel = (this.alpha & 0xFF) << 8 | this.alpha & 0xFF;
                OS.gdk_gc_set_foreground(n3, gdkColor);
                OS.gdk_draw_rectangle(this.mask, n3, 1, 0, 0, 1, 1);
            } else {
                int n4 = OS.gdk_drawable_get_image(this.mask, 0, 0, n, n2);
                if (n4 == 0) {
                    SWT.error(2);
                }
                GdkImage gdkImage = new GdkImage();
                OS.memmove(gdkImage, n4);
                if (gdkImage.bpl == n) {
                    OS.memmove(gdkImage.mem, this.alphaData, this.alphaData.length);
                } else {
                    byte[] byArray = new byte[gdkImage.bpl];
                    int n5 = 0;
                    while (n5 < n2) {
                        System.arraycopy(this.alphaData, n * n5, byArray, 0, n);
                        OS.memmove(gdkImage.mem + gdkImage.bpl * n5, byArray, (int)gdkImage.bpl);
                        ++n5;
                    }
                }
                OS.gdk_draw_image(this.mask, n3, n4, 0, 0, 0, 0, n, n2);
                OS.g_object_unref(n4);
            }
            OS.g_object_unref(n3);
        }
    }

    void createFromPixbuf(int n, int n2) {
        this.type = n;
        boolean bl = OS.gdk_pixbuf_get_has_alpha(n2);
        if (OS.USE_CAIRO) {
            int n3 = this.width = OS.gdk_pixbuf_get_width(n2);
            int n4 = this.height = OS.gdk_pixbuf_get_height(n2);
            int n5 = OS.gdk_pixbuf_get_rowstride(n2);
            int n6 = OS.gdk_pixbuf_get_pixels(n2);
            int n7 = bl ? 0 : 1;
            this.surface = Cairo.cairo_image_surface_create(n7, n3, n4);
            if (this.surface == 0) {
                SWT.error(2);
            }
            int n8 = Cairo.cairo_image_surface_get_data(this.surface);
            int n9 = Cairo.cairo_image_surface_get_stride(this.surface);
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            if (OS.BIG_ENDIAN) {
                n10 = 0;
                n11 = 1;
                n12 = 2;
                n13 = 3;
            } else {
                n10 = 3;
                n11 = 2;
                n12 = 1;
                n13 = 0;
            }
            byte[] byArray = new byte[n5];
            if (bl) {
                this.alphaData = new byte[n3 * n4];
                int n14 = 0;
                int n15 = 0;
                while (n14 < n4) {
                    OS.memmove(byArray, n6 + n14 * n5, n5);
                    int n16 = 0;
                    int n17 = 0;
                    while (n16 < n3) {
                        int n18 = byArray[n17 + 3] & 0xFF;
                        int n19 = (byArray[n17 + 0] & 0xFF) * n18 + 128;
                        n19 = n19 + (n19 >> 8) >> 8;
                        int n20 = (byArray[n17 + 1] & 0xFF) * n18 + 128;
                        n20 = n20 + (n20 >> 8) >> 8;
                        int n21 = (byArray[n17 + 2] & 0xFF) * n18 + 128;
                        n21 = n21 + (n21 >> 8) >> 8;
                        byArray[n17 + n10] = (byte)n18;
                        byArray[n17 + n11] = (byte)n19;
                        byArray[n17 + n12] = (byte)n20;
                        byArray[n17 + n13] = (byte)n21;
                        this.alphaData[n15++] = (byte)n18;
                        ++n16;
                        n17 += 4;
                    }
                    OS.memmove(n8 + n14 * n5, byArray, n5);
                    ++n14;
                }
            } else {
                byte[] byArray2 = new byte[n9];
                int n22 = 0;
                while (n22 < n4) {
                    OS.memmove(byArray, n6 + n22 * n5, n5);
                    int n23 = 0;
                    int n24 = 0;
                    int n25 = 0;
                    while (n23 < n3) {
                        int n26 = byArray[n24 + 0] & 0xFF;
                        int n27 = byArray[n24 + 1] & 0xFF;
                        int n28 = byArray[n24 + 2] & 0xFF;
                        byArray2[n25 + n11] = (byte)n26;
                        byArray2[n25 + n12] = (byte)n27;
                        byArray2[n25 + n13] = (byte)n28;
                        ++n23;
                        n24 += 3;
                        n25 += 4;
                    }
                    OS.memmove(n8 + n22 * n9, byArray2, n9);
                    ++n22;
                }
            }
            Cairo.cairo_surface_mark_dirty(this.surface);
        } else {
            if (bl) {
                int n29 = OS.gdk_pixbuf_get_width(n2);
                int n30 = OS.gdk_pixbuf_get_height(n2);
                int n31 = OS.gdk_pixbuf_get_rowstride(n2);
                int n32 = OS.gdk_pixbuf_get_pixels(n2);
                byte[] byArray = new byte[n31];
                this.alphaData = new byte[n29 * n30];
                int n33 = 0;
                while (n33 < n30) {
                    OS.memmove(byArray, n32 + n33 * n31, n31);
                    int n34 = 0;
                    while (n34 < n29) {
                        this.alphaData[n33 * n29 + n34] = byArray[n34 * 4 + 3];
                        byArray[n34 * 4 + 3] = -1;
                        ++n34;
                    }
                    OS.memmove(n32 + n33 * n31, byArray, n31);
                    ++n33;
                }
                this.createAlphaMask(n29, n30);
            }
            int[] nArray = new int[1];
            OS.gdk_pixbuf_render_pixmap_and_mask(n2, nArray, null, 0);
            this.pixmap = nArray[0];
            if (this.pixmap == 0) {
                SWT.error(2);
            }
        }
    }

    void createMask() {
        if (OS.USE_CAIRO) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = this.width;
            int n9 = this.height;
            int n10 = Cairo.cairo_image_surface_get_stride(this.surface);
            int n11 = Cairo.cairo_image_surface_get_data(this.surface);
            if (OS.BIG_ENDIAN) {
                n7 = 0;
                n6 = 1;
                n5 = 2;
                n4 = 3;
                n3 = this.transparentPixel >> 24 & 0xFF;
                n2 = this.transparentPixel >> 16 & 0xFF;
                n = this.transparentPixel >> 8 & 0xFF;
            } else {
                n7 = 3;
                n6 = 2;
                n5 = 1;
                n4 = 0;
                n3 = this.transparentPixel >> 16 & 0xFF;
                n2 = this.transparentPixel >> 8 & 0xFF;
                n = this.transparentPixel >> 0 & 0xFF;
            }
            byte[] byArray = new byte[n10 * n9];
            OS.memmove(byArray, n11, byArray.length);
            int n12 = 0;
            int n13 = 0;
            while (n13 < n9) {
                int n14 = 0;
                while (n14 < n8) {
                    int n15 = byArray[n12 + n7] & 0xFF;
                    int n16 = byArray[n12 + n6] & 0xFF;
                    int n17 = byArray[n12 + n5] & 0xFF;
                    int n18 = byArray[n12 + n4] & 0xFF;
                    if (n16 == n3 && n17 == n2 && n18 == n) {
                        n18 = 0;
                        n17 = 0;
                        n16 = 0;
                        n15 = 0;
                    } else {
                        n15 = 255;
                    }
                    byArray[n12 + n7] = (byte)n15;
                    byArray[n12 + n6] = (byte)n16;
                    byArray[n12 + n5] = (byte)n17;
                    byArray[n12 + n4] = (byte)n18;
                    ++n14;
                    n12 += 4;
                }
                ++n13;
            }
            OS.memmove(n11, byArray, byArray.length);
            return;
        }
        if (this.mask != 0) {
            return;
        }
        this.mask = this.createMask(this.getImageData(), false);
        if (this.mask == 0) {
            SWT.error(2);
        }
    }

    int createMask(ImageData imageData, boolean bl) {
        ImageData imageData2 = imageData.getTransparencyMask();
        byte[] byArray = imageData2.data;
        byte[] byArray2 = bl ? new byte[byArray.length] : byArray;
        int n = 0;
        while (n < byArray2.length) {
            byte by = byArray[n];
            byArray2[n] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            ++n;
        }
        byArray2 = ImageData.convertPad(byArray2, imageData2.width, imageData2.height, imageData2.depth, imageData2.scanlinePad, 1);
        return OS.gdk_bitmap_create_from_data(0, byArray2, imageData2.width, imageData2.height);
    }

    void createSurface() {
        if (this.surface != 0) {
            return;
        }
        if (this.transparentPixel != -1) {
            this.createMask();
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(this.pixmap, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        if (this.mask != 0 || this.alpha != -1 || this.alphaData != null) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = OS.gdk_pixbuf_new(0, true, 8, n, n2);
            if (n8 == 0) {
                SWT.error(2);
            }
            int n9 = OS.gdk_colormap_get_system();
            OS.gdk_pixbuf_get_from_drawable(n8, this.pixmap, n9, 0, 0, 0, 0, n, n2);
            int n10 = OS.gdk_pixbuf_get_rowstride(n8);
            int n11 = OS.gdk_pixbuf_get_pixels(n8);
            byte[] byArray = new byte[n10];
            if (OS.BIG_ENDIAN) {
                n7 = 0;
                n6 = 1;
                n5 = 2;
                n4 = 3;
            } else {
                n7 = 3;
                n6 = 2;
                n5 = 1;
                n4 = 0;
            }
            if (this.mask != 0 && OS.gdk_drawable_get_depth(this.mask) == 1) {
                n3 = OS.gdk_pixbuf_new(0, false, 8, n, n2);
                if (n3 == 0) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(n3, this.mask, 0, 0, 0, 0, 0, n, n2);
                int n12 = OS.gdk_pixbuf_get_rowstride(n3);
                int n13 = OS.gdk_pixbuf_get_pixels(n3);
                byte[] byArray2 = new byte[n12];
                int n14 = n11;
                int n15 = n13;
                int n16 = 0;
                while (n16 < n2) {
                    OS.memmove(byArray, n14, n10);
                    OS.memmove(byArray2, n15, n12);
                    int n17 = 0;
                    int n18 = 0;
                    while (n17 < n) {
                        if (byArray2[n17 * 3] == 0) {
                            byArray[n18 + 3] = 0;
                            byArray[n18 + 2] = 0;
                            byArray[n18 + 1] = 0;
                            byArray[n18 + 0] = 0;
                        } else {
                            byte by = byArray[n18 + 0];
                            byte by2 = byArray[n18 + 1];
                            byte by3 = byArray[n18 + 2];
                            byArray[n18 + n7] = -1;
                            byArray[n18 + n6] = by;
                            byArray[n18 + n5] = by2;
                            byArray[n18 + n4] = by3;
                        }
                        ++n17;
                        n18 += 4;
                    }
                    OS.memmove(n14, byArray, n10);
                    n14 += n10;
                    n15 += n12;
                    ++n16;
                }
                OS.g_object_unref(n3);
            } else if (this.alpha != -1) {
                n3 = n11;
                int n19 = 0;
                while (n19 < n2) {
                    OS.memmove(byArray, n3, n10);
                    int n20 = 0;
                    int n21 = 0;
                    while (n20 < n) {
                        int n22 = (byArray[n21 + 0] & 0xFF) * this.alpha + 128;
                        n22 = n22 + (n22 >> 8) >> 8;
                        int n23 = (byArray[n21 + 1] & 0xFF) * this.alpha + 128;
                        n23 = n23 + (n23 >> 8) >> 8;
                        int n24 = (byArray[n21 + 2] & 0xFF) * this.alpha + 128;
                        n24 = n24 + (n24 >> 8) >> 8;
                        byArray[n21 + n7] = (byte)this.alpha;
                        byArray[n21 + n6] = (byte)n22;
                        byArray[n21 + n5] = (byte)n23;
                        byArray[n21 + n4] = (byte)n24;
                        ++n20;
                        n21 += 4;
                    }
                    OS.memmove(n3, byArray, n10);
                    n3 += n10;
                    ++n19;
                }
            } else if (this.alphaData != null) {
                n3 = n11;
                int n25 = 0;
                while (n25 < nArray2[0]) {
                    OS.memmove(byArray, n3, n10);
                    int n26 = 0;
                    int n27 = 0;
                    while (n26 < n) {
                        int n28 = this.alphaData[n25 * nArray[0] + n26] & 0xFF;
                        int n29 = (byArray[n27 + 0] & 0xFF) * n28 + 128;
                        n29 = n29 + (n29 >> 8) >> 8;
                        int n30 = (byArray[n27 + 1] & 0xFF) * n28 + 128;
                        n30 = n30 + (n30 >> 8) >> 8;
                        int n31 = (byArray[n27 + 2] & 0xFF) * n28 + 128;
                        n31 = n31 + (n31 >> 8) >> 8;
                        byArray[n27 + n7] = (byte)n28;
                        byArray[n27 + n6] = (byte)n29;
                        byArray[n27 + n5] = (byte)n30;
                        byArray[n27 + n4] = (byte)n31;
                        ++n26;
                        n27 += 4;
                    }
                    OS.memmove(n3, byArray, n10);
                    n3 += n10;
                    ++n25;
                }
            } else {
                n3 = n11;
                int n32 = 0;
                while (n32 < nArray2[0]) {
                    OS.memmove(byArray, n3, n10);
                    int n33 = 0;
                    int n34 = 0;
                    while (n33 < n) {
                        byte by = byArray[n34 + 0];
                        byte by4 = byArray[n34 + 1];
                        byte by5 = byArray[n34 + 2];
                        byArray[n34 + n7] = -1;
                        byArray[n34 + n6] = by;
                        byArray[n34 + n5] = by4;
                        byArray[n34 + n4] = by5;
                        ++n33;
                        n34 += 4;
                    }
                    OS.memmove(n3, byArray, n10);
                    n3 += n10;
                    ++n32;
                }
            }
            this.surface = Cairo.cairo_image_surface_create(0, n, n2);
            n3 = Cairo.cairo_image_surface_get_data(this.surface);
            OS.memmove(n3, n11, n10 * n2);
            Cairo.cairo_surface_mark_dirty(this.surface);
            OS.g_object_unref(n8);
        } else {
            int n35 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            int n36 = OS.GDK_PIXMAP_XID(this.pixmap);
            int n37 = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
            this.surface = Cairo.cairo_xlib_surface_create(n35, n36, n37, n, n2);
        }
        if (this.transparentPixel != -1 && this.memGC != null) {
            this.destroyMask();
        }
    }

    void destroyMask() {
        if (this.mask == 0) {
            return;
        }
        OS.g_object_unref(this.mask);
        this.mask = 0;
    }

    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.pixmap != 0) {
            OS.g_object_unref(this.pixmap);
        }
        if (this.mask != 0) {
            OS.g_object_unref(this.mask);
        }
        if (this.surface != 0) {
            Cairo.cairo_surface_destroy(this.surface);
        }
        this.mask = 0;
        this.pixmap = 0;
        this.surface = 0;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        if (OS.USE_CAIRO) {
            return this.device == image.device && this.surface == image.surface;
        }
        return this.device == image.device && this.pixmap == image.pixmap;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(this.pixmap, nArray, nArray2);
        this.width = nArray[0];
        this.height = nArray2[0];
        return new Rectangle(0, 0, this.width, this.height);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (OS.USE_CAIRO) {
            int n;
            int n2;
            int n3;
            int n4;
            boolean bl;
            int n5 = ImageList.convertSurface(this);
            int n6 = Cairo.cairo_image_surface_get_format(n5);
            int n7 = Cairo.cairo_image_surface_get_width(n5);
            int n8 = Cairo.cairo_image_surface_get_height(n5);
            int n9 = Cairo.cairo_image_surface_get_stride(n5);
            int n10 = Cairo.cairo_image_surface_get_data(n5);
            boolean bl2 = bl = n6 == 0;
            if (OS.BIG_ENDIAN) {
                n4 = 0;
                n3 = 1;
                n2 = 2;
                n = 3;
            } else {
                n4 = 3;
                n3 = 2;
                n2 = 1;
                n = 0;
            }
            byte[] byArray = new byte[n9 * n8];
            OS.memmove(byArray, n10, byArray.length);
            PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
            ImageData imageData = new ImageData(n7, n8, 32, paletteData, 4, byArray);
            if (bl) {
                imageData.alphaData = new byte[n7 * n8];
                byte[] byArray2 = imageData.alphaData;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                while (n11 < n8) {
                    int n14 = 0;
                    while (n14 < n7) {
                        int n15 = byArray[n12 + n4] & 0xFF;
                        int n16 = byArray[n12 + n3] & 0xFF;
                        int n17 = byArray[n12 + n2] & 0xFF;
                        int n18 = byArray[n12 + n] & 0xFF;
                        byArray[n12 + 0] = 0;
                        byArray2[n13++] = (byte)n15;
                        if (n15 != 0) {
                            byArray[n12 + 1] = (byte)((n16 * 255 + n15 / 2) / n15);
                            byArray[n12 + 2] = (byte)((n17 * 255 + n15 / 2) / n15);
                            byArray[n12 + 3] = (byte)((n18 * 255 + n15 / 2) / n15);
                        }
                        ++n14;
                        n12 += 4;
                    }
                    ++n11;
                }
            } else {
                int n19 = 0;
                int n20 = 0;
                while (n19 < n8) {
                    int n21 = 0;
                    while (n21 < n7) {
                        byte by = byArray[n20 + n3];
                        byte by2 = byArray[n20 + n2];
                        byte by3 = byArray[n20 + n];
                        byArray[n20 + 0] = 0;
                        byArray[n20 + 1] = by;
                        byArray[n20 + 2] = by2;
                        byArray[n20 + 3] = by3;
                        ++n21;
                        n20 += 4;
                    }
                    ++n19;
                }
            }
            Cairo.cairo_surface_destroy(n5);
            return imageData;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(this.pixmap, nArray, nArray2);
        int n = nArray[0];
        int n22 = nArray2[0];
        int n23 = OS.gdk_pixbuf_new(0, false, 8, n, n22);
        if (n23 == 0) {
            SWT.error(2);
        }
        int n24 = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(n23, this.pixmap, n24, 0, 0, 0, 0, n, n22);
        int n25 = OS.gdk_pixbuf_get_rowstride(n23);
        int n26 = OS.gdk_pixbuf_get_pixels(n23);
        byte[] byArray = new byte[n25 * n22];
        OS.memmove(byArray, n26, byArray.length);
        OS.g_object_unref(n23);
        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(n, n22, 24, paletteData, 4, byArray);
        imageData.bytesPerLine = n25;
        if (this.transparentPixel == -1 && this.type == 1 && this.mask != 0) {
            int n27;
            int n28 = OS.gdk_drawable_get_image(this.mask, 0, 0, n, n22);
            if (n28 == 0) {
                SWT.error(2);
            }
            GdkImage gdkImage = new GdkImage();
            OS.memmove(gdkImage, n28);
            byte[] byArray3 = new byte[gdkImage.bpl * gdkImage.height];
            OS.memmove(byArray3, gdkImage.mem, byArray3.length);
            OS.g_object_unref(n28);
            int n29 = 1;
            while (n29 < 128) {
                n27 = ((n + 7) / 8 + (n29 - 1)) / n29 * n29;
                if (gdkImage.bpl == n27) break;
                ++n29;
            }
            imageData.maskPad = 2;
            byArray3 = ImageData.convertPad(byArray3, n, n22, 1, n29, imageData.maskPad);
            if (gdkImage.byte_order == 0) {
                n27 = 0;
                while (n27 < byArray3.length) {
                    byte by = byArray3[n27];
                    byArray3[n27] = (byte)((by & 1) << 7 | (by & 2) << 5 | (by & 4) << 3 | (by & 8) << 1 | (by & 0x10) >> 1 | (by & 0x20) >> 3 | (by & 0x40) >> 5 | (by & 0x80) >> 7);
                    ++n27;
                }
            }
            imageData.maskData = byArray3;
        }
        imageData.transparentPixel = this.transparentPixel;
        imageData.alpha = this.alpha;
        if (this.alpha == -1 && this.alphaData != null) {
            imageData.alphaData = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, imageData.alphaData, 0, this.alphaData.length);
        }
        return imageData;
    }

    public static Image gtk_new(Device device, int n, int n2, int n3) {
        Image image = new Image(device);
        image.type = n;
        image.pixmap = n2;
        image.mask = n3;
        if (OS.USE_CAIRO) {
            image.createSurface();
        }
        return image;
    }

    public static Image gtk_new_from_pixbuf(Device device, int n, int n2) {
        Image image = new Image(device);
        image.createFromPixbuf(n, n2);
        image.type = n;
        return image;
    }

    public int hashCode() {
        if (OS.USE_CAIRO) {
            return this.surface;
        }
        return this.pixmap;
    }

    void init(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        if (OS.USE_CAIRO) {
            int n3;
            if (OS.GTK_VERSION >= OS.VERSION(2, 22, 0)) {
                this.surface = OS.gdk_window_create_similar_surface(OS.gdk_get_default_root_window(), 4096, n, n2);
            } else {
                int n4;
                int n5;
                n3 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
                int n6 = Cairo.cairo_xlib_surface_create(n3, n5 = OS.gdk_x11_drawable_get_xid(OS.gdk_get_default_root_window()), n4 = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system()), 1, 1);
                if (n6 == 0) {
                    SWT.error(2);
                }
                this.surface = Cairo.cairo_surface_create_similar(n6, 4096, n, n2);
                Cairo.cairo_surface_destroy(n6);
            }
            if (this.surface == 0) {
                SWT.error(2);
            }
            if ((n3 = Cairo.cairo_create(this.surface)) == 0) {
                SWT.error(2);
            }
            Cairo.cairo_set_source_rgb(n3, 1.0, 1.0, 1.0);
            Cairo.cairo_rectangle(n3, 0.0, 0.0, n, n2);
            Cairo.cairo_fill(n3);
            Cairo.cairo_destroy(n3);
            this.width = n;
            this.height = n2;
            return;
        }
        this.pixmap = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), n, n2, -1);
        if (this.pixmap == 0) {
            SWT.error(2);
        }
        GdkColor gdkColor = new GdkColor();
        gdkColor.red = (short)-1;
        gdkColor.green = (short)-1;
        gdkColor.blue = (short)-1;
        int n7 = OS.gdk_colormap_get_system();
        OS.gdk_colormap_alloc_color(n7, gdkColor, true, true);
        int n8 = OS.gdk_gc_new(this.pixmap);
        OS.gdk_gc_set_foreground(n8, gdkColor);
        OS.gdk_draw_rectangle(this.pixmap, n8, 1, 0, 0, n, n2);
        OS.g_object_unref(n8);
        OS.gdk_colormap_free_colors(n7, gdkColor, 1);
    }

    void init(ImageData imageData) {
        boolean bl;
        Object object;
        int n;
        if (imageData == null) {
            SWT.error(4);
        }
        int n2 = this.width = imageData.width;
        int n3 = this.height = imageData.height;
        PaletteData paletteData = imageData.palette;
        if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || paletteData.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !paletteData.isDirect)) {
            SWT.error(38);
        }
        if (OS.USE_CAIRO) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            boolean bl2 = imageData.transparentPixel != -1 || imageData.alpha != -1 || imageData.maskData != null || imageData.alphaData != null;
            int n10 = bl2 ? 0 : 1;
            this.surface = Cairo.cairo_image_surface_create(n10, n2, n3);
            if (this.surface == 0) {
                SWT.error(2);
            }
            int n11 = Cairo.cairo_image_surface_get_stride(this.surface);
            int n12 = Cairo.cairo_image_surface_get_data(this.surface);
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            int n17 = 32;
            if (OS.BIG_ENDIAN) {
                n13 = 0;
                n14 = 1;
                n15 = 2;
                n16 = 3;
                n9 = 65280;
                n8 = 0xFF0000;
                n7 = -16777216;
                n6 = 1;
            } else {
                n13 = 3;
                n14 = 2;
                n15 = 1;
                n16 = 0;
                n9 = 0xFF0000;
                n8 = 65280;
                n7 = 255;
                n6 = 0;
            }
            byte[] byArray = imageData.data;
            if (!paletteData.isDirect || imageData.depth != n17 || n11 != imageData.bytesPerLine || paletteData.redMask != n9 || paletteData.greenMask != n8 || paletteData.blueMask != n7 || n6 != imageData.getByteOrder()) {
                byArray = new byte[n11 * n3];
                if (paletteData.isDirect) {
                    ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n2, n3, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, byArray, n17, n11, n6, 0, 0, n2, n3, n9, n8, n7, false, false);
                } else {
                    RGB[] rGBArray = paletteData.getRGBs();
                    n5 = rGBArray.length;
                    byte[] byArray2 = new byte[n5];
                    byte[] byArray3 = new byte[n5];
                    byte[] byArray4 = new byte[n5];
                    n4 = 0;
                    while (n4 < rGBArray.length) {
                        RGB rGB = rGBArray[n4];
                        if (rGB != null) {
                            byArray2[n4] = (byte)rGB.red;
                            byArray3[n4] = (byte)rGB.green;
                            byArray4[n4] = (byte)rGB.blue;
                        }
                        ++n4;
                    }
                    ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n2, n3, byArray2, byArray3, byArray4, 255, null, 0, 0, 0, byArray, n17, n11, n6, 0, 0, n2, n3, n9, n8, n7, false, false);
                }
            }
            boolean bl3 = imageData.getTransparencyType() == 2;
            int n18 = this.type = bl3 ? 1 : 0;
            if (bl3 || imageData.transparentPixel != -1) {
                if (imageData.transparentPixel != -1) {
                    RGB rGB = null;
                    if (paletteData.isDirect) {
                        rGB = paletteData.getRGB(imageData.transparentPixel);
                    } else if (imageData.transparentPixel < paletteData.colors.length) {
                        rGB = paletteData.getRGB(imageData.transparentPixel);
                    }
                    if (rGB != null) {
                        this.transparentPixel = rGB.red << 16 | rGB.green << 8 | rGB.blue;
                    }
                }
                ImageData imageData2 = imageData.getTransparencyMask();
                int n19 = 0;
                int n20 = 0;
                while (n19 < n3) {
                    int n21 = 0;
                    while (n21 < n2) {
                        n4 = imageData2.getPixel(n21, n19) == 0 ? 0 : 255;
                        int n22 = (byArray[n20 + n14] & 0xFF) * n4 + 128;
                        n22 = n22 + (n22 >> 8) >> 8;
                        int n23 = (byArray[n20 + n15] & 0xFF) * n4 + 128;
                        n23 = n23 + (n23 >> 8) >> 8;
                        int n24 = (byArray[n20 + n16] & 0xFF) * n4 + 128;
                        n24 = n24 + (n24 >> 8) >> 8;
                        byArray[n20 + n13] = (byte)n4;
                        byArray[n20 + n14] = (byte)n22;
                        byArray[n20 + n15] = (byte)n23;
                        byArray[n20 + n16] = (byte)n24;
                        ++n21;
                        n20 += 4;
                    }
                    ++n19;
                }
            } else {
                this.alpha = imageData.alpha;
                if (imageData.alpha == -1 && imageData.alphaData != null) {
                    this.alphaData = new byte[imageData.alphaData.length];
                    System.arraycopy(imageData.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                }
                if (this.alpha != -1) {
                    n5 = 0;
                    int n25 = 0;
                    while (n5 < n3) {
                        int n26 = 0;
                        while (n26 < n2) {
                            int n27 = this.alpha;
                            n4 = (byArray[n25 + n14] & 0xFF) * n27 + 128;
                            n4 = n4 + (n4 >> 8) >> 8;
                            int n28 = (byArray[n25 + n15] & 0xFF) * n27 + 128;
                            n28 = n28 + (n28 >> 8) >> 8;
                            int n29 = (byArray[n25 + n16] & 0xFF) * n27 + 128;
                            n29 = n29 + (n29 >> 8) >> 8;
                            byArray[n25 + n13] = (byte)n27;
                            byArray[n25 + n14] = (byte)n4;
                            byArray[n25 + n15] = (byte)n28;
                            byArray[n25 + n16] = (byte)n29;
                            ++n26;
                            n25 += 4;
                        }
                        ++n5;
                    }
                } else if (this.alphaData != null) {
                    n5 = 0;
                    int n30 = 0;
                    while (n5 < n3) {
                        int n31 = 0;
                        while (n31 < n2) {
                            int n32 = this.alphaData[n5 * n2 + n31] & 0xFF;
                            n4 = (byArray[n30 + n14] & 0xFF) * n32 + 128;
                            n4 = n4 + (n4 >> 8) >> 8;
                            int n33 = (byArray[n30 + n15] & 0xFF) * n32 + 128;
                            n33 = n33 + (n33 >> 8) >> 8;
                            int n34 = (byArray[n30 + n16] & 0xFF) * n32 + 128;
                            n34 = n34 + (n34 >> 8) >> 8;
                            byArray[n30 + n13] = (byte)n32;
                            byArray[n30 + n14] = (byte)n4;
                            byArray[n30 + n15] = (byte)n33;
                            byArray[n30 + n16] = (byte)n34;
                            ++n31;
                            n30 += 4;
                        }
                        ++n5;
                    }
                }
            }
            OS.memmove(n12, byArray, n11 * n3);
            Cairo.cairo_surface_mark_dirty(this.surface);
            return;
        }
        int n35 = OS.gdk_pixbuf_new(0, false, 8, n2, n3);
        if (n35 == 0) {
            SWT.error(2);
        }
        int n36 = OS.gdk_pixbuf_get_rowstride(n35);
        int n37 = OS.gdk_pixbuf_get_pixels(n35);
        byte[] byArray = imageData.data;
        if (!paletteData.isDirect || imageData.depth != 24 || n36 != imageData.bytesPerLine || paletteData.redMask != 0xFF0000 || paletteData.greenMask != 65280 || paletteData.blueMask != 255) {
            byArray = new byte[n36 * n3];
            if (paletteData.isDirect) {
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n2, n3, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, byArray, 24, n36, 1, 0, 0, n2, n3, 0xFF0000, 65280, 255, false, false);
            } else {
                RGB[] rGBArray = paletteData.getRGBs();
                n = rGBArray.length;
                byte[] byArray5 = new byte[n];
                object = new byte[n];
                byte[] byArray6 = new byte[n];
                int n38 = 0;
                while (n38 < rGBArray.length) {
                    RGB rGB = rGBArray[n38];
                    if (rGB != null) {
                        byArray5[n38] = (byte)rGB.red;
                        object[n38] = (byte)rGB.green;
                        byArray6[n38] = (byte)rGB.blue;
                    }
                    ++n38;
                }
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n2, n3, byArray5, object, byArray6, 255, null, 0, 0, 0, byArray, 24, n36, 1, 0, 0, n2, n3, 0xFF0000, 65280, 255, false, false);
            }
        }
        OS.memmove(n37, byArray, n36 * n3);
        int n39 = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), n2, n3, -1);
        if (n39 == 0) {
            SWT.error(2);
        }
        if ((n = OS.gdk_gc_new(n39)) == 0) {
            SWT.error(2);
        }
        OS.gdk_pixbuf_render_to_drawable(n35, n39, n, 0, 0, 0, 0, n2, n3, 1, 0, 0);
        OS.g_object_unref(n);
        OS.g_object_unref(n35);
        boolean bl4 = bl = imageData.getTransparencyType() == 2;
        if (bl || imageData.transparentPixel != -1) {
            int n40;
            if (imageData.transparentPixel != -1) {
                object = null;
                if (paletteData.isDirect) {
                    object = paletteData.getRGB(imageData.transparentPixel);
                } else if (imageData.transparentPixel < paletteData.colors.length) {
                    object = paletteData.getRGB(imageData.transparentPixel);
                }
                if (object != null) {
                    this.transparentPixel = object.red << 16 | object.green << 8 | object.blue;
                }
            }
            if ((n40 = this.createMask(imageData, bl)) == 0) {
                SWT.error(2);
            }
            this.mask = n40;
            this.type = bl ? 1 : 0;
        } else {
            this.type = 0;
            this.mask = 0;
            this.alpha = imageData.alpha;
            if (imageData.alpha == -1 && imageData.alphaData != null) {
                this.alphaData = new byte[imageData.alphaData.length];
                System.arraycopy(imageData.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
            this.createAlphaMask(n2, n3);
        }
        this.pixmap = n39;
    }

    public int internal_new_GC(GCData gCData) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        int n = OS.USE_CAIRO ? Cairo.cairo_create(this.surface) : OS.gdk_gc_new(this.pixmap);
        if (gCData != null) {
            int n2 = 0x6000000;
            if ((gCData.style & n2) == 0) {
                gCData.style |= 0x2000000;
            } else if ((gCData.style & 0x4000000) != 0) {
                gCData.style |= 0x8000000;
            }
            gCData.device = this.device;
            gCData.drawable = this.pixmap;
            gCData.background = this.device.COLOR_WHITE.handle;
            gCData.foreground = this.device.COLOR_BLACK.handle;
            gCData.font = this.device.systemFont;
            gCData.image = this;
        }
        return n;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        int n2 = n;
        if (OS.USE_CAIRO) {
            Cairo.cairo_destroy(n2);
        } else {
            OS.g_object_unref(n2);
        }
    }

    public boolean isDisposed() {
        if (OS.USE_CAIRO) {
            return this.surface == 0;
        }
        return this.pixmap == 0;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        if (OS.USE_CAIRO) {
            return "Image {" + this.surface + "}";
        }
        return "Image {" + this.pixmap + "}";
    }
}

