/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.StaticAnalysisAnnotationManager;
import com.intellij.codeInsight.options.JavaClassValidator;
import com.intellij.codeInspection.AnnotatedApiUsageUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ScheduledForRemovalMessageProvider;
import com.intellij.codeInspection.UnstableApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0015\u0010\u0004\u001a\u00020\u00058\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/codeInspection/UnstableApiUsageInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "SCHEDULED_FOR_REMOVAL_ANNOTATION_NAME", "", "getSCHEDULED_FOR_REMOVAL_ANNOTATION_NAME", "()Ljava/lang/String;", "knownAnnotationMessageProviders", "", "Lcom/intellij/codeInspection/ScheduledForRemovalMessageProvider;", "unstableApiAnnotations", "", "myIgnoreInsideImports", "", "myIgnoreApiDeclaredInThisProject", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "intellij.jvm.analysis.impl"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nUnstableApiUsageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnstableApiUsageInspection.kt\ncom/intellij/codeInspection/UnstableApiUsageInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,321:1\n28#1:322\n1755#2,3:323\n*S KotlinDebug\n*F\n+ 1 UnstableApiUsageInspection.kt\ncom/intellij/codeInspection/UnstableApiUsageInspection\n*L\n30#1:322\n44#1:323,3\n*E\n"})
public final class UnstableApiUsageInspection
extends LocalInspectionTool {
    @NotNull
    private final Map<String, ScheduledForRemovalMessageProvider> knownAnnotationMessageProviders;
    @JvmField
    @NotNull
    public final List<String> unstableApiAnnotations;
    @JvmField
    public boolean myIgnoreInsideImports;
    @JvmField
    public boolean myIgnoreApiDeclaredInThisProject;

    public UnstableApiUsageInspection() {
        UnstableApiUsageInspection this_$iv = this;
        boolean $i$f$getSCHEDULED_FOR_REMOVAL_ANNOTATION_NAME = false;
        String string = ApiStatus.ScheduledForRemoval.class.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
        this.knownAnnotationMessageProviders = MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)new ScheduledForRemovalMessageProvider()));
        String[] stringArray = StaticAnalysisAnnotationManager.getInstance().getKnownUnstableApiAnnotations();
        this.unstableApiAnnotations = (List)new ExternalizableStringSet(Arrays.copyOf(stringArray, stringArray.length));
        this.myIgnoreInsideImports = true;
        this.myIgnoreApiDeclaredInThisProject = true;
    }

    private final String getSCHEDULED_FOR_REMOVAL_ANNOTATION_NAME() {
        boolean $i$f$getSCHEDULED_FOR_REMOVAL_ANNOTATION_NAME = false;
        String string = ApiStatus.ScheduledForRemoval.class.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        boolean bl;
        List annotations;
        block5: {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            annotations = CollectionsKt.toList((Iterable)this.unstableApiAnnotations);
            Iterable $this$any$iv = annotations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    PsiFile psiFile = holder.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
                    if (!AnnotatedApiUsageUtil.INSTANCE.canAnnotationBeUsedInFile(it, psiFile)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            psiElementVisitor = ApiUsageUastVisitor.Companion.createPsiElementVisitor((ApiUsageProcessor)new UnstableApiUsageProcessor(holder, this.myIgnoreInsideImports, this.myIgnoreApiDeclaredInThisProject, annotations, this.knownAnnotationMessageProviders));
        } else {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNull((Object)psiElementVisitor2);
            psiElementVisitor = psiElementVisitor2;
        }
        return psiElementVisitor;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"myIgnoreInsideImports", (String)JvmAnalysisBundle.message("jvm.inspections.unstable.api.usage.ignore.inside.imports", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myIgnoreApiDeclaredInThisProject", (String)JvmAnalysisBundle.message("jvm.inspections.unstable.api.usage.ignore.declared.inside.this.project", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.stringList((String)"unstableApiAnnotations", (String)JvmAnalysisBundle.message("jvm.inspections.unstable.api.usage.annotations.list", new Object[0]), (StringValidator)((StringValidator)new JavaClassValidator().annotationsOnly()))};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }
}

