/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.googleWalletActivity.app_package;

import com.android.tools.idea.wizard.template.Language;
import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import com.android.tools.idea.wizard.template.impl.activities.common.ViewBindingUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"walletActivityKt", "", "activityClass", "layoutName", "packageName", "applicationPackage", "isViewBindingSupported", "", "intellij.android.wizardTemplate.impl"})
@SourceDebugExtension(value={"SMAP\nwalletActivityKt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 walletActivityKt.kt\ncom/android/tools/idea/wizard/template/impl/activities/googleWalletActivity/app_package/WalletActivityKtKt\n+ 2 helpers.kt\ncom/android/tools/idea/wizard/template/HelpersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n42#2,5:210\n1#3:215\n*S KotlinDebug\n*F\n+ 1 walletActivityKt.kt\ncom/android/tools/idea/wizard/template/impl/activities/googleWalletActivity/app_package/WalletActivityKtKt\n*L\n85#1:210,5\n85#1:215\n*E\n"})
public final class WalletActivityKtKt {
    @NotNull
    public static final String walletActivityKt(@NotNull String activityClass, @NotNull String layoutName, @NotNull String packageName, @Nullable String applicationPackage, boolean isViewBindingSupported) {
        String string;
        Intrinsics.checkNotNullParameter((Object)activityClass, (String)"activityClass");
        Intrinsics.checkNotNullParameter((Object)layoutName, (String)"layoutName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String contentViewBlock = isViewBindingSupported ? "\n      // Use view binding to access the UI elements\n      layout = " + ViewBindingUtilsKt.layoutToViewBindingClass(layoutName) + ".inflate(layoutInflater)\n      setContentView(layout.root)\n  " : "setContentView(R.layout." + layoutName + ")";
        String googleWalletButtonBlock = isViewBindingSupported ? "addToGoogleWalletButton = layout.addToGoogleWalletButton.root" : "addToGoogleWalletButton = findViewById<View>(R.id.addToGoogleWalletButton)";
        String string2 = TemplateHelpersKt.escapeKotlinIdentifier(packageName);
        String string3 = ViewBindingUtilsKt.importViewBindingClass(isViewBindingSupported, packageName, applicationPackage, layoutName, Language.Kotlin);
        String string4 = activityClass;
        boolean predicate$iv = isViewBindingSupported;
        boolean trim$iv = true;
        boolean skipLine$iv = true;
        boolean $i$f$renderIf = false;
        if (predicate$iv) {
            String string5 = string4;
            String string6 = string3;
            String string7 = string2;
            boolean bl = false;
            String string8 = "\n    private lateinit var layout: " + ViewBindingUtilsKt.layoutToViewBindingClass(layoutName) + "\n";
            string2 = string7;
            string3 = string6;
            string4 = string5;
            string = ((Object)StringsKt.trim((CharSequence)string8)).toString();
        } else {
            String string9;
            String it$iv = string9 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            boolean bl = false;
            string = string9;
            if (string == null) {
                string = "";
            }
        }
        return "\npackage " + string2 + "\n\nimport android.content.Intent\nimport android.os.Bundle\nimport android.view.View\nimport android.widget.Toast\nimport androidx.appcompat.app.AppCompatActivity\nimport androidx.core.view.isVisible\nimport com.google.android.gms.pay.Pay\nimport com.google.android.gms.pay.PayApiAvailabilityStatus\nimport com.google.android.gms.pay.PayClient\nimport java.util.*\n\n" + string3 + "\n\n/**\n * An Activity that allows the user to add a pass to the user's Google Wallet using the\n * Google Wallet Android SDK.\n *\n * If you are testing out the new Wallet functionality, you will need to create a\n * [Temporary Issuer Account](https://wallet-lab-tools.web.app/issuers) prior to running\n * this example. If you are using the temporary issuer account, you must enter the TODO fields\n * in the [WalletActivity.onAddToWalletClicked] function.\n *\n * If you are using this template to create a custom pass, you will need to sign into the Google Pay\n * Business Console, Create a New Pass, and Alter the JSON in the validator to ensure the pass looks\n * and behaves as preferred. For further instruction, please follow\n * [the provided documentation](https://developers.google.com/wallet/generic/android/prerequisites).\n *\n * @see Pay.getClient\n * @see PayClient.savePasses\n * @see SamplePass\n */\nclass " + string4 + " : AppCompatActivity() {\n\n    companion object {\n        /**\n         * The Request Code we pass along to the Google Wallet API when attempting to add a pass.\n         */\n        private const val ADD_TO_GOOGLE_WALLET_REQUEST_CODE = 1000\n    }\n\n" + string + "\n    private lateinit var addToGoogleWalletButton: View\n\n    /**\n     * The [PayClient] which we use to interact with the Google Wallet API.\n     */\n    private lateinit var walletClient: PayClient\n\n    override fun onCreate(savedInstanceState: Bundle?) {\n        super.onCreate(savedInstanceState)\n\n        // Instantiate the Pay client\n        walletClient = Pay.getClient(this)\n\n        " + contentViewBlock + "\n\n        " + googleWalletButtonBlock + "\n\n        // Attach a click listener to the \"Add To Wallet\" button\n        addToGoogleWalletButton.setOnClickListener { onAddToWalletClicked() }\n\n        // Trigger the API availability request.\n        fetchCanUseGoogleWalletApi()\n    }\n\n    /**\n     * A helper method that allows us to check if the Google Wallet API is available on the current\n     * device.\n     *\n     * Please note, some countries do not have Google Wallet available to them yet.\n     */\n    private fun fetchCanUseGoogleWalletApi() {\n        walletClient\n            .getPayApiAvailabilityStatus(PayClient.RequestType.SAVE_PASSES)\n            .addOnSuccessListener { status ->\n                // Display the \"Add to Wallet\" button if the wallet API is available on this device.\n                addToGoogleWalletButton.isVisible = (status == PayApiAvailabilityStatus.AVAILABLE)\n            }\n            .addOnFailureListener {\n                // Hide the button and optionally show an error message\n                addToGoogleWalletButton.isVisible = false\n\n                Toast.makeText(\n                    this,\n                    R.string.google_wallet_status_unavailable,\n                    Toast.LENGTH_SHORT\n                ).show()\n            }\n    }\n\n    /**\n     * Called when the user clicks the \"Add to Wallet\" button.\n     *\n     * See https://wallet-lab-tools.web.app/issuers to create a temporary issuer account for testing\n     * Google Wallet functionality.\n     */\n    private fun onAddToWalletClicked() {\n        // Create a SamplePass object with your unique fields\n        val samplePass = SamplePass(\n            issuerEmail = \"\",   // TODO(you) \u2013 Enter issuer email address,\n            issuerId = \"\",      // TODO(you) \u2013 Enter issuer ID\n            passClass = \"\",     // TODO(you) \u2013 Enter pass class\n            passId = UUID.randomUUID().toString()\n        )\n\n        // Call to the Wallet API to save the pass to the user's wallet.\n        walletClient.savePasses(samplePass.toJson, this, ADD_TO_GOOGLE_WALLET_REQUEST_CODE)\n    }\n\n    /**\n     * Handle the result from [PayClient.savePasses], where we check to see if our attempt to add\n     * the pass to the user's Google Wallet was successful, or not.\n     *\n     * It is up to the user to handle edge/cases\n     */\n    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {\n        super.onActivityResult(requestCode, resultCode, data)\n\n        if (requestCode != ADD_TO_GOOGLE_WALLET_REQUEST_CODE) {\n            return\n        }\n\n        when (resultCode) {\n            // We successfully added the pass to Google Wallet!\n            RESULT_OK -> {\n                Toast.makeText(\n                    this,\n                    R.string.add_google_wallet_success,\n                    Toast.LENGTH_SHORT\n                ).show()\n            }\n            // Occurs when the user cancelled the flow.\n            RESULT_CANCELED -> {\n                Toast.makeText(\n                    this,\n                    R.string.add_google_wallet_cancelled,\n                    Toast.LENGTH_SHORT\n                ).show()\n            }\n            // A known error occurred when attempting to save the pass to Google Wallet.\n            PayClient.SavePassesResult.SAVE_ERROR -> data?.let { intentData ->\n                // Handle the error message and optionally display it to the user.\n                val errorMessage = intentData.getStringExtra(PayClient.EXTRA_API_ERROR_MESSAGE)\n                Toast.makeText(\n                    this,\n                    errorMessage,\n                    Toast.LENGTH_SHORT\n                )\n            }\n            // An unknown error occurred when attempting to add to Google Wallet.\n            else -> {\n                Toast.makeText(\n                    this,\n                    R.string.add_google_wallet_unknown_error,\n                    Toast.LENGTH_SHORT\n                ).show()\n            }\n        }\n    }\n}\n  ";
    }
}

