/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.googlePayActivity.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"constantsKotlin", "", "packageName", "intellij.android.wizardTemplate.impl"})
public final class ConstantsKtKt {
    @NotNull
    public static final String constantsKotlin(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + "\n\nimport com.google.android.gms.wallet.WalletConstants\n\n/**\n * This file contains several constants you must edit before proceeding.\n * Please take a look at PaymentsUtil.java to see where the constants are used and to potentially\n * remove ones not relevant to your integration.\n *\n *\n * Required changes:\n *\n *  1.  Update SUPPORTED_NETWORKS and SUPPORTED_METHODS if required (consult your processor if\n * unsure)\n *  1.  Update CURRENCY_CODE to the currency you use.\n *  1.  Update SHIPPING_SUPPORTED_COUNTRIES to list the countries where you currently ship. If this\n * is not applicable to your app, remove the relevant bits from PaymentsUtil.java.\n *  1.  If you're integrating with your `PAYMENT_GATEWAY`, update\n * PAYMENT_GATEWAY_TOKENIZATION_NAME and PAYMENT_GATEWAY_TOKENIZATION_PARAMETERS per the\n * instructions they provided. You don't need to update DIRECT_TOKENIZATION_PUBLIC_KEY.\n *  1.  If you're using `DIRECT` integration, please edit protocol version and public key as\n * per the instructions.\n */\nobject Constants {\n    /**\n     * Changing this to ENVIRONMENT_PRODUCTION will make the API return chargeable card information.\n     * Please refer to the documentation to read about the required steps needed to enable\n     * ENVIRONMENT_PRODUCTION.\n     *\n     * @value #PAYMENTS_ENVIRONMENT\n     */\n    const val PAYMENTS_ENVIRONMENT = WalletConstants.ENVIRONMENT_TEST\n\n    /**\n     * The allowed networks to be requested from the API. If the user has cards from networks not\n     * specified here in their account, these will not be offered for them to choose in the popup.\n     *\n     * @value #SUPPORTED_NETWORKS\n     */\n    val SUPPORTED_NETWORKS = listOf(\n            \"AMEX\",\n            \"DISCOVER\",\n            \"JCB\",\n            \"MASTERCARD\",\n            \"VISA\")\n\n    /**\n     * The Google Pay API may return cards on file on Google.com (PAN_ONLY) and/or a device token on\n     * an Android device authenticated with a 3-D Secure cryptogram (CRYPTOGRAM_3DS).\n     *\n     * @value #SUPPORTED_METHODS\n     */\n    val SUPPORTED_METHODS = listOf(\n            \"PAN_ONLY\",\n            \"CRYPTOGRAM_3DS\")\n\n    /**\n     * Required by the API, but not visible to the user.\n     *\n     * @value #COUNTRY_CODE Your local country\n     */\n    const val COUNTRY_CODE = \"US\"\n\n    /**\n     * Required by the API, but not visible to the user.\n     *\n     * @value #CURRENCY_CODE Your local currency\n     */\n    const val CURRENCY_CODE = \"USD\"\n\n    /**\n     * Supported countries for shipping (use ISO 3166-1 alpha-2 country codes). Relevant only when\n     * requesting a shipping address.\n     *\n     * @value #SHIPPING_SUPPORTED_COUNTRIES\n     */\n    val SHIPPING_SUPPORTED_COUNTRIES = listOf(\"US\", \"GB\")\n\n    /**\n     * The name of your payment processor/gateway. Please refer to their documentation for more\n     * information.\n     *\n     * @value #PAYMENT_GATEWAY_TOKENIZATION_NAME\n     */\n    private const val PAYMENT_GATEWAY_TOKENIZATION_NAME = \"example\"\n\n    /**\n     * Custom parameters required by the processor/gateway.\n     * In many cases, your processor / gateway will only require a gatewayMerchantId.\n     * Please refer to your processor's documentation for more information. The number of parameters\n     * required and their names vary depending on the processor.\n     *\n     * @value #PAYMENT_GATEWAY_TOKENIZATION_PARAMETERS\n     */\n    val PAYMENT_GATEWAY_TOKENIZATION_PARAMETERS = mapOf(\n            \"gateway\" to PAYMENT_GATEWAY_TOKENIZATION_NAME,\n            \"gatewayMerchantId\" to \"exampleGatewayMerchantId\"\n    )\n\n    /**\n     * Only used for `DIRECT` tokenization. Can be removed when using `PAYMENT_GATEWAY`\n     * tokenization.\n     *\n     * @value #DIRECT_TOKENIZATION_PUBLIC_KEY\n     */\n    const val DIRECT_TOKENIZATION_PUBLIC_KEY = \"REPLACE_ME\"\n\n    /**\n     * Parameters required for `DIRECT` tokenization.\n     * Only used for `DIRECT` tokenization. Can be removed when using `PAYMENT_GATEWAY`\n     * tokenization.\n     *\n     * @value #DIRECT_TOKENIZATION_PARAMETERS\n     */\n    val DIRECT_TOKENIZATION_PARAMETERS = mapOf(\n            \"protocolVersion\" to \"ECv1\",\n            \"publicKey\" to DIRECT_TOKENIZATION_PUBLIC_KEY\n    )\n}\n";
    }
}

