/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0002H\u0014J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0002H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/lint/common/ReplaceCallFix;", "Lcom/intellij/modcommand/PsiBasedModCommandAction;", "Lcom/intellij/psi/PsiElement;", "mySuggest", "", "element", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "methodName", "getMethodName", "()Ljava/lang/String;", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "Lorg/jetbrains/annotations/NotNull;", "context", "Lcom/intellij/modcommand/ActionContext;", "getFamilyName", "perform", "Lcom/intellij/modcommand/ModCommand;", "handleJava", "", "handleKotlin", "intellij.lint"})
public final class ReplaceCallFix
extends PsiBasedModCommandAction<PsiElement> {
    @NotNull
    private final String mySuggest;

    public ReplaceCallFix(@NotNull String mySuggest, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)mySuggest, (String)"mySuggest");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
        this.mySuggest = mySuggest;
    }

    private final String getMethodName() {
        int start = StringsKt.startsWith$default((String)this.mySuggest, (String)"#", (boolean)false, (int)2, null) ? 1 : 0;
        int parameters = StringsKt.indexOf$default((CharSequence)this.mySuggest, (char)'(', (int)start, (boolean)false, (int)4, null);
        if (parameters == -1) {
            parameters = this.mySuggest.length();
        }
        String string = this.mySuggest.substring(start, parameters);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Presentation presentation = Presentation.of((String)("Call " + this.getMethodName() + " instead"));
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
        return presentation;
    }

    @NotNull
    public String getFamilyName() {
        return "ReplaceCallFix";
    }

    @NotNull
    protected ModCommand perform(@NotNull ActionContext context, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)element, (arg_0, arg_1) -> ReplaceCallFix.perform$lambda$0(element, this, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
        return modCommand;
    }

    private final void handleJava(PsiElement element) {
        String referenceName;
        PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false);
        if (psiMethodCallExpression == null) {
            return;
        }
        PsiMethodCallExpression methodCall = psiMethodCallExpression;
        PsiFile psiFile = methodCall.getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        Document document = file.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        Document document2 = document;
        PsiReferenceExpression psiReferenceExpression = methodCall.getMethodExpression();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceExpression, (String)"getMethodExpression(...)");
        PsiReferenceExpression methodExpression = psiReferenceExpression;
        PsiElement psiElement = methodExpression.getReferenceNameElement();
        if (psiElement == null) {
            return;
        }
        PsiElement referenceNameElement = psiElement;
        TextRange textRange = referenceNameElement.getTextRange();
        if (textRange == null) {
            return;
        }
        TextRange range = textRange;
        String name = this.getMethodName();
        if (StringsKt.startsWith$default((String)name, (String)"enforce", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name, (String)"Permission", (boolean)false, (int)2, null) && (referenceName = methodExpression.getReferenceName()) != null && StringsKt.startsWith$default((String)referenceName, (String)"check", (boolean)false, (int)2, null)) {
            PsiExpressionList psiExpressionList = methodCall.getArgumentList();
            Intrinsics.checkNotNullExpressionValue((Object)psiExpressionList, (String)"getArgumentList(...)");
            PsiExpressionList argumentList = psiExpressionList;
            int offset = argumentList.getTextOffset() + argumentList.getTextLength() - 1;
            document2.insertString(offset, (CharSequence)", \"TODO: message if thrown\"");
        }
        document2.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)name);
    }

    private final void handleKotlin(PsiElement element) {
        PsiElement identifier;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, KtCallExpression.class, (boolean)false);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression methodCall = ktCallExpression;
        KtExpression methodExpression = methodCall.getCalleeExpression();
        if (methodExpression instanceof KtNameReferenceExpression && (identifier = ((KtNameReferenceExpression)methodExpression).getIdentifier()) != null) {
            String referencedName;
            TextRange range = identifier.getTextRange();
            PsiFile psiFile = methodCall.getContainingFile();
            if (psiFile == null) {
                return;
            }
            PsiFile file = psiFile;
            Document document = file.getFileDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
            Document document2 = document;
            String name = this.getMethodName();
            if (StringsKt.startsWith$default((String)name, (String)"enforce", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name, (String)"Permission", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)(referencedName = ((KtNameReferenceExpression)methodExpression).getReferencedName()), (String)"check", (boolean)false, (int)2, null)) {
                KtValueArgumentList ktValueArgumentList = methodCall.getValueArgumentList();
                if (ktValueArgumentList != null && (ktValueArgumentList = ktValueArgumentList.getTextRange()) != null) {
                    KtValueArgumentList range2 = ktValueArgumentList;
                    boolean bl = false;
                    int offset = range2.getEndOffset() - 1;
                    document2.insertString(offset, (CharSequence)", \"TODO: message if thrown\"");
                }
            }
            document2.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)name);
        }
    }

    private static final void perform$lambda$0(PsiElement $element, ReplaceCallFix this$0, PsiElement e, ModPsiUpdater modPsiUpdater) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)modPsiUpdater, (String)"<unused var>");
        Language language = $element.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
            this$0.handleJava(e);
        } else if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
            this$0.handleKotlin(e);
        }
    }
}

