/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Option;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/lint/common/LintInspectionDescriptionLinkHandler;", "Lcom/intellij/codeInsight/highlighting/TooltipLinkHandler;", "<init>", "()V", "handleLink", "", "href", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getDescription", "refSuffix", "Companion", "intellij.lint"})
@SourceDebugExtension(value={"SMAP\nLintInspectionDescriptionLinkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintInspectionDescriptionLinkHandler.kt\ncom/android/tools/idea/lint/common/LintInspectionDescriptionLinkHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1#2:193\n*E\n"})
public final class LintInspectionDescriptionLinkHandler
extends TooltipLinkHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String LINK_PREFIX = "#lint/";
    @NotNull
    private static final String LINK_INFO_SEPARATOR = "<";
    @NotNull
    private static final String LINK_INFO_MARKER = "link_info";
    @NotNull
    private static final Logger LOG;

    public boolean handleLink(@NotNull String href, @NotNull Editor editor) {
        Issue issue;
        String it;
        Intrinsics.checkNotNullParameter((Object)href, (String)"href");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!LintInspectionDescriptionLinkHandler.Companion.isHrefLinkInfo(href)) {
            return false;
        }
        Companion.LinkInfo linkInfo = Companion.decodeLinkInfo(href);
        String string = linkInfo.getUrl();
        if (string != null) {
            it = string;
            boolean bl = false;
            BrowserUtil.browse((String)it);
        }
        String string2 = linkInfo.getProblem();
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            LOG.warn(it);
        }
        String string3 = linkInfo.getUrl();
        if (string3 == null) {
            return true;
        }
        String url = string3;
        Project project = editor.getProject();
        if (project == null) {
            return true;
        }
        Project project2 = project;
        String string4 = linkInfo.getIssueId();
        if (string4 == null) {
            return true;
        }
        String issueId = string4;
        Issue issue2 = new BuiltinIssueRegistry().getIssue(issueId);
        if (issue2 == null) {
            issue2 = AndroidLintInspectionBase.findIssueInCurrentInspectionProfile(project2, issueId);
        }
        if ((issue = issue2) == null) {
            LOG.warn("Could not find issue: issue id: " + issueId);
            return true;
        }
        LintIdeSupport.Companion.get().logTooltipLink(url, issue, project2);
        return true;
    }

    @Nullable
    public String getDescription(@NotNull String refSuffix, @NotNull Editor editor) {
        Vendor vendor;
        Object object;
        List urls;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)refSuffix, (String)"refSuffix");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Issue issue = new BuiltinIssueRegistry().getIssue(refSuffix);
        if (issue == null && (issue = AndroidLintInspectionBase.findIssueInCurrentInspectionProfile(editor.getProject(), refSuffix)) == null) {
            return null;
        }
        Issue issue2 = issue;
        String html = issue2.getExplanation(TextFormat.HTML);
        StringBuilder $this$getDescription_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getDescription_u24lambda_u242.append(html);
        $this$getDescription_u24lambda_u242.append("<br><br>Issue id: " + issue2.getId());
        List options = issue2.getOptions();
        if (!((Collection)options).isEmpty()) {
            $this$getDescription_u24lambda_u242.append("<br><br>" + Option.Companion.describe(options, TextFormat.HTML, true));
        }
        if (!((Collection)(urls = issue2.getMoreInfo())).isEmpty()) {
            $this$getDescription_u24lambda_u242.append("<br><br>More info:<br>");
            for (String url : urls) {
                $this$getDescription_u24lambda_u242.append("<a href=\"" + url + "\">" + url + "</a><br>");
            }
        }
        if ((object = issue2.getVendor()) == null) {
            IssueRegistry issueRegistry = issue2.getRegistry();
            object = issueRegistry != null ? issueRegistry.getVendor() : null;
        }
        if ((vendor = object) != null) {
            $this$getDescription_u24lambda_u242.append("<br>");
            vendor.describeInto($this$getDescription_u24lambda_u242, TextFormat.HTML, "");
        }
        String description = stringBuilder.toString();
        StringBuilder sb = new StringBuilder(2 * description.length());
        int offset = 0;
        int n = description.length();
        while (offset < n) {
            char c = description.charAt(offset);
            if (c == '<' && StringsKt.startsWith((String)description, (String)"<pre", (int)offset, (boolean)true)) {
                int end = StringsKt.indexOf((CharSequence)description, (String)"</pre>", (int)(offset + 4), (boolean)true);
                if (end != -1) {
                    String string = description.substring(offset, end + 6);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    sb.append(string);
                    offset = end + 6;
                    continue;
                }
                String string = description.substring(offset);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                sb.append(string);
                offset = n;
                continue;
            }
            if (c != '\n') {
                sb.append(c);
            }
            ++offset;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        description = string;
        description = Companion.replaceLinksInHtml(description, issue2.getId());
        return description;
    }

    static {
        Logger logger = Logger.getInstance(LintInspectionDescriptionLinkHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/lint/common/LintInspectionDescriptionLinkHandler$Companion;", "", "<init>", "()V", "LINK_PREFIX", "", "LINK_INFO_SEPARATOR", "LINK_INFO_MARKER", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "replaceLinksInHtml", "html", "issueId", "isHrefLinkInfo", "", "href", "decodeLinkInfo", "Lcom/android/tools/idea/lint/common/LintInspectionDescriptionLinkHandler$Companion$LinkInfo;", "LinkInfo", "intellij.lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String replaceLinksInHtml(@NotNull String html, @NotNull String issueId) {
            Intrinsics.checkNotNullParameter((Object)html, (String)"html");
            Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
            if (StringsKt.contains$default((CharSequence)issueId, (CharSequence)LintInspectionDescriptionLinkHandler.LINK_INFO_SEPARATOR, (boolean)false, (int)2, null)) {
                return html;
            }
            return StringsKt.replace$default((String)html, (String)"<a href=\"http", (String)("<a href=\"#lint/link_info<" + issueId + "<http"), (boolean)false, (int)4, null);
        }

        private final boolean isHrefLinkInfo(String href) {
            return StringsKt.startsWith$default((String)href, (String)"link_info<", (boolean)false, (int)2, null);
        }

        @NotNull
        public final LinkInfo decodeLinkInfo(@NotNull String href) {
            Intrinsics.checkNotNullParameter((Object)href, (String)"href");
            int numParts = 3;
            String[] stringArray = new String[]{LintInspectionDescriptionLinkHandler.LINK_INFO_SEPARATOR};
            List parts = StringsKt.split$default((CharSequence)href, (String[])stringArray, (boolean)false, (int)numParts, (int)2, null);
            if (parts.size() != numParts) {
                return new LinkInfo(null, null, "Unexpected number of parts in href containing link info: " + href, 3, null);
            }
            String url = (String)parts.get(2);
            String issueId = (String)parts.get(1);
            return new LinkInfo(issueId, url, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B+\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/lint/common/LintInspectionDescriptionLinkHandler$Companion$LinkInfo;", "", "issueId", "", "url", "problem", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getIssueId", "()Ljava/lang/String;", "getUrl", "getProblem", "intellij.lint"})
        public static final class LinkInfo {
            @Nullable
            private final String issueId;
            @Nullable
            private final String url;
            @Nullable
            private final String problem;

            public LinkInfo(@Nullable String issueId, @Nullable String url, @Nullable String problem) {
                this.issueId = issueId;
                this.url = url;
                this.problem = problem;
            }

            public /* synthetic */ LinkInfo(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                if ((n & 2) != 0) {
                    string2 = null;
                }
                if ((n & 4) != 0) {
                    string3 = null;
                }
                this(string, string2, string3);
            }

            @Nullable
            public final String getIssueId() {
                return this.issueId;
            }

            @Nullable
            public final String getUrl() {
                return this.url;
            }

            @Nullable
            public final String getProblem() {
                return this.problem;
            }

            public LinkInfo() {
                this(null, null, null, 7, null);
            }
        }
    }
}

