/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.AnnotateQuickFix;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeFixPerformerFix;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.ModCommandLintQuickFix;
import com.android.tools.idea.lint.common.ShowUrlQuickFix;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintFixPerformer;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.UtilKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R(\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lcom/android/tools/idea/lint/common/LintIdeFixPerformer;", "Lcom/android/tools/lint/client/api/LintFixPerformer;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;)V", "log", "", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "message", "", "applyEdits", "fileProvider", "Lcom/android/tools/lint/client/api/LintFixPerformer$FileProvider;", "fileData", "Lcom/android/tools/lint/client/api/LintFixPerformer$PendingEditFile;", "edits", "", "Lcom/android/tools/lint/client/api/LintFixPerformer$PendingEdit;", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "getContext", "()Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "setContext", "(Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;)V", "deltas", "", "", "getDeltas", "()Ljava/util/Map;", "setDeltas", "(Ljava/util/Map;)V", "Companion", "intellij.lint"})
public final class LintIdeFixPerformer
extends LintFixPerformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private AndroidQuickfixContexts.Context context;
    @Nullable
    private Map<LintFixPerformer.PendingEditFile, Integer> deltas;

    public LintIdeFixPerformer(@NotNull LintClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(client, false, 2, null);
    }

    public void log(@NotNull Severity severity, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger log = LintIdeClient.LOG;
        if (severity.isError()) {
            log.error(message);
        } else if (severity == Severity.WARNING) {
            log.warn(message);
        } else {
            log.info(message);
        }
    }

    public void applyEdits(@NotNull LintFixPerformer.FileProvider fileProvider, @NotNull LintFixPerformer.PendingEditFile fileData, @NotNull List<LintFixPerformer.PendingEdit> edits) {
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Intrinsics.checkNotNullParameter(edits, (String)"edits");
        throw new UnsupportedOperationException();
    }

    @Nullable
    public final AndroidQuickfixContexts.Context getContext() {
        return this.context;
    }

    public final void setContext(@Nullable AndroidQuickfixContexts.Context context) {
        this.context = context;
    }

    @Nullable
    public final Map<LintFixPerformer.PendingEditFile, Integer> getDeltas() {
        return this.deltas;
    }

    public final void setDeltas(@Nullable Map<LintFixPerformer.PendingEditFile, Integer> map) {
        this.deltas = map;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u001c\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\u0016\u0010 \u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"J&\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\"2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020%0(H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010+\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/lint/common/LintIdeFixPerformer$Companion;", "", "<init>", "()V", "createIdeFixes", "", "Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "isTopLevel", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/android/tools/lint/detector/api/Incident;Lcom/android/tools/lint/detector/api/LintFix;Z)[Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "addJavaImports", "", "javaFile", "Lcom/intellij/psi/PsiJavaFile;", "imports", "", "", "addKotlinImports", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "alreadyImported", "Lcom/intellij/psi/PsiImportList;", "candidate", "Lorg/jetbrains/kotlin/psi/KtImportList;", "shortenJavaReferencesInRange", "range", "Lcom/intellij/openapi/util/TextRange;", "collectDisjointDescendantsCoveringRange", "parent", "Lcom/intellij/psi/PsiElement;", "fileRange", "out", "", "getRangePointer", "Lcom/intellij/psi/SmartPsiFileRange;", "Lcom/android/tools/lint/detector/api/Location;", "intellij.lint"})
    @SourceDebugExtension(value={"SMAP\nLintIdeFixPerformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintIdeFixPerformer.kt\ncom/android/tools/idea/lint/common/LintIdeFixPerformer$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,601:1\n12567#2,2:602\n1755#3,3:604\n*S KotlinDebug\n*F\n+ 1 LintIdeFixPerformer.kt\ncom/android/tools/idea/lint/common/LintIdeFixPerformer$Companion\n*L\n228#1:602,2\n231#1:604,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LintIdeQuickFix[] createIdeFixes(@NotNull Project project, @Nullable PsiFile file, @NotNull Incident incident, @NotNull LintFix fix, boolean isTopLevel) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
            Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
            LintIdeQuickFix[] lintIdeQuickFixArray = fix;
            if (lintIdeQuickFixArray instanceof LintFix.AnnotateFix) {
                if (isTopLevel) {
                    LintIdeQuickFix[] lintIdeQuickFixArray2 = new LintIdeQuickFix[]{new ModCommandLintQuickFix(new AnnotateQuickFix(project, fix.getDisplayName(), fix.getFamilyName(), ((LintFix.AnnotateFix)fix).getAnnotation(), ((LintFix.AnnotateFix)fix).getReplace(), fix.getRange(), ((LintFix.AnnotateFix)fix).getSelectPattern()))};
                    return lintIdeQuickFixArray2;
                }
            } else {
                if (lintIdeQuickFixArray instanceof LintFix.LintFixGroup) {
                    if (((LintFix.LintFixGroup)fix).getType() == LintFix.GroupType.ALTERNATIVES) {
                        List fixList = new ArrayList();
                        for (LintFix nested : ((LintFix.LintFixGroup)fix).getFixes()) {
                            LintIdeQuickFix[] lintIdeQuickFixArray3 = this.createIdeFixes(project, file, incident, nested, false);
                            Collections.addAll(fixList, Arrays.copyOf(lintIdeQuickFixArray3, lintIdeQuickFixArray3.length));
                        }
                        Collection collection = fixList;
                        Intrinsics.checkNotNullExpressionValue((Object)LintIdeQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                        LintIdeQuickFix[] fixes = (LintIdeQuickFix[])UtilKt.toArray((Collection)collection, (Object[])LintIdeQuickFix.EMPTY_ARRAY);
                        if (fixes.length > 1) {
                            fixes[0].setPriority(PriorityAction.Priority.TOP);
                        }
                        return fixes;
                    }
                    LintIdeQuickFix[] lintIdeQuickFixArray4 = new LintIdeQuickFix[]{new ModCommandLintQuickFix(new LintIdeFixPerformerFix(project, incident, (LintFix)fix, null, null, null, 56, null))};
                    return lintIdeQuickFixArray4;
                }
                if (lintIdeQuickFixArray instanceof LintFix.ShowUrl) {
                    LintIdeQuickFix[] lintIdeQuickFixArray5 = new LintIdeQuickFix[]{new ShowUrlQuickFix((LintFix.ShowUrl)fix)};
                    return lintIdeQuickFixArray5;
                }
                if (lintIdeQuickFixArray instanceof LintFix.DataMap) {
                    throw new IllegalStateException(("A DataMap fix should only be used with inspections that override `getQuickFixes` (issue id: " + incident.getIssue().getId() + ")").toString());
                }
            }
            lintIdeQuickFixArray = new LintIdeQuickFix[]{new ModCommandLintQuickFix(new LintIdeFixPerformerFix(project, incident, (LintFix)fix, null, null, null, 56, null))};
            return lintIdeQuickFixArray;
        }

        public static /* synthetic */ LintIdeQuickFix[] createIdeFixes$default(Companion companion, Project project, PsiFile psiFile, Incident incident, LintFix lintFix, boolean bl, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = true;
            }
            return companion.createIdeFixes(project, psiFile, incident, lintFix, bl);
        }

        public final void addJavaImports(@NotNull PsiJavaFile javaFile, @NotNull List<String> imports) {
            Intrinsics.checkNotNullParameter((Object)javaFile, (String)"javaFile");
            Intrinsics.checkNotNullParameter(imports, (String)"imports");
            PsiImportList psiImportList = javaFile.getImportList();
            if (psiImportList == null) {
                return;
            }
            PsiImportList importList = psiImportList;
            Project project = javaFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
            GlobalSearchScope psiSearchScope = globalSearchScope;
            PsiElementFactory psiElementFactory = psiFacade.getElementFactory();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getElementFactory(...)");
            PsiElementFactory psiFactory = psiElementFactory;
            for (String symbol : imports) {
                String memberName;
                String containingClassName;
                if (this.alreadyImported(importList, symbol)) continue;
                PsiClass cls = psiFacade.findClass(symbol, psiSearchScope);
                if (cls != null) {
                    importList.add((PsiElement)psiFactory.createImportStatement(cls));
                    continue;
                }
                int lastDot = StringsKt.lastIndexOf$default((CharSequence)symbol, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (lastDot == -1) continue;
                Intrinsics.checkNotNullExpressionValue((Object)symbol.substring(0, lastDot), (String)"substring(...)");
                PsiClass containingClass = psiFacade.findClass(containingClassName, psiSearchScope);
                if (containingClass == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)symbol.substring(lastDot + 1), (String)"substring(...)");
                importList.add((PsiElement)psiFactory.createImportStaticStatement(containingClass, memberName));
            }
        }

        public final void addKotlinImports(@NotNull KtFile ktFile, @NotNull List<String> imports) {
            Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
            Intrinsics.checkNotNullParameter(imports, (String)"imports");
            KtImportList ktImportList = ktFile.getImportList();
            if (ktImportList == null) {
                return;
            }
            KtImportList importList = ktImportList;
            Project project = ktFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project, true);
            for (String symbol : imports) {
                if (this.alreadyImported(importList, symbol)) continue;
                KtImportDirective importDirective = psiFactory.createImportDirective(new ImportPath(new FqName(symbol), false, null, 4, null));
                importList.add((PsiElement)importDirective);
            }
        }

        private final boolean alreadyImported(PsiImportList imports, String candidate) {
            boolean bl;
            block1: {
                PsiImportStatementBase[] psiImportStatementBaseArray = imports.getAllImportStatements();
                Intrinsics.checkNotNullExpressionValue((Object)psiImportStatementBaseArray, (String)"getAllImportStatements(...)");
                Object[] $this$any$iv = psiImportStatementBaseArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiImportStatementBase it = (PsiImportStatementBase)element$iv;
                    boolean bl2 = false;
                    PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = it.getImportReference();
                    if (!Intrinsics.areEqual((Object)candidate, (Object)(psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.getQualifiedName() : null))) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final boolean alreadyImported(KtImportList imports, String candidate) {
            boolean bl;
            block3: {
                List list = imports.getImports();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getImports(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtImportDirective it = (KtImportDirective)element$iv;
                        boolean bl2 = false;
                        FqName fqName = it.getImportedFqName();
                        if (!Intrinsics.areEqual((Object)candidate, (Object)(fqName != null ? fqName.asString() : null))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final void shortenJavaReferencesInRange(@NotNull PsiFile file, @NotNull TextRange range) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            PsiElement startPsi = file.findElementAt(range.getStartOffset());
            PsiElement endPsi = file.findElementAt(range.getEndOffset() - 1);
            if (startPsi == null || endPsi == null) {
                return;
            }
            PsiElement psiElement = PsiTreeUtil.findCommonParent((PsiElement)startPsi, (PsiElement)endPsi);
            if (psiElement == null) {
                return;
            }
            PsiElement commonParent = psiElement;
            ArrayList psiInRange = new ArrayList();
            this.collectDisjointDescendantsCoveringRange(commonParent, range, psiInRange);
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)file.getProject());
            Iterator iterator = psiInRange.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                PsiElement psiElement2 = (PsiElement)e;
                if (!psiElement2.isValid()) continue;
                javaCodeStyleManager.shortenClassReferences(psiElement2);
            }
        }

        private final void collectDisjointDescendantsCoveringRange(PsiElement parent, TextRange fileRange, List<PsiElement> out) {
            PsiElement child = parent.getFirstChild();
            while (child != null) {
                TextRange childRange = child.getTextRange();
                if (childRange == null || childRange.isEmpty()) {
                    child = child.getNextSibling();
                    continue;
                }
                if (fileRange.contains(childRange)) {
                    out.add(child);
                } else if (fileRange.intersectsStrict(childRange)) {
                    this.collectDisjointDescendantsCoveringRange(child, fileRange, out);
                }
                child = child.getNextSibling();
            }
        }

        @Nullable
        public final SmartPsiFileRange getRangePointer(@NotNull Project project, @Nullable Location range) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (range != null) {
                Position start = range.getStart();
                Position end = range.getEnd();
                if (start != null && end != null) {
                    PsiFile psiFile;
                    VirtualFile virtualFile = PhysicalFileSystemUtilsKt.toVirtualFile((File)range.getFile());
                    Object object = psiFile = virtualFile != null ? PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)virtualFile, (Project)project) : null;
                    if (psiFile != null) {
                        SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
                        TextRange textRange = TextRange.create((int)start.getOffset(), (int)end.getOffset());
                        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
                        TextRange textRange2 = textRange;
                        return manager.createSmartPsiFileRangePointer(psiFile, textRange2);
                    }
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

