/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;

public class AndroidQuickfixContexts {

    public static class DesignerContext
    extends Context {
        public static final ContextType TYPE = new ContextType();
        private static final DesignerContext INSTANCE = new DesignerContext();

        private DesignerContext() {
            super(TYPE);
        }

        @NotNull
        public static DesignerContext getInstance() {
            return INSTANCE;
        }
    }

    public static class EditorPreviewContext
    extends EditorContext {
        public EditorPreviewContext(@NotNull Editor editor, @Nullable PsiFile file) {
            super(editor, file);
        }
    }

    public static class EditorContext
    extends Context {
        public static final ContextType TYPE = new ContextType();
        private final Editor myEditor;
        private final PsiFile myFile;

        private EditorContext(@NotNull Editor editor, @Nullable PsiFile file) {
            super(TYPE);
            this.myEditor = editor;
            this.myFile = file;
        }

        @Nullable
        public PsiFile getFile() {
            return this.myFile;
        }

        @NotNull
        public Editor getEditor() {
            return this.myEditor;
        }

        @Override
        @Nullable
        public Editor getEditor(@NotNull PsiFile file) {
            if (this.isPreviewFile(file)) {
                return this.myEditor;
            }
            return super.getEditor(file);
        }

        @Override
        @Nullable
        public Document getDocument(@NotNull PsiFile file) {
            if (this.isPreviewFile(file)) {
                return this.myEditor.getDocument();
            }
            return super.getDocument(file);
        }

        private boolean isPreviewFile(@NotNull PsiFile file) {
            return file == this.myFile || this.myFile != null && IntentionPreviewUtils.isIntentionPreviewActive() && file.getName().equals(this.myFile.getName());
        }

        @NotNull
        public static EditorContext getInstance(@NotNull Editor editor, @Nullable PsiFile file) {
            return new EditorContext(editor, file);
        }
    }

    public static class BatchContext
    extends Context {
        public static final ContextType TYPE = new ContextType();
        private static final BatchContext INSTANCE = new BatchContext();

        private BatchContext() {
            super(TYPE);
        }

        @NotNull
        public static BatchContext getInstance() {
            return INSTANCE;
        }
    }

    public static class ContextType {
        private ContextType() {
        }
    }

    public static abstract class Context {
        private final ContextType myType;

        private Context(@NotNull ContextType type) {
            this.myType = type;
        }

        @NotNull
        public ContextType getType() {
            return this.myType;
        }

        @Nullable
        public Editor getEditor(@NotNull PsiFile file) {
            Editor editor = IntentionBasedInspectionKt.findExistingEditor((PsiElement)file);
            if (editor != null) {
                return editor;
            }
            return PsiEditorUtil.findEditor((PsiElement)file);
        }

        @Nullable
        public Document getDocument(@NotNull PsiFile file) {
            return PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        }
    }
}

