/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u001d\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/lint/common/AddSuperCallFix;", "Lcom/intellij/modcommand/PsiBasedModCommandAction;", "Lcom/intellij/psi/PsiElement;", "element", "superMethod", "Lcom/intellij/psi/PsiMethod;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiMethod;)V", "getFamilyName", "", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "Lorg/jetbrains/annotations/NotNull;", "context", "Lcom/intellij/modcommand/ActionContext;", "perform", "Lcom/intellij/modcommand/ModCommand;", "buildSuperStatement", "method", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "intellij.lint"})
@SourceDebugExtension(value={"SMAP\nAddSuperCallFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddSuperCallFix.kt\ncom/android/tools/idea/lint/common/AddSuperCallFix\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 4 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n11158#2:168\n11493#2,3:169\n30#3,2:172\n35#4,13:174\n1#5:187\n1557#6:188\n1628#6,3:189\n*S KotlinDebug\n*F\n+ 1 AddSuperCallFix.kt\ncom/android/tools/idea/lint/common/AddSuperCallFix\n*L\n139#1:168\n139#1:169,3\n146#1:172,2\n146#1:174,13\n162#1:188\n162#1:189,3\n*E\n"})
public final class AddSuperCallFix
extends PsiBasedModCommandAction<PsiElement> {
    @NotNull
    private final PsiMethod superMethod;

    public AddSuperCallFix(@NotNull PsiElement element, @NotNull PsiMethod superMethod) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)superMethod, (String)"superMethod");
        super(element);
        this.superMethod = superMethod;
    }

    @NotNull
    public String getFamilyName() {
        return "AddSuperCallFix";
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Presentation presentation = Presentation.of((String)"Add super call");
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
        return presentation;
    }

    @NotNull
    protected ModCommand perform(@NotNull ActionContext context, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (element.getLanguage() == JavaLanguage.INSTANCE) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (method == null || method.isConstructor()) {
                ModCommand modCommand = ModCommand.nop();
                Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
                return modCommand;
            }
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getElementFactory(...)");
            PsiElementFactory factory = psiElementFactory;
            PsiStatement psiStatement = factory.createStatementFromText(this.buildSuperStatement(method, this.superMethod), null);
            Intrinsics.checkNotNullExpressionValue((Object)psiStatement, (String)"createStatementFromText(...)");
            PsiStatement superStatement = psiStatement;
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)((PsiElement)method), (arg_0, arg_1) -> AddSuperCallFix.perform$lambda$0(superStatement, factory, project2, arg_0, arg_1));
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
            return modCommand;
        }
        if (element.getLanguage() == KotlinLanguage.INSTANCE) {
            KtPsiFactory factory = new KtPsiFactory(project2, false, 2, null);
            KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)element, KtNamedFunction.class);
            if (ktNamedFunction == null) {
                ModCommand modCommand = ModCommand.nop();
                Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
                return modCommand;
            }
            KtNamedFunction method = ktNamedFunction;
            KtExpression superStatement = factory.createExpression(this.buildSuperStatement(method, this.superMethod));
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)((PsiElement)method), (arg_0, arg_1) -> AddSuperCallFix.perform$lambda$1(factory, superStatement, arg_0, arg_1));
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
            return modCommand;
        }
        ModCommand modCommand = ModCommand.nop();
        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
        return modCommand;
    }

    /*
     * WARNING - void declaration
     */
    private final String buildSuperStatement(PsiMethod method, PsiMethod superMethod) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PsiClass containingClass;
        StringBuilder stringBuilder;
        StringBuilder $this$buildSuperStatement_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        PsiClass psiClass = containingClass = superMethod.getContainingClass();
        boolean bl2 = psiClass != null ? psiClass.isInterface() : false;
        if (bl2) {
            $this$buildSuperStatement_u24lambda_u243.append(containingClass.getQualifiedName() + ".");
        }
        $this$buildSuperStatement_u24lambda_u243.append("super." + method.getName() + "(");
        PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        Object[] objectArray = psiParameterArray;
        StringBuilder stringBuilder2 = $this$buildSuperStatement_u24lambda_u243;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiParameter psiParameter = (PsiParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getName());
        }
        stringBuilder2.append(org.jetbrains.kotlin.utils.StringsKt.join((Iterable)((List)destination$iv$iv), (String)","));
        $this$buildSuperStatement_u24lambda_u243.append(");");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final String buildSuperStatement(KtNamedFunction method, PsiMethod superMethod) {
        useSiteElement$iv = (KtElement)method;
        $i$f$analyze = false;
        v0 = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
        var6_6 = KaSessionProvider.Companion.getInstance(v0);
        $i$f$analyze = false;
        analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv);
        try {
            var10_15 = lock$iv$iv = new Object();
            synchronized (var10_15) {
                block13: {
                    block12: {
                        $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv = false;
                        $this$buildSuperStatement_u24lambda_u245 = analysisSession$iv$iv;
                        $i$a$-analyze-AddSuperCallFix$buildSuperStatement$qualifiedClass$1 = false;
                        var14_23 = $this$buildSuperStatement_u24lambda_u245.getSymbol(method);
                        v1 = var14_23 instanceof KaCallableSymbol != false ? (KaCallableSymbol)var14_23 : null;
                        if (v1 != null) break block12;
                        v2 = null;
                        break block13;
                    }
                    ktCallableSymbol = v1;
                    choices = SequencesKt.toList((Sequence)$this$buildSuperStatement_u24lambda_u245.getDirectlyOverriddenSymbols(ktCallableSymbol));
                    if (choices.size() <= 1) ** GOTO lbl-1000
                    v3 = superMethod.getContainingClass();
                    if (v3 != null) {
                        it = v3;
                        $i$a$-let-AddSuperCallFix$buildSuperStatement$qualifiedClass$1$1 = false;
                        v2 = it.getQualifiedName();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = null;
                    }
                }
                $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv = v2;
            }
            lock$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv);
        }
        qualifiedClass = lock$iv$iv;
        $this$buildSuperStatement_u24lambda_u248 = var4_3 = new StringBuilder();
        $i$a$-buildString-AddSuperCallFix$buildSuperStatement$2 = false;
        $this$buildSuperStatement_u24lambda_u248.append("super");
        v4 = qualifiedClass;
        if (v4 != null) {
            it = v4;
            $i$a$-let-AddSuperCallFix$buildSuperStatement$2$1 = false;
            $this$buildSuperStatement_u24lambda_u248.append("<" + (String)it + ">");
        }
        $this$buildSuperStatement_u24lambda_u248.append("." + method.getName() + "(");
        v5 = method.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getValueParameters(...)");
        lock$iv$iv = v5;
        var10_15 = $this$buildSuperStatement_u24lambda_u248;
        $i$f$map = false;
        $i$a$-let-AddSuperCallFix$buildSuperStatement$2$1 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            ktCallableSymbol = (KtParameter)item$iv$iv;
            var16_25 = destination$iv$iv;
            $i$a$-map-AddSuperCallFix$buildSuperStatement$2$2 = false;
            v6 = it.getName();
            if (v6 == null) {
                v6 = "";
            }
            var16_25.add(v6);
        }
        var10_15.append(org.jetbrains.kotlin.utils.StringsKt.join((Iterable)((List)destination$iv$iv), (String)","));
        $this$buildSuperStatement_u24lambda_u248.append(")");
        return var4_3.toString();
    }

    private static final void perform$lambda$0(PsiStatement $superStatement, PsiElementFactory $factory, Project $project, PsiMethod methodCopy, ModPsiUpdater modPsiUpdater) {
        Intrinsics.checkNotNullParameter((Object)methodCopy, (String)"methodCopy");
        Intrinsics.checkNotNullParameter((Object)modPsiUpdater, (String)"<unused var>");
        PsiCodeBlock body = methodCopy.getBody();
        if (body != null) {
            PsiStatement[] psiStatementArray = body.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)psiStatementArray, (String)"getStatements(...)");
            PsiStatement[] statements = psiStatementArray;
            if (!(statements.length == 0)) {
                v1 = body.addBefore((PsiElement)$superStatement, (PsiElement)statements[0]);
            } else {
                PsiWhiteSpace whiteSpace = (PsiWhiteSpace)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)body), PsiWhiteSpace.class);
                if (whiteSpace != null) {
                    String string = whiteSpace.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (StringsKt.startsWith$default((String)string, (String)"\n\n", (boolean)false, (int)2, null)) {
                        PsiElement psiElement = body.replace((PsiElement)$factory.createCodeBlock());
                        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiCodeBlock");
                        body = (PsiCodeBlock)psiElement;
                    }
                }
                v1 = body.add((PsiElement)$superStatement);
            }
            JavaCodeStyleManager.getInstance((Project)$project).shortenClassReferences((PsiElement)body);
        }
    }

    private static final void perform$lambda$1(KtPsiFactory $factory, KtExpression $superStatement, KtNamedFunction methodCopy, ModPsiUpdater modPsiUpdater) {
        KtExpression body;
        Intrinsics.checkNotNullParameter((Object)methodCopy, (String)"methodCopy");
        Intrinsics.checkNotNullParameter((Object)modPsiUpdater, (String)"<unused var>");
        KtBlockExpression bodyBlock = methodCopy.getBodyBlockExpression();
        if (bodyBlock == null && (body = methodCopy.getBodyExpression()) != null) {
            PsiElement eq = null;
            for (PsiElement prev = body.getPrevSibling(); prev != null; prev = prev.getPrevSibling()) {
                if (!(prev instanceof TreeElement) || ((TreeElement)prev).getElementType() != KtTokens.EQ) continue;
                eq = prev;
                break;
            }
            PsiElement parent = body.getParent();
            bodyBlock = $factory.createSingleStatementBlock(body, null, null);
            body.delete();
            PsiElement psiElement = eq;
            if (psiElement != null) {
                psiElement.delete();
            }
            PsiElement psiElement2 = parent.add((PsiElement)bodyBlock);
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
            bodyBlock = (KtBlockExpression)psiElement2;
        }
        if (bodyBlock != null) {
            PsiElement lBrace = bodyBlock.getLBrace();
            if (lBrace != null) {
                bodyBlock.addAfter((PsiElement)$superStatement, lBrace);
            } else {
                List list = bodyBlock.getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStatements(...)");
                List statements = list;
                if (!((Collection)statements).isEmpty()) {
                    bodyBlock.addBefore((PsiElement)$superStatement, (PsiElement)statements.get(0));
                }
            }
            ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)bodyBlock);
        }
    }
}

