/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.concurrency;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FutureCallbackExecutor
implements Executor {
    @NotNull
    private final Executor myExecutor;

    public FutureCallbackExecutor(@NotNull Executor executor) {
        this.myExecutor = executor;
    }

    @NotNull
    public static FutureCallbackExecutor wrap(@NotNull Executor executor) {
        if (executor instanceof FutureCallbackExecutor) {
            return (FutureCallbackExecutor)executor;
        }
        return new FutureCallbackExecutor(executor);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        this.myExecutor.execute(command);
    }

    public <V> V executeAndAwait(@NotNull Callable<V> function) throws ExecutionException, InterruptedException {
        return (V)this.executeAsync(function).get();
    }

    @NotNull
    public <V> ListenableFuture<V> executeAsync(@NotNull Callable<V> function) {
        SettableFuture futureResult = SettableFuture.create();
        this.myExecutor.execute(() -> {
            try {
                futureResult.set(function.call());
            }
            catch (Throwable t) {
                futureResult.setException(t);
            }
        });
        return futureResult;
    }

    public <V> void addCallback(@NotNull ListenableFuture<V> future, @NotNull FutureCallback<? super V> callback) {
        Futures.addCallback(future, callback, (Executor)this);
    }

    public <V> void addConsumer(@NotNull ListenableFuture<V> future, final @NotNull BiConsumer<? super V, Throwable> consumer) {
        this.addCallback(future, new FutureCallback<V>(){

            public void onSuccess(@Nullable V result) {
                consumer.accept(result, null);
            }

            public void onFailure(@NotNull Throwable t) {
                consumer.accept(null, t);
            }
        });
    }

    public <V> void addListener(@NotNull ListenableFuture<V> future, @NotNull Runnable listener) {
        future.addListener(listener, this.myExecutor);
    }

    @NotNull
    public <I, O> ListenableFuture<O> transform(@NotNull ListenableFuture<I> input, @NotNull ThrowableFunction<? super I, ? extends O> function) {
        return Futures.transformAsync(input, in -> {
            SettableFuture futureResult = SettableFuture.create();
            futureResult.set(function.apply((Object)in));
            return futureResult;
        }, (Executor)this.myExecutor);
    }

    @NotNull
    public <I, O> ListenableFuture<O> transformAsync(@NotNull ListenableFuture<I> input, @NotNull AsyncFunction<? super I, ? extends O> function) {
        return Futures.transformAsync(input, function, (Executor)this.myExecutor);
    }

    @NotNull
    public <V, X extends Throwable> ListenableFuture<V> catching(@NotNull ListenableFuture<? extends V> input, Class<X> exceptionType, @NotNull Function<? super X, ? extends V> fallback) {
        return Futures.catching(input, exceptionType, fallback::apply, (Executor)this);
    }

    @NotNull
    public <V, X extends Throwable> ListenableFuture<V> catchingAsync(@NotNull ListenableFuture<? extends V> input, Class<X> exceptionType, @NotNull AsyncFunction<? super X, ? extends V> fallback) {
        return Futures.catchingAsync(input, exceptionType, fallback, (Executor)this);
    }

    @NotNull
    public <I> ListenableFuture<I> finallySync(@NotNull ListenableFuture<I> input, @NotNull Runnable finallyBlock) {
        SettableFuture futureResult = SettableFuture.create();
        this.addConsumer(input, (i, futureThrowable) -> {
            try {
                finallyBlock.run();
                futureResult.set(i);
            }
            catch (Throwable finallyError) {
                if (futureThrowable != null) {
                    futureThrowable.addSuppressed(finallyError);
                    futureResult.setException(futureThrowable);
                }
                futureResult.setException(finallyError);
            }
        });
        return futureResult;
    }

    @NotNull
    public <I> ListenableFuture<I> finallyAsync(@NotNull ListenableFuture<I> input, @NotNull Callable<ListenableFuture<Unit>> finallyBlock) {
        SettableFuture futureResult = SettableFuture.create();
        this.addConsumer(input, (i, futureThrowable) -> {
            try {
                ListenableFuture futureFinallyBlock = (ListenableFuture)finallyBlock.call();
                this.addConsumer(futureFinallyBlock, (aUnit, finallyError) -> {
                    if (futureThrowable != null) {
                        if (finallyError != null) {
                            futureThrowable.addSuppressed((Throwable)finallyError);
                        }
                        futureResult.setException(futureThrowable);
                    } else if (finallyError != null) {
                        futureResult.setException(finallyError);
                    } else {
                        futureResult.set(i);
                    }
                });
            }
            catch (Throwable t) {
                if (futureThrowable != null) {
                    futureResult.setException(futureThrowable);
                }
                futureResult.setException(t);
            }
        });
        return futureResult;
    }

    @NotNull
    public <T> ListenableFuture<Unit> executeFuturesInSequence(@NotNull Iterator<T> iterator, @NotNull Function<T, ListenableFuture<Unit>> taskFactory) {
        SettableFuture finalResult = SettableFuture.create();
        this.executeFuturesInSequenceWorker(iterator, taskFactory, (SettableFuture<Unit>)finalResult);
        return finalResult;
    }

    private <T> void executeFuturesInSequenceWorker(@NotNull Iterator<T> iterator, @NotNull Function<T, ListenableFuture<Unit>> taskFactory, @NotNull SettableFuture<Unit> finalResult) {
        if (iterator.hasNext()) {
            ListenableFuture<Unit> future = taskFactory.apply(iterator.next());
            this.addConsumer(future, (aUnit, throwable) -> this.executeFuturesInSequenceWorker(iterator, taskFactory, finalResult));
        } else {
            finalResult.set((Object)Unit.INSTANCE);
        }
    }

    @FunctionalInterface
    public static interface ThrowableFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

