/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.cmake.CMakeBundle;
import com.jetbrains.cmake.inspections.ArgumentsMismatch;
import com.jetbrains.cmake.inspections.CMakeMismatchedCommandArgumentsInspectionKt;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandArguments;
import com.jetbrains.cmake.psi.CMakeEndForeachCommand;
import com.jetbrains.cmake.psi.CMakeEndFunctionCommand;
import com.jetbrains.cmake.psi.CMakeEndIfCommand;
import com.jetbrains.cmake.psi.CMakeEndMacroCommand;
import com.jetbrains.cmake.psi.CMakeEndWhileCommand;
import com.jetbrains.cmake.psi.CMakeVisitor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cmake/inspections/CMakeMismatchedCommandArgumentsInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isEnabledByDefault", "", "getDefaultLevel", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "getGroupPath", "", "", "()[Ljava/lang/String;", "getGroupDisplayName", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "Companion", "intellij.cmake.psi"})
public final class CMakeMismatchedCommandArgumentsInspection
extends LocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final LocalQuickFix REMOVE_ARGUMENT_FIX = new LocalQuickFix(){

        public String getFamilyName() {
            String string = CMakeBundle.message("cmake.command.arguments.mismatch.remove", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(Project project, ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PsiElement psiElement = descriptor.getPsiElement();
            CMakeCommandArguments cMakeCommandArguments = psiElement instanceof CMakeCommandArguments ? (CMakeCommandArguments)psiElement : null;
            if (cMakeCommandArguments == null) {
                return;
            }
            CMakeCommandArguments elem = cMakeCommandArguments;
            elem.deleteChildRange(elem.getFirstArgument(), elem.getLastArgument());
        }
    };
    @NotNull
    private static final LocalQuickFix ADJUST_ARGUMENTS_FIX = new LocalQuickFix(){

        public String getFamilyName() {
            String string = CMakeBundle.message("cmake.command.arguments.mismatch.adjust", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(Project project, ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PsiElement psiElement = descriptor.getPsiElement();
            CMakeCommandArguments cMakeCommandArguments = psiElement instanceof CMakeCommandArguments ? (CMakeCommandArguments)psiElement : null;
            if (cMakeCommandArguments == null) {
                return;
            }
            CMakeCommandArguments elem = cMakeCommandArguments;
            List expectedArgs = CMakeMismatchedCommandArgumentsInspectionKt.access$getExpectedArguments(elem);
            elem.deleteChildRange(elem.getFirstArgument(), elem.getLastArgument());
            for (String arg : expectedArgs) {
                elem.appendArgumentRaw(arg);
            }
        }
    };

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.WARNING;
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{CMakeBundle.message("group.path.cmake", new Object[0]), this.getGroupDisplayName()};
        return stringArray;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = CMakeBundle.message("cmake.inspection.group.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new CMakeVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            private final void reportMismatch(ArgumentsMismatch mismatch) {
                if (mismatch == null || CMakeMismatchedCommandArgumentsInspectionKt.access$hasErrors(mismatch.getElement())) {
                    return;
                }
                Object[] objectArray = new Object[]{mismatch.getExpectedArgStr()};
                String string = CMakeBundle.message("cmake.command.arguments.opened.with.0", objectArray);
                objectArray = new LocalQuickFix[]{CMakeMismatchedCommandArgumentsInspection.Companion.getREMOVE_ARGUMENT_FIX(), CMakeMismatchedCommandArgumentsInspection.Companion.getADJUST_ARGUMENTS_FIX()};
                this.$holder.registerProblem((PsiElement)mismatch.getElement(), mismatch.getHighlightingRange(), string, (LocalQuickFix[])objectArray);
            }

            private final ArgumentsMismatch checkSameArguments(CMakeCommand cmd) {
                CMakeCommandArguments cMakeCommandArguments = cmd.getCMakeCommandArguments();
                if (cMakeCommandArguments == null) {
                    return null;
                }
                CMakeCommandArguments cmdArgs = cMakeCommandArguments;
                if (!cmdArgs.hasArguments()) {
                    return null;
                }
                List openingCmdArgs = CMakeMismatchedCommandArgumentsInspectionKt.access$getParentCommandArguments(cmd);
                if (Intrinsics.areEqual((Object)openingCmdArgs, (Object)CMakeMismatchedCommandArgumentsInspectionKt.access$asStringArguments(cmdArgs.getCMakeArgumentList()))) {
                    return null;
                }
                return new ArgumentsMismatch(cmdArgs, openingCmdArgs);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean repeatsName(CMakeCommandArguments cmdArgs, List<String> openingArgs) {
                if (cmdArgs.getCMakeArgumentList().size() != 1) return false;
                if (((Collection)openingArgs).isEmpty()) return false;
                boolean bl = true;
                if (!bl) return false;
                CMakeArgument cMakeArgument = cmdArgs.getFirstArgument();
                Intrinsics.checkNotNull((Object)cMakeArgument);
                if (!Intrinsics.areEqual((Object)cMakeArgument.getText(), (Object)openingArgs.get(0))) return false;
                return true;
            }

            private final ArgumentsMismatch checkRepeatsName(CMakeCommand cmd) {
                CMakeCommandArguments cMakeCommandArguments = cmd.getCMakeCommandArguments();
                if (cMakeCommandArguments == null) {
                    return null;
                }
                CMakeCommandArguments cmdArgs = cMakeCommandArguments;
                if (!cmdArgs.hasArguments()) {
                    return null;
                }
                List openingCmdArgs = CMakeMismatchedCommandArgumentsInspectionKt.access$getParentCommandArguments(cmd);
                if (this.repeatsName(cmdArgs, openingCmdArgs)) {
                    return null;
                }
                return new ArgumentsMismatch(cmdArgs, openingCmdArgs);
            }

            private final void checkExactMatchOrNameRepeat(CMakeCommand cmd) {
                if (this.checkSameArguments(cmd) == null) {
                    return;
                }
                ArgumentsMismatch repeatsName = this.checkRepeatsName(cmd);
                this.reportMismatch(repeatsName);
            }

            public void visitCMakeEndWhileCommand(CMakeEndWhileCommand endWhileCmd) {
                Intrinsics.checkNotNullParameter((Object)endWhileCmd, (String)"endWhileCmd");
                ArgumentsMismatch argMismatch = this.checkSameArguments(endWhileCmd);
                this.reportMismatch(argMismatch);
            }

            public void visitCMakeEndIfCommand(CMakeEndIfCommand endIfCmd) {
                Intrinsics.checkNotNullParameter((Object)endIfCmd, (String)"endIfCmd");
                ArgumentsMismatch argMismatch = this.checkSameArguments(endIfCmd);
                this.reportMismatch(argMismatch);
            }

            public void visitCMakeEndForeachCommand(CMakeEndForeachCommand endForEachCmd) {
                Intrinsics.checkNotNullParameter((Object)endForEachCmd, (String)"endForEachCmd");
                this.checkExactMatchOrNameRepeat(endForEachCmd);
            }

            public void visitCMakeEndFunctionCommand(CMakeEndFunctionCommand endFunctionCmd) {
                Intrinsics.checkNotNullParameter((Object)endFunctionCmd, (String)"endFunctionCmd");
                this.checkExactMatchOrNameRepeat(endFunctionCmd);
            }

            public void visitCMakeEndMacroCommand(CMakeEndMacroCommand endMacroCmd) {
                Intrinsics.checkNotNullParameter((Object)endMacroCmd, (String)"endMacroCmd");
                this.checkExactMatchOrNameRepeat(endMacroCmd);
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cmake/inspections/CMakeMismatchedCommandArgumentsInspection$Companion;", "", "<init>", "()V", "REMOVE_ARGUMENT_FIX", "Lcom/intellij/codeInspection/LocalQuickFix;", "getREMOVE_ARGUMENT_FIX", "()Lcom/intellij/codeInspection/LocalQuickFix;", "ADJUST_ARGUMENTS_FIX", "getADJUST_ARGUMENTS_FIX", "intellij.cmake.psi"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalQuickFix getREMOVE_ARGUMENT_FIX() {
            return REMOVE_ARGUMENT_FIX;
        }

        @NotNull
        public final LocalQuickFix getADJUST_ARGUMENTS_FIX() {
            return ADJUST_ARGUMENTS_FIX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

