/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.documentation;

import com.intellij.model.Pointer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointersKt;
import com.jetbrains.cmake.CMakePsiLog;
import com.jetbrains.cmake.completion.contributors.providers.CMakeStandardCommands;
import com.jetbrains.cmake.documentation.CMakeDocumentationPageProvider;
import com.jetbrains.cmake.documentation.CMakeDocumentationUsageCollector;
import com.jetbrains.cmake.documentation.CMakeDocumentationUtilKt;
import com.jetbrains.cmake.documentation.CMakeElementDocumentationTargetPointer;
import com.jetbrains.cmake.documentation.DocumentationKind;
import com.jetbrains.cmake.documentation.PropertyKind;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandName;
import com.jetbrains.cmake.psi.CMakeCommandNameMixin;
import com.jetbrains.cmake.psi.CMakeElement;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import com.jetbrains.cmake.resolve.command.CMakeStandardCommandElement;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000  2\u00020\u0001:\u0001 B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J \u0010\u0017\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/jetbrains/cmake/documentation/CMakeElementDocumentationTarget;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "element", "Lcom/jetbrains/cmake/psi/CMakeElement;", "pageProvider", "Lcom/jetbrains/cmake/documentation/CMakeDocumentationPageProvider;", "anchor", "", "<init>", "(Lcom/jetbrains/cmake/psi/CMakeElement;Lcom/jetbrains/cmake/documentation/CMakeDocumentationPageProvider;Ljava/lang/String;)V", "getElement", "()Lcom/jetbrains/cmake/psi/CMakeElement;", "pointer", "Lcom/jetbrains/cmake/documentation/CMakeElementDocumentationTargetPointer;", "getPageProvider", "()Lcom/jetbrains/cmake/documentation/CMakeDocumentationPageProvider;", "getAnchor", "()Ljava/lang/String;", "createPointer", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "checkCMakeLiteral", "Lkotlin/Pair;", "Lcom/jetbrains/cmake/documentation/DocumentationKind;", "literal", "Lcom/jetbrains/cmake/psi/CMakeLiteral;", "isPolicyName", "isModuleName", "isProperty", "isVariable", "Companion", "intellij.cmake.psi"})
@SourceDebugExtension(value={"SMAP\nCMakeElementDocumentationTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMakeElementDocumentationTarget.kt\ncom/jetbrains/cmake/documentation/CMakeElementDocumentationTarget\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,237:1\n62#2,5:238\n62#2,5:243\n*S KotlinDebug\n*F\n+ 1 CMakeElementDocumentationTarget.kt\ncom/jetbrains/cmake/documentation/CMakeElementDocumentationTarget\n*L\n62#1:238,5\n88#1:243,5\n*E\n"})
public final class CMakeElementDocumentationTarget
implements DocumentationTarget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CMakeElement element;
    @NotNull
    private final CMakeElementDocumentationTargetPointer pointer;
    @NotNull
    private static final Pair<String, DocumentationKind> EMPTY_PAIR = new Pair(null, null);

    public CMakeElementDocumentationTarget(@NotNull CMakeElement element, @NotNull CMakeDocumentationPageProvider pageProvider, @Nullable String anchor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)pageProvider, (String)"pageProvider");
        this.element = element;
        this.pointer = new CMakeElementDocumentationTargetPointer((Pointer<? extends CMakeElement>)((Pointer)SmartPointersKt.createSmartPointer((PsiElement)this.element)), pageProvider, anchor);
    }

    public /* synthetic */ CMakeElementDocumentationTarget(CMakeElement cMakeElement, CMakeDocumentationPageProvider cMakeDocumentationPageProvider, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(cMakeElement, cMakeDocumentationPageProvider, string);
    }

    @NotNull
    public final CMakeElement getElement() {
        return this.element;
    }

    @NotNull
    public final CMakeDocumentationPageProvider getPageProvider() {
        return this.pointer.getPageProvider();
    }

    private final String getAnchor() {
        return this.pointer.getAnchor();
    }

    @NotNull
    public CMakeElementDocumentationTargetPointer createPointer() {
        return this.pointer;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        CMakeElement cMakeElement = this.element;
        Object object = cMakeElement instanceof PsiNamedElement ? (PsiNamedElement)cMakeElement : null;
        if (object == null || (object = object.getName()) == null) {
            object = this.element.getText();
        }
        Object object2 = object;
        Intrinsics.checkNotNull((Object)object2);
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder((String)object2).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @Nullable
    public DocumentationResult computeDocumentation() {
        Pair pair;
        Logger $this$debug_u24default$iv = CMakePsiLog.INSTANCE.getLOG();
        CMakeElement e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Requested documentation for element: " + this.element, e$iv);
        }
        CMakeDocumentationUsageCollector.REQUESTED.log(this.element.getProject(), this.element.getClass());
        e$iv = this.element;
        if (e$iv instanceof CMakeCommand) {
            String string;
            String string2 = CMakePsiUtils.findCommandName(this.element);
            if (string2 != null) {
                String string3 = string2.toLowerCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            } else {
                string = null;
            }
            pair = new Pair((Object)string, (Object)DocumentationKind.COMMAND);
        } else if (e$iv instanceof CMakeCommandName) {
            String string = ((CMakeCommandName)this.element).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string4 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            pair = new Pair((Object)string4, (Object)DocumentationKind.COMMAND);
        } else if (e$iv instanceof CMakeCommandNameMixin) {
            String string = ((CMakeCommandNameMixin)this.element).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string5 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
            pair = new Pair((Object)string5, (Object)DocumentationKind.COMMAND);
        } else if (e$iv instanceof CMakeLiteral) {
            pair = this.checkCMakeLiteral((CMakeLiteral)this.element);
        } else if (e$iv instanceof CMakeStandardCommandElement) {
            String string = ((CMakeStandardCommandElement)this.element).getCommandName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            pair = new Pair((Object)string, (Object)DocumentationKind.COMMAND);
        } else {
            pair = EMPTY_PAIR;
        }
        Pair pair2 = pair;
        String name = (String)pair2.component1();
        DocumentationKind kind = (DocumentationKind)((Object)pair2.component2());
        if (name == null || kind == null) {
            return null;
        }
        Project project = this.element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        return DocumentationResult.Companion.asyncDocumentation(() -> CMakeElementDocumentationTarget.computeDocumentation$lambda$2(this, name, kind, project2));
    }

    private final Pair<String, DocumentationKind> checkCMakeLiteral(CMakeLiteral literal) {
        String policy = this.isPolicyName(literal);
        if (policy != null) {
            return new Pair((Object)policy, (Object)DocumentationKind.POLICY);
        }
        String module = this.isModuleName(literal);
        if (module != null) {
            return new Pair((Object)module, (Object)DocumentationKind.MODULE);
        }
        Pair<String, DocumentationKind> pair = this.isProperty(literal);
        String property = (String)pair.component1();
        DocumentationKind kind = (DocumentationKind)((Object)pair.component2());
        if (property != null && kind != null) {
            return new Pair((Object)property, (Object)kind);
        }
        String variable = this.isVariable(literal);
        return new Pair((Object)variable, (Object)DocumentationKind.VARIABLE);
    }

    private final String isPolicyName(CMakeLiteral literal) {
        CMakeArgument argument = literal.getArgument();
        Intrinsics.checkNotNull((Object)argument);
        CMakeCommand cMakeCommand = CMakePsiUtils.getCommand(argument);
        if (cMakeCommand == null) {
            return null;
        }
        CMakeCommand command = cMakeCommand;
        if (!CMakePsiUtils.isCommand(command, CMakeStandardCommands.CMAKE_POLICY)) {
            return null;
        }
        CMakeArgument cMakeArgument = argument.getPreviousArgument();
        if (cMakeArgument == null) {
            return null;
        }
        CMakeArgument prevArgument = cMakeArgument;
        String prevArgumentText = prevArgument.getText();
        if (!StringsKt.equals((String)prevArgumentText, (String)"SET", (boolean)true) && !StringsKt.equals((String)prevArgumentText, (String)"GET", (boolean)true)) {
            return null;
        }
        if (prevArgument.getPreviousArgument() != null) {
            return null;
        }
        String string = literal.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        return string2;
    }

    private final String isModuleName(CMakeLiteral literal) {
        CMakeArgument argument = literal.getArgument();
        Intrinsics.checkNotNull((Object)argument);
        CMakeCommand cMakeCommand = CMakePsiUtils.getCommand(argument);
        if (cMakeCommand == null) {
            return null;
        }
        CMakeCommand command = cMakeCommand;
        if (!CMakePsiUtils.isCommand(command, CMakeStandardCommands.INCLUDE_COMMAND_NAME) && !CMakePsiUtils.isCommand(command, CMakeStandardCommands.FIND_PACKAGE)) {
            return null;
        }
        if (argument.getPreviousArgument() != null) {
            return null;
        }
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.INCLUDE_COMMAND_NAME)) {
            String text = literal.getText();
            Intrinsics.checkNotNull((Object)text);
            if (!StringsKt.contains$default((CharSequence)text, (CharSequence)"/", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)text, (CharSequence)".", (boolean)false, (int)2, null)) {
                return text;
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.FIND_PACKAGE)) {
            return "Find" + literal.getText();
        }
        return null;
    }

    private final Pair<String, DocumentationKind> isProperty(CMakeLiteral literal) {
        CMakeArgument cMakeArgument = literal.getArgument();
        Intrinsics.checkNotNullExpressionValue((Object)cMakeArgument, (String)"getArgument(...)");
        CMakeCommand cMakeCommand = CMakePsiUtils.getCommand(cMakeArgument);
        if (cMakeCommand == null) {
            return EMPTY_PAIR;
        }
        CMakeCommand command = cMakeCommand;
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.DEFINE_PROPERTY)) {
            return EMPTY_PAIR;
        }
        String name = literal.getText();
        CMakeArgument cMakeArgument2 = literal.getArgument();
        Intrinsics.checkNotNullExpressionValue((Object)cMakeArgument2, (String)"getArgument(...)");
        PropertyKind propertyKind = CMakeDocumentationUtilKt.getPropertyKind(cMakeArgument2);
        DocumentationKind kind = switch (propertyKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[propertyKind.ordinal()]) {
            case 1 -> DocumentationKind.GLOBAL_PROPERTY;
            case 2 -> DocumentationKind.DIRECTORY_PROPERTY;
            case 3 -> DocumentationKind.TARGET_PROPERTY;
            case 4 -> DocumentationKind.SOURCE_PROPERTY;
            case 5 -> DocumentationKind.INSTALL_PROPERTY;
            case 6 -> DocumentationKind.TEST_PROPERTY;
            case 7 -> DocumentationKind.CACHE_PROPERTY;
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
        if (name == null || kind == null) {
            return EMPTY_PAIR;
        }
        String string = name.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return new Pair((Object)string, (Object)kind);
    }

    private final String isVariable(CMakeLiteral literal) {
        String text = literal.getText();
        Intrinsics.checkNotNull((Object)text);
        if (CMakePsiUtils.isVariableRef(text)) {
            String string = CMakePsiUtils.stripVariableRef(text).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            return string;
        }
        String string = text.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string;
    }

    private static final DocumentationResult.Documentation computeDocumentation$lambda$2(CMakeElementDocumentationTarget this$0, String $name, DocumentationKind $kind, Project $project) {
        String string = this$0.getPageProvider().getDocumentationPage($name, $kind);
        if (string == null) {
            return null;
        }
        String page = string;
        Logger $this$debug_u24default$iv = CMakePsiLog.INSTANCE.getLOG();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Showing documentation for element: " + this$0.element + ", anchor: " + this$0.getAnchor() + ", name: " + $name + ", kind: " + $kind, e$iv);
        }
        CMakeDocumentationUsageCollector.SHOWN.log($project, (Object)$kind, (Object)(this$0.getAnchor() != null ? 1 : 0));
        return DocumentationResult.Companion.documentation(page).anchor(this$0.getAnchor());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cmake/documentation/CMakeElementDocumentationTarget$Companion;", "", "<init>", "()V", "EMPTY_PAIR", "Lkotlin/Pair;", "", "Lcom/jetbrains/cmake/documentation/DocumentationKind;", "intellij.cmake.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PropertyKind.values().length];
            try {
                nArray[PropertyKind.GLOBAL_PROPERTY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyKind.DIRECTORY_PROPERTY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyKind.TARGET_PROPERTY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyKind.SOURCE_PROPERTY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyKind.INSTALL_PROPERTY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyKind.TEST_PROPERTY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyKind.CACHE_PROPERTY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

